function plot_by_categories(data_array, style_cell, label_cell, legend_strings)
% function plot_by_categories(data_array, style_cell, label_cell. legend_strings)
%
% CVS_Version_String = '$Id: plot_by_categories.m,v 1.1 2004/03/15 12:58:42 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


figure;
hold on;

for i=1:size(data_array,1)
	plot( data_array(i,:), style_cell{i},'linewidth',1);
end


set(gca,'XTick',(1:(size(data_array,2))+1));
set(gca,'XTickLabel','');
set(gca,'TickDir','out');

height_axis_rel = get(gca,'Position');
height_axis_rel = height_axis_rel(4);
y_limits = get(gca,'YLim');
y_length = y_limits(2) - y_limits(1);
rel_per_coord = height_axis_rel / y_length;
ticks_lengths = get(gca,'TickLength');
text_y_pos = y_limits(1) - 3 * ticks_lengths(1)/rel_per_coord;


for i=1:length(label_cell),
	text(i, text_y_pos, label_cell{i}, 'Rotation',90, ...
	   'HorizontalAlignment','right', 'Interpreter','none','FontSize',6);
end

p=get(gca,'Position');
set(gca,'Position',[p(1) p(2)+0.2 p(3) p(4)-0.2]);
legend(legend_strings,0);

