function create_stateSeq( exp_name, model_info, speaker, session, recording, model_for_test, model_archive )
% create_stateSeq( exp_name, model_info, recording, model_for_test, model_archive )
%
% CVS_Version_String = '$Id: create_stateSeq.m,v 1.7 2004/04/29 11:27:57 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


if (isempty(model_archive)),
	disp('There is no model archive!!');
	return;
end


SR_lib;


checksum = sum(model_archive); % id as checksum

%sv_system_path = fullfile(basepath, exp_name);
sv_system_path = fullfile('/tmp/MASV_temp_sv_systems', [exp_name '_' num2str(checksum)]);

% test if model archive has already been extracted
command = [ 'test -d ' sv_system_path ];
result=unix( command );
if (result == 1),
	%extract archive
	command = [ 'mkdir -p  ' sv_system_path ];
	result=unix( command );
	
	fid = fopen( fullfile(sv_system_path, 'temp_archive.tar.bzip2'), 'w');
	fwrite(fid,model_archive, 'uint8');
	fclose(fid);	

	command = [ 'cd ' sv_system_path '; tar -j -xf temp_archive.tar.bzip2'  ];
	result=unix( command );
end



if (strcmp(model_for_test, 'world')),
	model_name = model_info.world_session_details.hmm_baseDirs_array{1};
	model_version = model_info.world_model_version{1};
	model_path = fullfile(sv_system_path, 'world');
else,
	model_name = model_info.training_session_details.hmm_baseDirs_array{1};
	model_version = model_info.trained_models_version{1};
	model_path = fullfile(sv_system_path, model_for_test);
end

recording_full_path = fullfile( sv_system_path, 'links', 'currentParamPool', speaker, session, recording );

command1 = 'HVite -T 0004 -a -i /tmp/tmp.mlf ';
command2 = ['-d ' model_path '/' model_name '/hmm.' model_version ' '];
command3 = ['-I ' sv_system_path '/' model_info.lab_mlf  ' ' basepath '/../syntax/' model_info.dict ' ' basepath '/../hmm_lists/' model_info.hmm_list ' '];
command4 = [recording_full_path ' > /tmp/state_seq_tmp.txt'];
command = [command1 command2 command3 command4 ];
unix( command );

command_output{1} = command;
textwrite(['/tmp/state_seq_command_' model_for_test], command_output);
