function do_bootstrap_det( bootstrap_size, sample_size, rs )
% function do_bootstrap_det( bootstrap_size, sample_size, rs )
%
% CVS_Version_String = '$Id: do_bootstrap_det.m,v 1.4 2004/05/25 15:08:30 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

	bs_id = '_bs_det_';
	
	name = rs.result_name;
	name_base = [ name bs_id ];
	name_search = [ rs.exp_name '-' name_base '*' ];

	d = dir( name_search );

	
	version_numbers = [];
	for i = 1:length(d),
		id_indizes = findstr( d(i).name, bs_id );
		sub_part = d(i).name( id_indizes(1) + length(bs_id) + 1: end );
		undscr_indizes = findstr( sub_part, '_' ); 
		version_no_str = sub_part( 1: (undscr_indizes(1) - 1));
		version_numbers(i) = str2num( version_no_str );
	end
	
	if ( ~isempty(version_numbers)),
		version_start = max(version_numbers) + 1;
	else	
		version_start = 1;
	end
	
	%keyboard;
	
	pop_indizes = 1:length(rs.model_info.trained_models);
	
	
	for bs_version = version_start:bootstrap_size,
		version_string = sprintf('%05d', bs_version);
		disp( [' Current bootstrap sample: ' version_string ] );
		sr_name = [ name_base version_string ];
		sample_indizes = draw_samples_from_pop( pop_indizes, sample_size );
		selected_spks = rs.model_info.trained_models( sample_indizes );
		
		sr=calc_score_result(rs,'det_bs_sample',['bootstrap det ' version_string],'bootstrap det',0, selected_spks , {'all'},{'without training'},{'all'});
		sr.part{1}.data = rmfield( sr.part{1}.data, 'FRs' );
		sr.part{1}.data = rmfield( sr.part{1}.data, 'FAs' );
		sr.part{1}.data = rmfield( sr.part{1}.data, 'borders_common' );

		sr=rename_result( sr, sr_name );
		
		save_score_result( sr, pwd );
		

	end
