function do_bootstrap_det_on_score( bootstrap_size, sr_data, det_part_id )
% function do_bootstrap_det_on_score( bootstrap_size, sr_data, det_part_id )
%
% CVS_Version_String = '$Id: do_bootstrap_det_on_score.m,v 1.2 2004/06/01 13:05:48 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

	bs_id = '_bs_det_';
	sub_sampling_ci = 100; % every 100th FR/FA pair is used for calculation conf. intervals
	
	name = sr_data.result_name;
	name_base = [ name bs_id ];
	name_search = [ sr_data.exp_name '-' name_base '*' ];

	d = dir( name_search );

	
	version_numbers = [];
	for i = 1:length(d),
		id_indizes = findstr( d(i).name, bs_id );
		sub_part = d(i).name( id_indizes(1) + length(bs_id) + 1: end );
		undscr_indizes = findstr( sub_part, '_' ); 
		version_no_str = sub_part( 1: (undscr_indizes(1) - 1));
		version_numbers(i) = str2num( version_no_str );
	end
	
	if ( ~isempty(version_numbers)),
		version_start = max(version_numbers) + 1;
	else	
		version_start = 1;
	end
	
	%keyboard;
	
	pop_indizes_fr = find( sr_data.part{det_part_id}.data.type_common == 1);
	pop_indizes_fa = find( sr_data.part{det_part_id}.data.type_common == 0);
	
	sample_size_fr = length( pop_indizes_fr );
	sample_size_fa = length( pop_indizes_fa );
	
	for bs_version = version_start:bootstrap_size,
		version_string = sprintf('%05d', bs_version);
		disp( [' Current bootstrap sample: ' version_string ] );
		sr_name = [ name_base version_string ];
		sample_indizes_fr = draw_bst_samples_from_pop( pop_indizes_fr, sample_size_fr );
		sample_indizes_fa = draw_bst_samples_from_pop( pop_indizes_fa, sample_size_fa );
		
		sample_fr_th = sr_data.part{det_part_id}.data.borders_common( sample_indizes_fr );
		sample_fa_th = sr_data.part{det_part_id}.data.borders_common( sample_indizes_fa );

		sample_fr_th=sort(double(sample_fr_th));
		sample_fa_th=sort(double(sample_fa_th));
		
		
		[FR, FA, borders_common, type_common, fr_fa_sort_index] = calc_FR_FA_pairs(sample_fr_th, sample_fa_th);
		
		FR_sub = sub_sample_vector( FR, sub_sampling_ci );
		FA_sub = sub_sample_vector( FA, sub_sampling_ci );
		borders_common_sub = sub_sample_vector( borders_common, sub_sampling_ci );
		
		
		sr=create_score_result( FR_sub, FA_sub, borders_common_sub, sr_data, det_part_id );
		sr=rename_result( sr, sr_name );
		
		save_score_result( sr, pwd );
		

	end
	
return;


	function score_result_struct = create_score_result( FRs, FAs, borders_common, sr_data, part_id),
	
		score_result_struct=struct('exp_name','','result_name','');
		
		% use last loaded sr as basis
		score_result_struct.exp_name = sr_data.exp_name;
		score_result_struct.result_name = 'empty';
		score_result_struct.full_name = [score_result_struct.exp_name '-' score_result_struct.result_name];
		if isfield(sr_data, 'info'),
			score_result_struct.info = sr_data.info;
		end
		score_result_struct.part = {};
	
		menu_descr = ['btstrp sample'];
		description = [menu_descr '; bootstrap sample'];
		
		part_index = 1;
		score_result_struct.part{part_index}.menu_descr = menu_descr;
		score_result_struct.part{part_index}.description = description;
		if (isfield(score_result_struct.part{part_index}, 'cross_validation_flag')),
			score_result_struct.part{part_index}.cross_validation_flag = sr_data.part{part_id}.cross_validation_flag;
		else
			score_result_struct.part{part_index}.cross_validation_flag = 0;
		end
		score_result_struct.part{part_index}.result_type = 'det_bs_sample';
		
		
		score_result_struct.part{part_index}.data.fr_av_of_att = FRs;
		score_result_struct.part{part_index}.data.fa_av_of_att = FAs;
		score_result_struct.part{part_index}.data.thresholds = borders_common;

		score_result_struct.part{part_index}.info = description;
		
		score_result_struct.part{part_index}.imp_spks_list = sr_data.part{part_id}.imp_spks_list;
		score_result_struct.part{part_index}.fr_sel_sessions = sr_data.part{part_id}.fr_sel_sessions;
		score_result_struct.part{part_index}.fa_sel_sessions = sr_data.part{part_id}.fa_sel_sessions;
		num_of_models = length(sr_data.part{part_id}.model);
		for i=1:num_of_models
			score_result_struct.part{part_index}.model(i).data.fa_N_tests=sr_data.part{part_id}.model(i).data.fa_N_tests;
			score_result_struct.part{part_index}.model(i).data.fr_N_tests=sr_data.part{part_id}.model(i).data.fr_N_tests;
		end

	return;
	
	
	function sub_sampled_data = sub_sample_vector( data, N )
		indizes = 1:N:length(data);
		if (indizes(end) ~= length(data) ),
			indizes(end+1) = length(data);
		end
		sub_sampled_data = data(indizes);

