function found_index = find_session_rec_string(strings, item)
% function found_index = find_session_rec_string(strings, item)
%
% CVS_Version_String = '$Id: find_session_rec_string.m,v 1.6 2004/04/14 12:49:59 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	found_index = 0;
	for i=1:size(strings,1),
		sub_str = strings(i,(6:end));
		if ~(isempty(sub_str));
			index = strmatch(sub_str,item);
			if ~(isempty(index)) & (index == 1),
				found_index = i;
				break;
			end
		end
	end
