function indizes_array=get_combination_indizes(data_indizes,N_combination)
% function indizes_array=get_combination_indizes(data_indizes,N_combination)
%
% CVS_Version_String = '$Id: get_combination_indizes.m,v 1.6 2004/04/01 14:34:06 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	
	l = length(data_indizes);
	
	if ((l == 1) | (N_combination == 1) ),
		indizes_array = [data_indizes];
		return;
	elseif (l == 0)
		indizes_array = [];
		return;
	end
	
	first_indizes = [];
	second_indizes = [];
	
	if (N_combination == 2),
		for i=1:(l-1),
			first_indizes = [first_indizes repmat(data_indizes(i),1,(l-i))];
			second_indizes = [second_indizes data_indizes((i+1):1:l)];
		end
	end
	
	indizes_array = [first_indizes; second_indizes];
