function [models, varargout] = read_force_aligned_config(sv_system_name, test_type )
%
% function [models, [imp_tested_models], sessions_details, model_versions] 
% = read_force_aligned_config(sv_system_name, test_type )
%
%
% CVS_Version_String = '$Id: read_force_aligned_config.m,v 1.11 2004/02/13 13:21:12 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	SR_lib;
	

	mlf_struct = [];
	file_counter = 0;


	info_file = [ test_type '.info' ];

	path_info_file = fullfile(basepath, sv_system_name, 'info');
	info_filename = fullfile(path_info_file, info_file);
	
	line_cell=textread(info_filename,'%s','delimiter','\n','whitespace','');

	if (~(isempty(findstr(line_cell{2},',')))),
			imp_test_flag = 0;
	else
			imp_test_flag = 1;
	end	

	model_set = line_cell{1};

	if (imp_test_flag)
		imp_set = line_cell{2};
		imp_tested_models = get_set(sets, imp_set);
		sessions_entry_raw = {line_cell{3:end}};
	else
		imp_tested_models = {};
		sessions_entry_raw = {line_cell{2:end}};
	end
	
		
	
	models = get_set(sets, model_set);
	
	sessions_training_array = {};
	sessions_evaluate_array = {};
	hmm_versions_array = {};
	hmm_baseDirs_array = {};
	hmm_training_array = {};
	
	for session_entry_counter = 1:length(sessions_entry_raw),
		current_session_entry = sessions_entry_raw{session_entry_counter};
		if (min(findstr(current_session_entry,'S_list')) ~= 1)
			error(['name of session list not correct: ' current_session_entry]);
		end
		comma_indizes = findstr(current_session_entry,',');

		test_session_list = current_session_entry(1:comma_indizes(1)-1);
		hmm_versions_array = {hmm_versions_array{:}  current_session_entry(comma_indizes(1)+1:comma_indizes(2)-1)};
		if (imp_test_flag)
			hmm_baseDirs_array = {hmm_baseDirs_array{:}  current_session_entry(comma_indizes(2)+1:end)};
		else
			hmm_baseDirs_array = {hmm_baseDirs_array{:}  current_session_entry(comma_indizes(2)+1:comma_indizes(3)-1)};
			hmm_training_array = {hmm_training_array{:} current_session_entry(comma_indizes(3)+1:end)}; 
			training_session_list = current_session_entry(comma_indizes(3)+1:end);
		end
		

		test_temp = get_recs_by_S_list(test_session_list, sv_system_name, 'model');

		if (~imp_test_flag),
			if (~isempty(findstr(test_type,'client_x_world'))),
				tr_temp = get_recs_by_S_list(training_session_list, sv_system_name, 'world');
				slash_indizes=findstr('/', training_session_list);
				if (~(isempty(slash_indizes))),
					world_model_set = training_session_list(1:(slash_indizes(1)-1));
					imp_tested_models = get_set(sets, world_model_set);
				end

			else
				tr_temp = get_recs_by_S_list(training_session_list, sv_system_name, 'model');
			end
		end




		
		
		if (~imp_test_flag),
			sessions_training_array = {sessions_training_array{:} tr_temp{:}};
		end
		sessions_evaluate_array = {sessions_evaluate_array{:} test_temp{:}};
		
	end

	sessions_details.sessions_training_array=sessions_training_array;
	sessions_details.sessions_evaluate_array=sessions_evaluate_array;
	sessions_details.type = 'rec_list';
	sessions_details.hmm_baseDirs_array=hmm_baseDirs_array;
	sessions_details.hmm_trainingLists_array=hmm_training_array;
	model_version = hmm_versions_array;
	
	
	if (nargout == 3)
		varargout{1} = sessions_details;
		varargout{2} = model_version;
	elseif (nargout == 4)
		varargout{1} = {imp_tested_models{:}};
		varargout{2} = sessions_details;
		varargout{3} = model_version;
	else
		error('error in read_force_aligned_config: wrong number of out arguments.');
	end
