function pool_config_struct = read_paramPool_config(filename)
% function pool_config_struct = read_paramPool_config(filename)
%
% CVS_Version_String = '$Id: read_paramPool_config.m,v 1.12 2004/03/29 15:39:13 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################




	line_cell=textread(filename,'%s','delimiter','\n','whitespace','');

	% defaults from HTK
	sourceKind = 'ANON';
	sourceFormat = 'HTK';
	
	targetKind = 'ANON';
	targetFormat = 'HTK';
	
	useSilDet = 0;
	measureSil = 1;
	speechThresh = 9.0;
	silEnergy = 0.0;
	spcSeqCount = 10;
	spcGlchCount = 0;
	silSeqCount = 100;
	silGlchCount = 2;
	silMargin = 40;
	
	targetRate = 0.0;
	sourceRate = 0.0;
	
	windowSize = 256000;
	
	useHamming = 1;
	preEmCoef = 0.97;
	
	numChans = 20;
	numCeps = 12;
	cepLifter = 22;

	zMeanSource = 0;
	eNormalise = 1;
	usePower = 0;
	loFreq = -1;
	hiFreq = -1;
	
parameterCell = {'SOURCEKIND','SOURCEFORMAT','TARGETKIND', 'TARGETFORMAT', 'SOURCERATE', 'TARGETRATE', 'WINDOWSIZE', 'USEHAMMING', 'PREEMCOEF', 'NUMCEPS', 'CEPLIFTER', 'NUMCHANS', 'ZMEANSOURCE', 'ENORMALISE',  'USEPOWER', 'LOFREQ', 'HIFREQ', 'USESILDET', 'MEASURESIL','SPEECHTHRESH','SILENERGY','SPCSEQCOUNT','SPCGLCHCOUNT','SILSEQCOUNT','SILGLCHCOUNT','SILMARGIN'};
	
	
	for i=1:length(parameterCell),
		value = find_parameter(parameterCell{i},line_cell);
		
		if ~(isempty(value)),
			switch parameterCell{i}
			
				case 'SOURCEKIND'
					sourceKind = value;
					
				case 'SOURCEFORMAT'
					sourceFormat = value;
					
				case 'TARGETKIND'
					targetKind = value;
					
				case 'TARGETFORMAT'
					targetFormat = value;
				
				case 'SOURCERATE'
					sourceRate = str2num(value);

				case 'TARGETRATE'
					targetRate = str2num(value);

				case 'WINDOWSIZE'
					windowSize = str2num(value);
					
				case 'USEHAMMING'
					if (is_false(value))
						useHamming = 0;
					end

				case 'USEPOWER'
					if (is_true(value))
						usePower = 1;
					end

				case 'LOFREQ'
					loFreq = str2num(value);
				
				case 'HIFREQ'
					hiFreq = str2num(value);

				case 'PREEMCOEF'
					preEmCoef = str2num(value);
					
					
				case 'NUMCHANS'
					numChans = str2num(value);

				case 'NUMCEPS'
					numCeps = str2num(value);
					
				case 'CEPLIFTER'
					cepLifter = str2num(value);
					
				case 'ZMEANSOURCE'
					if (is_true(value))
						zMeanSource = 1;
					end
					
				case 'ENORMALISE'
					if (is_false(value))
						eNormalise = 0;
					end
					
				case 'USESILDET'
					if (is_true(value))
						useSilDet = 1;
					end
					
				case 'MEASURESIL'
					if (is_false(value))
						measureSil  = 0;
					end
				
				case 'SPEECHTHRESH'
					speechThresh = str2num(value);
					
				case 'SILENERGY'
					silEnergy = str2num(value);
				
				case 'SPCSEQCOUNT'
					spcSeqCount = str2num(value);
				
				case 'SPCGLCHCOUNT'
					spcGlchCount = str2num(value);
				
				case 'SILSEQCOUNT'
					silSeqCount = str2num(value);
				
				case 'SILGLCHCOUNT'
					silGlchCount = str2num(value);
				
				case 'SILMARGIN'
					silMargin = str2num(value);
			end
		end
		
	end
	
	pool_config_struct = struct('sourceKind', sourceKind, 'sourceFormat', sourceFormat, 'targetKind', targetKind, 'targetFormat', targetFormat, 'sourceRate', sourceRate, 'targetRate', targetRate, 'windowSize', windowSize, 'useHamming', useHamming, 'preEmCoef', preEmCoef, 'numChans', numChans, 'numCeps', numCeps, 'cepLifter', cepLifter, 'zMeanSource', zMeanSource, 'eNormalise', eNormalise, 'usePower', usePower, 'loFreq', loFreq, 'hiFreq', hiFreq, 'useSilDet',useSilDet, 'measureSil', measureSil, 'speechThresh', speechThresh, 'silEnergy', silEnergy,'spcSeqCount',spcSeqCount,'spcGlchCount',spcGlchCount,'silSeqCount',silSeqCount, 'silGlchCount',silGlchCount, 'silMargin',silMargin);

	return;


function result_bool = is_true(value)
	result_bool = 0;
	if (strcmp(lower(value),'t') | strcmp(lower(value),'true'))
		result_bool = 1;
	end
return;

function result_bool = is_false(value)
	result_bool = 0;
	if (strcmp(lower(value),'f') | strcmp(lower(value),'false'))
		result_bool = 1;
	end
return;
	
	
function value = find_parameter(parameter,cell_array)

	index_array = strmatch(parameter,cell_array);
	
	
	value = [];
	if ~(isempty(index_array)),

		selected_index = index_array(end);
	
		myLine = cell_array{selected_index};
		
		delIndex = findstr('=', myLine);
		
		if ~(isempty(delIndex)),
			valueString = myLine(delIndex+1:end);
			valueString = deblank(valueString);
			valueString = valueString(end:-1:1); % reverse string
			valueString = deblank(valueString);
			valueString = valueString(end:-1:1); % reverse string
			
			value = valueString;
		end
		
	end
	
