function save_result(result_struct, varargin)
% function save_result(result_struct, [path])
%   saves the fields of a result struct.
%   - FR_struct
%   - FA_struct
%   - model_info (if available)
%   - worlddata (if available)
%
% CVS_Version_String = '$Id: save_result.m,v 1.5 2004/02/10 10:51:29 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	SR_lib;
	
	exp_name = result_struct.exp_name;
	result_name = result_struct.result_name;
	
	if (nargin == 2),
		result_path = varargin{1};
	else	
		result_path = fullfile(basepath, 'results');
	end	
	result_filename = strcat(exp_name,'-',result_name,'.mat');
	result_fullfile = fullfile(result_path,result_filename);

	save (result_fullfile, 'result_struct');
	
