function show_llh_per_frame(exp_name, model_info, speaker, session, recording, model, model_archive)
% show_llh_per_frame(exp_name, model_info, speaker, session, recording, model, model_archive)
%
% CVS_Version_String = '$Id: show_llh_per_frame.m,v 1.14 2004/05/03 11:02:59 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

if (isempty(model_archive)),
	disp('There is no model archive!!');
	return;
end

SR_lib;
gray_color = [0.6 0.6 0.6];

show_VQ_segmentation = 1;

SD_config = model_info.paramPool_config;



tmp_index = findstr(audio_file_ext, recording);
recording_param = [ recording(1:(tmp_index(1)-1)) 'param'];
recording_base = recording(1:(tmp_index(1)-2));

wave = get_processed_audio(rawdatapath, speaker, session, recording, SD_config);
wave_length = length(wave);

if (strcmp( model_info.norm_type, 'simple world')),
	[world_llh_stretched, world_llh_stretched_n] = get_llh_values( exp_name, model_info, speaker, session, recording_param, 'world', model_archive, SD_config, wave_length );
	world_llh_mean = mean(world_llh_stretched);
end

[speaker_llh_stretched, speaker_llh_stretched_n] = get_llh_values( exp_name, model_info, speaker, session, recording_param, model, model_archive, SD_config, wave_length );
speaker_llh_mean = mean(speaker_llh_stretched);

if (show_VQ_segmentation)
	% use VQ-based segmentation
	
	use_SN_info = 1;
	vq_nbest = 2;
	selected_streams = [1];
	vq_table_file = 'vqTable_all_64';
	
	checksum = sum(model_archive); % id as checksum	
	sv_system_path = fullfile('/tmp/MASV_temp_sv_systems', [exp_name '_' num2str(checksum)]);
	
	
	pool_dir = fullfile(sv_system_path, 'links', 'currentParamPool');
	ds=dir(fullfile(pool_dir, 'configs', 'C_*'));
	if (length(ds) ~= 1),
		error( [mfilename ': Ambigous situation: more than one config file for ' pool_dir '!'] );
	end
	configFullPath = fullfile(pool_dir, 'configs', ds(1).name);
	pool_config = read_paramPool_config( configFullPath );
	frame_period = pool_config.targetRate / pool_config.sourceRate; % in samples
	paramfilename = fullfile(pool_dir, speaker, session, recording_param);
	[d,fp,dt,tc,t,magic]=readhtk(paramfilename);
	orig_n_frames = size(d,1);
	vqt=read_htk_vqtable(fullfile(pool_dir, 'VQ',vq_table_file));
	opt_vqt = optimize_vqtable(vqt);
	if (opt_vqt.magic ~= magic)
		error('wrong vq table: mismatch in magic number');
	end
	vq_data = getVQ( opt_vqt, d, vq_nbest);
	
	if (use_SN_info),	
		SN_info = read_SN_info( fullfile(pool_dir, 'SN_info', speaker, session, [recording_base '.SN_info']) );
		[segment_lengths, symbols] = get_vq_based_seg( vq_data, selected_streams, SN_info);
	else
		SN_info = [];
		[segment_lengths, symbols] = get_vq_based_seg( vq_data, selected_streams );	
	end

	segment_starts = [1; (cumsum(segment_lengths(1:(end-1))) + 1) ];
	segment_ends = [ cumsum(segment_lengths(1:(end)) )];
	colors = {[0.1 0.2 0.2] , [0.2 0.1 0.2]};	
end

if (strcmp( model_info.norm_type, 'simple world')),
	num_plots = 4;
else
	num_plots = 3;
end

figure;
subplot(num_plots,1,1);
plot(abs(wave),'b');

if (show_VQ_segmentation)
	hold on;
	plot_VQ_segments(segment_starts, segment_ends, frame_period, colors, SN_info);
end

title(['Speaker ' speaker '; Session ' session '; Recording ' recording '; tests with model ' model ]);

subplot(num_plots,1,2);
plot( speaker_llh_stretched_n,'r');
hold on;
if (strcmp( model_info.norm_type, 'simple world')),
	plot( world_llh_stretched_n,'g');
	legend({'speaker','world'});
	title( ['Individual norm:  mean llh speaker: ' num2str(speaker_llh_mean) '; mean llh world: ' num2str(world_llh_mean), '; difference = ' num2str(speaker_llh_mean - world_llh_mean) ] );
	line( [0 length(speaker_llh_stretched)], [0 0], 'Color', gray_color,'LineStyle','--');
else
	legend('speaker');
	title( ['Individual norm:  mean llh speaker: ' num2str(speaker_llh_mean)  ] );
	line( [0 length(speaker_llh_stretched)], [0 0], 'Color',gray_color,'LineStyle','--');
end
if (show_VQ_segmentation)
	plot_VQ_segments(segment_starts, segment_ends, frame_period, colors, SN_info);
end



subplot(num_plots,1,3);
plot( speaker_llh_stretched_n,'r');
hold on;

if (strcmp( model_info.norm_type, 'simple world')),
	world_llh_stretched_nn =  (world_llh_stretched - speaker_llh_mean);
	plot( world_llh_stretched_nn,'g');
	legend({'speaker','world'});
	title( ['speaker mean norm:  mean llh speaker: ' num2str(speaker_llh_mean) '; mean llh world: ' num2str(world_llh_mean), '; difference = ' num2str(speaker_llh_mean - world_llh_mean) ] );
	line( [0 length(speaker_llh_stretched)], [0 0], 'Color',gray_color,'LineStyle','--');
	line( [0 length(speaker_llh_stretched)], [(world_llh_mean - speaker_llh_mean)  (world_llh_mean - speaker_llh_mean)], 'Color','w','LineStyle','--');
else
	legend('speaker');
	title( ['speaker mean norm:  mean llh speaker: ' num2str(speaker_llh_mean)  ] );
	line( [0 length(speaker_llh_stretched)], [0 0], 'Color',gray_color,'LineStyle','--');
end
if (show_VQ_segmentation)
	plot_VQ_segments(segment_starts, segment_ends, frame_period, colors, SN_info);
end



if (strcmp( model_info.norm_type, 'simple world')),
	subplot(num_plots,1,4);
	plot( (speaker_llh_stretched - world_llh_stretched),'y');
	legend('speaker - world');
	title( ['normed llh (speaker - world);  mean llh speaker: ' num2str(speaker_llh_mean) '; mean llh world: ' num2str(world_llh_mean), '; difference = ' num2str(speaker_llh_mean - world_llh_mean) ] );
	line( [0 length(speaker_llh_stretched)], [0 0], 'Color',gray_color,'LineStyle','--');
	if (show_VQ_segmentation)
		hold on;
		plot_VQ_segments(segment_starts, segment_ends, frame_period, colors, SN_info);
	end
end



if (~strcmp(model, speaker)),
	figure;
	subplot(3,1,1);
	
	wave_client = get_processed_audio(rawdatapath, model, session, recording, SD_config)
	wave_client_length = length(wave_client);
		
	[client_llh_stretched, client_llh_stretched_n] = get_llh_values( exp_name, model_info, model, session, recording_param, model, model_archive, SD_config, wave_client_length );
	client_llh_mean = mean(client_llh_stretched);

	if (strcmp( model_info.norm_type, 'simple world')),
		[world_client_llh_stretched, world_client_llh_stretched_n] = get_llh_values( exp_name, model_info, model, session, recording_param, 'world', model_archive, SD_config, wave_client_length );
		world_client_llh_mean = mean(world_client_llh_stretched);

	end
	
	plot(abs(wave_client),'b');
	title(['Speaker ' model '; Session ' session '; Recording ' recording '; tests with model ' model ]);
	
	subplot(3,1,2);
	plot( client_llh_stretched_n,'r');
	hold on;
	
	if (strcmp( model_info.norm_type, 'simple world')),
		world_client_llh_stretched_nn = world_client_llh_stretched - client_llh_mean;
		plot( world_client_llh_stretched_nn,'g');
		legend({'client','world'});
		title( ['client mean norm:  mean llh client: ' num2str(client_llh_mean) '; mean llh world: ' num2str(world_client_llh_mean), '; difference = ' num2str(client_llh_mean - world_client_llh_mean) ] );
		line( [0 length(client_llh_stretched)], [0 0], 'Color',gray_color,'LineStyle','--');
		line( [0 length(client_llh_stretched)], [(world_client_llh_mean - client_llh_mean)  (world_client_llh_mean - client_llh_mean)], 'Color','w','LineStyle','--');
	else
		legend('speaker');
		title( ['client mean norm:  mean llh client: ' num2str(client_llh_mean)  ] );
		line( [0 length(client_llh_stretched)], [0 0], 'Color',gray_color,'LineStyle','--');
	end
	
	
	if (strcmp( model_info.norm_type, 'simple world')),
		subplot(3,1,3);
		plot( (client_llh_stretched - world_client_llh_stretched),'y');
		legend('client - world');
		title( ['normed llh (client - world);  mean llh client: ' num2str(client_llh_mean) '; mean llh world: ' num2str(world_client_llh_mean), '; difference = ' num2str(client_llh_mean - world_client_llh_mean) ] );
		line( [0 length(client_llh_stretched)], [0 0], 'Color',gray_color,'LineStyle','--');
	end
	
end

return;



	function data_based_on_samples = frame_based_to_sample_based( data_based_on_frames, SD_config );
	
		frame_period = SD_config.targetRate / SD_config.sourceRate; % in samples
	
		data_based_on_samples = [];
		for i=1:length( data_based_on_frames ),
			data_based_on_samples = [ data_based_on_samples repmat(data_based_on_frames(i), 1, frame_period) ];
		end
	return;


	
	function plot_VQ_segments(segment_starts, segment_ends, frame_period, colors, SN_info)
		a=axis;
		yl=a(3);
		yh=a(4);
		zlevel = -1;
		for i=1:length(segment_starts),
			xl=(segment_starts(i) - 1)*frame_period + 1;
			xh=segment_ends(i)*frame_period -1;
			%plot( [((segment_starts(i) - 1)*frame_period + 1), (segment_ends(i)*frame_period -1)], [0, 0], 'Color', colors{mod(i,2) + 1}, 'lineWidth', 3);
			patch( [xl xl xh xh], [yl yh yh yl], zlevel * ones(1,4), zeros(1,4), 'FaceColor', colors{mod(i,2) + 1});
		end
	
		if (~isempty(SN_info)),
			for i=1:length(SN_info), 
				plot( (repmat(SN_info(i),1,2) )*frame_period , [yl yh],'--');
			end
		end
	return;

	function wave = get_processed_audio(rawdatapath, speaker, session, recording, SD_config),
		audio_file = fullfile(rawdatapath, speaker, session, recording);
		wave = read_raw_alaw(audio_file);
		wave = wave * 4096;
		if (SD_config.useSilDet),
			[wave, border_info] = HTK_SigP_SilenceDetection( wave, SD_config);
			%border_info
		end
	return;

	
	function [llh_stretched, llh_stretched_n] = get_llh_values( exp_name, model_info, speaker, session, recording_param, test_model, model_archive, SD_config, wave_length ),
		create_stateSeq( exp_name, model_info, speaker, session, recording_param, test_model, model_archive );
		state_seq_struct=read_stateSeq( '/tmp/state_seq_tmp.txt' );
		llh_vector = [ state_seq_struct.llh ];
		llh_stretched = frame_based_to_sample_based( llh_vector, SD_config );
		llh_stretched = [ llh_stretched ones(1, (wave_length - length(llh_stretched)))*mean(llh_vector) ];
		llh_stretched_n =  (llh_stretched - mean(llh_vector) );
	return;
	
