function Plot_EER(generaltype,datatype,plottype)
% function Plot_EER(generaltype,datatype,plottype)
%
% generaltypes: 'compare'
%               'single'
%
% datatype:  'Result'
%            'Score_Result'
%
% plottypes: 'EER vs model'
%
% CVS_Version_String = '$Id: Plot_EER.m,v 1.5 2003/11/08 15:14:24 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



switch nargin
	case 0
		generaltype = 'single';
		plottype = 'EER vs model';
		datatype = 'Result';
	case 1
		plottype = 'EER vs model';
		datatype = 'Result';		
	case 2
		plottype = 'EER vs model';
	case 3
		
	otherwise
		error('Wrong number of parameters');
end

if (~exist('Results')),
	global Results;
end


if (~exist('Score_Results')),
	global Score_Results;
end


switch generaltype
 case 'compare'
 	switch datatype
		case 'Result'
			result_index1 = get_Result;
			result_index2 = get_Result;
  		case 'Score_Result'
			result_index1 = get_Score_Result;
			result_index2 = get_Score_Result;  		
  		end


 case 'single'
 	switch datatype
		case 'Result'
			result_index = get_Result;
  		case 'Score_Result'
			result_index = get_Score_Result;  		
  		end

end




figure;
hold on;

colormap(hsv);
m=colormap;
for i=1:32,
	mycolors(i,:)=m(2*i,:);
end

switch generaltype
 case 'compare'
	bar_diff = [];
	bar_index = [];
 	switch datatype
 	
 
		case 'Result'

			for i=1:length(Results{result_index1}.FR_struct)
			for j=1:length(Results{result_index2}.FR_struct)
				if (strcmp(Results{result_index2}.FR_struct{j}.model_name,Results{result_index1}.FR_struct{i}.model_name))
					[eer1, eer1_coarse,threshold1, threshold1_coarse] = calc_EER(Results{result_index1}.FR_struct{i}.data.borders, Results{result_index1}.FA_struct{i}.data.borders);
					[eer2, eer2_coarse,threshold2, threshold2_coarse] = calc_EER(Results{result_index2}.FR_struct{i}.data.borders, Results{result_index2}.FA_struct{i}.data.borders);
					temp_handle1=plot(i,eer1,'+','Color',mycolors(i,:));
					temp_handle2=plot(i,eer2,'+','Color',mycolors(i,:)+0.3*(1-mycolors(i,:)));
			
					bar_diff = [bar_diff eer2-eer1];
					bar_index = [bar_index i];			
				end
			end
			end



  		case 'Score_Result'


			for i=1:length(Score_Results{result_index1}.data)
			for j=1:length(Score_Results{result_index2}.data)
				if (strcmp(Score_Results{result_index2}.data(j).model_name,Score_Results{result_index1}.data(i).model_name))
					eer1 = Score_Results{result_index1}.data(i).eer;
					eer2 = Score_Results{result_index2}.data(j).eer;
					temp_handle1=plot(i,eer1,'+','Color',mycolors(i,:));
					temp_handle2=plot(i,eer2,'+','Color',mycolors(i,:)+0.3*(1-mycolors(i,:)));
			
					bar_diff = [bar_diff eer2-eer1];
					bar_index = [bar_index i];			
				end
			end
			end


  	end
	
	
	bar(bar_index, bar_diff, 0.4);

 case 'single'

 	switch datatype
 	
 
		case 'Result'
 
 	  		for i=1:length(Results{result_index}.FR_struct)
					[eer, eer_coarse,threshold, threshold_coarse] = calc_EER(Results{result_index}.FR_struct{i}.data.borders, Results{result_index}.FA_struct{i}.data.borders);
					temp_handle1=plot(i,eer,'+','Color',mycolors(i,:));
			end

  		case 'Score_Result'

 	  		for i=1:length(Score_Results{result_index}.data)
					eer = Score_Results{result_index}.data(i).eer;
					temp_handle1=plot(i,eer,'+','Color',mycolors(i,:));
			end
  		
  		
  		
  	end

end


axis auto;
temp_axis = axis;
temp_axis(2) = 31;
temp_axis(3) = -1;
axis(temp_axis);	



function result_index = get_Result

		SR_lib;
		
		if (~exist('Results')),
			global Results;
		end
		
		
		temp_path = pwd;
		
		cd(strcat(basepath,'results'));
		
		[filename, dummy] = uigetfile('*.mat','Select result file:');
		
		
		full_result_name = filename(1:findstr('.mat',filename)-1);
		% result in Results suchen
		found_flag = 0;
		found_index = 0;
		for i=1:length(Results),
			if (strcmp(Results{i}.full_name, full_result_name)),
				found_index = i;
				found_flag=1;
				break;
			end
		end
		
		if (found_flag),
			result_index = found_index;
		else
			[result_struct, found_result] = load_result(full_result_name);
			if (found_result),
				Results{end+1} = result_struct;
				clear result_struct;
				result_index = length(Results);
			else
				error('Couldn''t find result struct, needs calculation perhaps?')		
			end
		end
				

		cd(temp_path);


function score_result_index = get_Score_Result

		SR_lib;
		
		if (~exist('Score_Results')),
			global Score_Results;
		end
		
		
		temp_path = pwd;
		
		cd(strcat(basepath,'results'));
		
		[filename, dummy] = uigetfile('*_eer.mat','Select eer result file:');
		
		
		full_result_name = filename(1:findstr('_eer.mat',filename)-1);
		% result in Score_Results suchen
		found_flag = 0;
		found_index = 0;
		for i=1:length(Score_Results),
			if (strcmp(Score_Results{i}.full_name, full_result_name)),
				found_index = i;
				found_flag=1;
				break;
			end
		end
		
		if (found_flag),
			score_result_index = found_index;
		else
			[score_result_struct, found_result] = load_score_result(full_result_name);
			if (found_result),
				Score_Results{end+1} = score_result_struct;
				clear score_result_struct;
				score_result_index = length(Score_Results);
			else
				error('Couldn''t find Score_result struct, needs calculation perhaps?')		
			end
		end
				

		cd(temp_path);
