function varargout = Plot_SR_parameters_Callback(action)
% function varargout = Plot_SR_parameters_Callback(action)
%
% CVS_Version_String = '$Id: Plot_SR_parameters_Callback.m,v 1.65 2004/06/02 08:49:41 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



global Results;
global Score_Results;
global Score_Structs;
global rawdatapath;
global results_archive;
global basepath;
global lastUsedPath;
global sessions_lists;
global audio_file_ext;
global label_file_ext;
global current_figure_handle;

star_color = [0.99 0.99 0.99];

busy_color_free = [ 0 1 0 ];
busy_color_working = [ 1 0 0 ];

if (isempty(get(0,'CurrentFigure'))),
	current_figure_handle = [];
else
	if (isempty(gcbf)),
		current_figure_handle = gcf;
	else
		current_figure_handle = gcbf;
	end
end

switch action

	case 'hold on'
		found_handle = findobj(current_figure_handle,'Type','axes','Position',[0.10 0.21 0.58 0.71]);
		set(current_figure_handle,'currentaxes',found_handle);
		set(found_handle,'nextPlot','add');
	
	case 'hold off'
		found_handle = findobj(current_figure_handle,'Type','axes','Position',[0.10 0.21 0.58 0.71]);
		set(current_figure_handle,'currentaxes',found_handle);
		set(found_handle,'nextPlot','replace');
	
	
	case 'show_more1'
		found_handle = findobj(current_figure_handle,'Tag','more1');
		if (isempty(found_handle)),
			return;
		end
		
		searched_objects = findobj(gca,'Tag','more_info1');
		more_state = get(found_handle,'Value');
		if (more_state),
			set(found_handle,'BackgroundColor',[0.1 0.7 0.1]);
		else
			set(found_handle,'BackgroundColor',[0.7 0.7 0.7]);
		end
		if ~(isempty(searched_objects)),
			if (more_state),
				set(searched_objects, 'Visible', 'on');
			else
				set(searched_objects, 'Visible', 'off');
			end
		end
		return;
	
	case 'show_more2'
		found_handle = findobj(current_figure_handle,'Tag','more2');
		if (isempty(found_handle)),
			return;
		end
		
		searched_objects = findobj(gca,'Tag','more_info2');
		more_state = get(found_handle,'Value');
		if (more_state),
			set(found_handle,'BackgroundColor',[0.1 0.7 0.1]);
		else
			set(found_handle,'BackgroundColor',[0.7 0.7 0.7]);
		end
		if ~(isempty(searched_objects)),
			if (more_state),
				set(searched_objects, 'Visible', 'on');
			else
				set(searched_objects, 'Visible', 'off');
			end
		end
		return;
	
	
	case 'load'
		
		temp_path = pwd;
		
		cd(results_archive);
		
		if (isempty(lastUsedPath))
			lastUsedPath = '';
		end
		[filename, used_path] = uigetfile([lastUsedPath '*.mat'],'Select result/score_result file:');
		
		if (used_path ~= 0)
			lastUsedPath = used_path;
		end
		
		cd(temp_path);
		
		if (filename == 0),
			if (nargout == 4),
				varargout{1} = 0;
				varargout{2} = 0;
				varargout{3} = 0;
				varargout{4} = '';
			end
			return;
		end
		
		% result in Results suchen
		found_flag = 0;
		found_index = 0;
		
		if (findstr('_score.mat', filename)),
			full_result_name = filename(1:findstr('_score.mat',filename)-1);
			for i=1:length(Score_Results),
				if (strcmp(Score_Results{i}.full_name, full_result_name)),
					found_index = i;
					found_flag=1;
					break;
				end
			end
		
			if (found_flag),
				score_result_index = found_index;
			else
				[score_result_struct, found_result] = load_score_result(full_result_name, used_path);
				if (found_result),
					Score_Results{end+1} = score_result_struct;
					clear score_result_struct;
					score_result_index = length(Score_Results);
				else
					error('Couldn''t find score result struct.')		
				end
			end
			
			result_type = 'score_result';
			result_index = 0;
			score_struct_index = 0;
			
		elseif (findstr('_single_score_struct.mat', filename)),
			full_result_name = filename(1:findstr('_single_score_struct.mat',filename)-1);
			for i=1:length(Score_Structs),
				if (strcmp(Score_Structs{i}.full_name, full_result_name)),
					found_index = i;
					found_flag=1;
					break;
				end
			end
		
			if (found_flag),
				score_struct_index = found_index;
			else
				[score_struct, found_result] = load_score_struct(full_result_name, used_path);
				if (found_result),
					Score_Structs{end+1} = score_struct;
					clear score_struct;
					score_struct_index = length(Score_Structs);
				else
					error('Couldn''t find score struct.')		
				end
			end
			
			result_type = 'score_struct';
			result_index = 0;
			score_result_index = 0;
			
		else
			% normal result file
			full_result_name = filename(1:findstr('.mat',filename)-1);
			for i=1:length(Results),
				if (strcmp(Results{i}.full_name, full_result_name)),
					found_index = i;
					found_flag=1;
					break;
				end
			end
			
			if (found_flag),
				result_index = found_index;
			else
				[result_struct, found_result] = load_result(full_result_name, used_path);
				if (found_result),
					Results{end+1} = result_struct;
					clear result_struct;
					result_index = length(Results);
				else
					error('Couldn''t find result struct.')		
				end
			end
			
			result_type = 'result';
			score_result_index = 0;
			score_struct_index = 0;
			%%
			%% try to open corresponding score_result
			found_flag = 0;
			found_index = 0;
			for i=1:length(Score_Results),
				if (strcmp(Score_Results{i}.full_name, full_result_name)),
					found_index = i;
					found_flag=1;
					break;
				end
			end
		
			if (found_flag),
				score_result_index = found_index;
				result_type = 'combined';
			else
				[score_result_struct, found_result] = load_score_result(full_result_name, used_path);
				if (found_result),
					Score_Results{end+1} = score_result_struct;
					clear score_result_struct;
					score_result_index = length(Score_Results);
					result_type = 'combined';
				else
					disp('Couldn''t find score result struct.')		
				end
			end
		
		
		end
		if (nargout == 4),
			varargout{1} = result_index;
			varargout{2} = score_result_index;
			varargout{3} = score_struct_index;
			varargout{4} = result_type;
		end
		if (~isempty(get(0,'CurrentFigure')) & ~(isempty(findobj(current_figure_handle,'Tag','Load_Button')))),
			set(findobj(current_figure_handle,'Tag','Load_Button'),'UserData',full_result_name);
		end
		return;
	

	case 'clear_figure'
		found_handle = findobj(current_figure_handle,'Type','axes','Tag','legend');
		if ~(isempty(found_handle)),
			delete(found_handle);
		end
		found_handle = findobj(current_figure_handle,'Type','axes','Position',[0.10 0.21 0.58 0.71]);
		set(current_figure_handle,'currentaxes',found_handle);
		cla;
		reset(gca);
		set(gca,'Tag','Axes1');
		
		info1_handle = findobj(current_figure_handle,'Tag','info1');
		info2_handle = findobj(current_figure_handle,'Tag','info2');
		info3_handle = findobj(current_figure_handle,'Tag','info3');
		label1_handle = findobj(current_figure_handle,'Tag','label1');
		label2_handle = findobj(current_figure_handle,'Tag','label2');
		set(label1_handle,'String','');
		set(label2_handle,'String','');
		set(info1_handle,'String','');
		set(info2_handle,'String','');
		set(info3_handle,'String','');
		temp_handles = findobj(current_figure_handle,'Tag','force_aligned_borders');
		if ~(isempty(temp_handles)),
			delete(temp_handles);
		end

		return;

	case 'clone_figure'
		figure_handle = current_figure_handle;
		axis_handles(1) = findobj(current_figure_handle,'Type','axes','Position',[0.10 0.21 0.58 0.71]);
		found_handle = findobj(current_figure_handle,'Type','axes','Tag','legend');
		if ~(isempty(found_handle)),
			axis_handles(end + 1) = found_handle;
		end
		% create new axis for old figure !
		axes_handle = axes('Parent',figure_handle, ...
			'Box','on', ...
			'CameraUpVector',[0 1 0], ...
			'Color',[0 0 0], ...
			'FontSize',9, ...
			'Position',[0.10 0.21 0.58 0.71], ...
			'Tag','Axes1');
		
		new_fh = figure;
		for i = 1:length(axis_handles),
			set(axis_handles(i),'Parent',new_fh);
		end
		set( axis_handles(1), 'Position', [0.13 0.11 0.775 0.815]);
		return;
		
	case 'update'
		results_handle = findobj(current_figure_handle,'Tag','results');
		results_loaded = {};
		for i=1:length(Results),
			results_loaded = {results_loaded{:} Results{i}.full_name};
		end
		for i=1:length(Score_Results),
			results_loaded = {results_loaded{:} Score_Results{i}.full_name};
		end
		for i=1:length(Score_Structs),
			results_loaded = {results_loaded{:} Score_Structs{i}.full_name};
		end
		%all_results_loaded = sort(results_loaded);
		all_results_loaded = unique(results_loaded);

		newly_loaded_name = get(findobj(current_figure_handle,'Tag','Load_Button'),'UserData');
		if (~isempty(newly_loaded_name)),
			selected_result_name = newly_loaded_name;
			set(findobj(current_figure_handle,'Tag','Load_Button'),'UserData','');
		else
			selected_result = get(results_handle,'Value');
			selected_result_names = get(results_handle,'String');
			if (isempty(selected_result) | isempty(selected_result_names)),
				set(results_handle, 'String',all_results_loaded);
				set(results_handle,'Value',1);
				selected_result_name = all_results_loaded{1};
			else
				selected_result_name = selected_result_names{selected_result};
			end
		end
		
		
		result_index = search_Results_for_item(Results, selected_result_name);		
		score_result_index = search_Results_for_item(Score_Results, selected_result_name);
		score_struct_index = search_Results_for_item(Score_Structs, selected_result_name);		
		
				
		result_index_info(1) = result_index;
		result_index_info(2) = score_result_index;
		result_index_info(3) = score_struct_index;

		set(current_figure_handle,'UserData',result_index_info);

		if (result_index ~= 0)
			exp_name = Results{result_index}.exp_name;
			result_name = Results{result_index}.result_name;
			result_type = 'result';
		end
		
		if (score_result_index ~= 0),
			exp_name = Score_Results{score_result_index}.exp_name;
			result_name = Score_Results{score_result_index}.result_name;
			result_type = 'score_result';
		end

		if ((score_result_index ~= 0) & (result_index ~= 0)),
			result_type = 'combined';
		end
		
		if (score_struct_index ~= 0),
			exp_name = Score_Structs{score_struct_index}.exp_name;
			result_name = Score_Structs{score_struct_index}.result_name;
			result_type = 'score_struct';
		end
		
		set(results_handle, 'String',all_results_loaded);
		selected_result = find(strcmp(selected_result_name, all_results_loaded));
		set(results_handle,'Value',selected_result);


		set(current_figure_handle,'Name',['Sv_system: ' exp_name ', Results: ' result_name ]);
		set(current_figure_handle,'NumberTitle','off');

		if (nargout == 4),
			varargout{1} = result_index;
			varargout{2} = score_result_index;
			varargout{3} = score_struct_index;
			varargout{4} = result_type;
		end
		
		
		
		return;

end


temp = get(current_figure_handle,'UserData');
result_index = temp(1);
score_result_index = temp(2);
score_struct_index = temp(3);

if (result_index ~= 0)
	FR_struct = Results{result_index}.FR_struct;
	FA_struct = Results{result_index}.FA_struct;
	exp_name = Results{result_index}.exp_name;
	result_name = Results{result_index}.result_name;
	num_client_spks = length(FR_struct);
	for i = 1:num_client_spks,
		client_spks{i}=FR_struct{i}.model_name;
	end
	[male_indizes, female_indizes]	= get_gender_indizes(Results{result_index}.model_info.trained_models, Results{result_index}.model_info);
	model_info = Results{result_index}.model_info;
	imp_test_spks = model_info.imp_test_spks;
	num_imp_spks = length(imp_test_spks);
end

if (score_result_index ~= 0),
	score_result_struct = Score_Results{score_result_index};
	exp_name = score_result_struct.exp_name;
	result_name = score_result_struct.result_name;
	
	if ( ~isfield(score_result_struct, 'model_info' )),
		num_client_spks = 1;
		client_spks={'det overall'};
		model_info = [];
		imp_test_spks = {};
		num_imp_spks = 0;
	else
	
		num_client_spks = score_result_struct.part{1}.num_of_models;
		for i = 1:num_client_spks,
			client_spks{i}=score_result_struct.part{1}.model(i).model_name;
		end
		[male_indizes, female_indizes]	= get_gender_indizes(Score_Results{score_result_index}.model_info.trained_models, Score_Results{score_result_index}.model_info);
		model_info = Score_Results{score_result_index}.model_info;
		imp_test_spks = model_info.imp_test_spks;
		num_imp_spks = length(imp_test_spks);
	end
end

if (score_struct_index ~= 0),
	score_struct = Score_Structs{score_struct_index};
	exp_name = score_struct.exp_name;
	result_name = score_struct.result_name;
	num_client_spks = 1;
	for i = 1:num_client_spks,
		client_spks{i}='null';
	end
	male_indizes = 0;
	female_indizes = 0;
	model_info = Score_Structs{score_struct_index}.info;
	imp_test_spks = [];
	num_imp_spks = length(imp_test_spks);
end


set(current_figure_handle,'Name',['Sv_system: ' exp_name ', Results: ' result_name ]);
set(current_figure_handle,'NumberTitle','off');


switch action

	case 'change_info_var'
		
		fr_fa_var_handle = findobj(current_figure_handle,'Tag','fr_fa_var');
		info_variante_handle = findobj(current_figure_handle,'Tag','info_variante');
		variante_name_index = get(fr_fa_var_handle, 'Value');
		
		
		set(info_variante_handle,'String',break_string(score_result_struct.part{variante_name_index}.info));
		
		return;
		
	case 'update fr_fa_session list'

		
		fr_sessions = {'all', 'without training','training'};
		for i = 1:4,
			fr_sessions  = [fr_sessions {sessions_lists{i}.set_name}];
		end
		if (isfield(model_info,'session_lists_to_view')),
			for i = 1:length(model_info.session_lists_to_view),
				fr_sessions = [fr_sessions {model_info.session_lists_to_view(i).set_name}];
			end
		end
		fa_sessions = {'all'};
		for i = 1:4,
			fa_sessions  = [fa_sessions {sessions_lists{i}.set_name}];
		end
		if (isfield(model_info,'session_lists_to_view')),
			for i = 1:length(model_info.session_lists_to_view),
				fa_sessions = [fa_sessions {model_info.session_lists_to_view(i).set_name}];
			end
		end
		
		temp_handle = findobj(current_figure_handle,'Tag','fr_ses');
		current_index_fr = get(temp_handle,'Value');
		if (current_index_fr > 7),
			set(temp_handle,'Value',1);
		end
		set(temp_handle, 'String',fr_sessions);
		
		temp_handle = findobj(current_figure_handle,'Tag','fa_ses');
		current_index_fa = get(temp_handle,'Value');
		if (current_index_fa > 5),
			set(temp_handle,'Value',1);
		end
		set(temp_handle, 'String',fa_sessions);
		
		temp_handle = findobj(current_figure_handle,'Tag','fr_ses');
		ext_model_info = create_ext_model_info(model_info);
		set(temp_handle,'UserData', ext_model_info);
		
		return;

end



mycolors =get(findobj(current_figure_handle,'Tag','models'),'UserData');

draw_functions = get(findobj(current_figure_handle,'Tag','functions'), 'String');

	switch action
	
	case 'change_fr_fa_var'
		function_name_index = get(findobj(current_figure_handle,'Tag','functions'), 'Value');
		
		fr_fa_var_handle = findobj(current_figure_handle,'Tag','fr_fa_var');
			
		if sum(strcmp(draw_functions{function_name_index},{'(SR) FR vs FA'; '(SR) FR vs FA (double log)'; '(SR) FR vs FA (npp)'; '(SR) FR vs FA (npp), FA b.';'(SR) FR vs FA (npp), FR b.'; '(SR) EER vs model';'FA vs model';'FA vs imp. spk';'FR vs model'; 'FA client/imp matrix';'Rel. unreliability';'Rel. vulnerability';'Rel. imitation ability'})),
			for i = 1:length(score_result_struct.part),
				fr_fa_variantes{i} = ['(' num2str(i) ') [' score_result_struct.part{i}.result_type '] '  score_result_struct.part{i}.menu_descr];
			end
			set(fr_fa_var_handle,'String',fr_fa_variantes);
			set(fr_fa_var_handle,'Enable','on');
		else
			set(fr_fa_var_handle,'Enable','off');
			info_variante_handle = findobj(current_figure_handle,'Tag','info_variante');
			set(info_variante_handle,'String','');
		end
	
		
		fr_ses_handle = findobj(current_figure_handle,'Tag','fr_ses');
		fa_ses_handle = findobj(current_figure_handle,'Tag','fa_ses');
		models_handle = findobj(current_figure_handle,'Tag','models');
		imp_spks_handle = findobj(current_figure_handle,'Tag','imp_spks');
		
		if sum(strcmp(draw_functions{function_name_index},{'(SR) FR vs FA'; '(SR) FR vs FA (double log)'; '(SR) FR vs FA (npp)'; '(SR) FR vs FA (npp), FA b.';'(SR) FR vs FA (npp), FR b.'})),
			set(models_handle,'Enable','off');
		else
			set(models_handle,'Enable','on');
		end
		if sum(strcmp(draw_functions{function_name_index},{'FR vs threshold';'World scores';'FR vs FA'; 'FR vs FA (double log)'; 'FR vs FA (npp)';'EER vs model'})),
			set(fr_ses_handle,'Enable','on');
		else
			set(fr_ses_handle,'Enable','off');
		end
		if sum(strcmp(draw_functions{function_name_index},{'FA vs threshold';'World scores';'FR vs FA'; 'FR vs FA (double log)'; 'FR vs FA (npp)';'EER vs model'})),
			set(fa_ses_handle,'Enable','on');
			set(imp_spks_handle,'Enable','on');
		else
			set(fa_ses_handle,'Enable','off');
			set(imp_spks_handle,'Enable','off');
		end

		overall_av_handle = findobj(current_figure_handle,'Tag','overall_av');
		if sum(strcmp(draw_functions{function_name_index},{'FR vs FA'; 'FR vs FA (double log)'; 'FR vs FA (npp)'})),
			set(overall_av_handle,'Visible','on');
		else
			set(overall_av_handle,'Visible','off');
		end
		model_av_handle = findobj(current_figure_handle,'Tag','model_av');
		if sum(strcmp(draw_functions{function_name_index},{'FR vs threshold';'FA vs threshold'})),
			set(model_av_handle,'Visible','on');
		else
			set(model_av_handle,'Visible','off');
		end
		
		% switched always off, maybe useful later
		imp_av_handle = findobj(current_figure_handle,'Tag','imp_av');
		if sum(strcmp(draw_functions{function_name_index},{'FA vs threshold'})),
			set(imp_av_handle,'Visible','off');
		else
			set(imp_av_handle,'Visible','off');
		end
		
		
	case 'draw'
		set(findobj(current_figure_handle,'Tag','draw_busy'), 'BackgroundColor', busy_color_working);
		drawnow;

		
		draw_client_index = get(findobj(current_figure_handle,'Tag','models'), 'Value');
		draw_client_list = get(findobj(current_figure_handle,'Tag','models'), 'String');
		draw_client_selected_list = draw_client_list(draw_client_index);
		
		variante_name_index = get(findobj(current_figure_handle,'Tag','fr_fa_var'), 'Value');

		fr_display_session_index = get(findobj(current_figure_handle,'Tag','fr_ses'), 'Value');
		fr_display_session_list = get(findobj(current_figure_handle,'Tag','fr_ses'), 'String');
		fr_display_sessions = fr_display_session_list(fr_display_session_index);
		fa_display_session_index = get(findobj(current_figure_handle,'Tag','fa_ses'), 'Value');
		fa_display_session_list = get(findobj(current_figure_handle,'Tag','fa_ses'), 'String');
		fa_display_sessions = fa_display_session_list(fa_display_session_index);

		ext_model_info = get(findobj(current_figure_handle,'Tag','fr_ses'), 'UserData');
		%%%%ext_model_info.preDefined = get(findobj(current_figure_handle,'Tag','s_sessions'), 'UserData');

		spk_info_struct = get(findobj(current_figure_handle,'Tag','Info_Button'), 'UserData');

		if (length(draw_client_index) == 1),
			switch draw_client_index
			
				case  1,
					% alle modelle
					draw_client_array = (1:num_client_spks);
					draw_several_models = 1;
				case 2,
					% nur Maenner
					draw_client_array = male_indizes;
					draw_several_models = 1;
				case 3,
					% nur Frauen
					draw_client_array = female_indizes;
					draw_several_models = 1;
				otherwise
					draw_client_array = draw_client_index-3;
					draw_several_models = 0;
				
			end
		else
			% nur Einzel-Modell Eintrge bercksichtigen
			temp_model_indizes = find(draw_client_index > 3);
			draw_client_index = draw_client_index(temp_model_indizes);
			draw_client_array = draw_client_index - 3;
			draw_several_models = 1;
		end
		
		if (get(findobj(current_figure_handle,'Tag','hist'), 'Value')),
			draw_histogram = 1;
		else
			draw_histogram = 0;
		end
		
		N_combination = get(findobj(current_figure_handle,'Tag','combinations'), 'Value');
		
		
		if (get(findobj(current_figure_handle,'Tag','new_figure'), 'Value')),
			new_figure_h = figure;
			set(new_figure_h,'Name',['Sv_system: ' exp_name ', Results: ' result_name ]);
			temp=[result_index,	score_result_index, score_struct_index];
			set(current_figure_handle,'UserData',temp);

		end
		
		if ~(ishold)
			Plot_SR_parameters_Callback('clear_figure');
		else
			found_handle = findobj(current_figure_handle,'Type','axes','Position',[0.10 0.21 0.58 0.71]);
			set(current_figure_handle,'currentaxes',found_handle);
		end
		
		for draw_client_index_counter=1:length(draw_client_array),
			current_draw_client_index = draw_client_array(draw_client_index_counter);
			if (draw_client_index_counter == 1),
				hold_temp_flag = ishold;
				if (draw_several_models) & ~(ishold),
					cla;
					hold on;
				end
			end
				
			draw_client = client_spks{current_draw_client_index};	
			function_name_index = get(findobj(current_figure_handle,'Tag','functions'), 'Value');
			
			switch draw_functions{function_name_index}
			
			case 'FA vs threshold'

				av_model_status = get(findobj(current_figure_handle,'Tag','model_av'), 'Value');
				
				% not used (still)
				av_imp_status = get(findobj(current_figure_handle,'Tag','imp_av'), 'Value');
				%keyboard;
				imp_spk_names=local_get_imp_spks_list(result_index,draw_client, current_draw_client_index);
				
				if (av_model_status),
					if (draw_client_index_counter == 1)
						borders_collect = [];
						draw_client_index_vector_collect = [];
						if (N_combination > 1),
							combined_rec_indizes_collect = [];
						else
							draw_rec_indizes_collect = [];
						end
					end
					
					if (N_combination > 1),
						[borders, combined_rec_indizes] = get_combined_data_FA(FA_struct, current_draw_client_index, imp_spk_names, fa_display_sessions, N_combination, ext_model_info);


						combined_rec_indizes_collect = [ combined_rec_indizes_collect combined_rec_indizes ];
					else
						draw_rec_indizes = find_sessions_in_F_struct(FA_struct{current_draw_client_index}, fa_display_sessions, imp_spk_names, ext_model_info);
						borders = FA_struct{current_draw_client_index}.data.borders(draw_rec_indizes);

						draw_rec_indizes_collect = [ draw_rec_indizes_collect draw_rec_indizes ];
					end
					
					borders_collect  = [ borders_collect borders ];
					draw_client_index_vector_collect = [ draw_client_index_vector_collect repmat(current_draw_client_index,1,length(borders)) ];

					if (draw_client_index_counter == length(draw_client_array)),
						[borders_collect, sort_indizes] = sort(borders_collect);
						draw_client_index_vector_collect = draw_client_index_vector_collect(sort_indizes);

						if (N_combination > 1),
							combined_rec_indizes_collect = combined_rec_indizes_collect(:,sort_indizes);
							draw_rec_indizes_collect = 'not used';
						else
							draw_rec_indizes_collect = draw_rec_indizes_collect(sort_indizes);
							combined_rec_indizes_collect = 'not used';
						end

						draw_FA_vs_threshold(FA_struct, fa_display_sessions, mycolors, result_index, borders_collect,draw_client_index_vector_collect, spk_info_struct, N_combination, draw_rec_indizes_collect, combined_rec_indizes_collect, draw_histogram, av_model_status, av_imp_status);
					end

				else 
					%keyboard;
					if (N_combination > 1),
						
						[borders, combined_rec_indizes] = get_combined_data_FA(FA_struct, current_draw_client_index, imp_spk_names, fa_display_sessions, N_combination, ext_model_info);
						
						[borders, sort_indizes] = sort(borders);
						combined_rec_indizes = combined_rec_indizes(:,sort_indizes);
						draw_rec_indizes = 'not used';
					else
						draw_rec_indizes = find_sessions_in_F_struct(FA_struct{current_draw_client_index}, fa_display_sessions, imp_spk_names, ext_model_info);
						borders = FA_struct{current_draw_client_index}.data.borders(draw_rec_indizes);
						combined_rec_indizes = 'not used';
					end
					draw_FA_vs_threshold(FA_struct, fa_display_sessions, mycolors, result_index, borders,current_draw_client_index, spk_info_struct, N_combination, draw_rec_indizes, combined_rec_indizes,draw_histogram, av_model_status, av_imp_status)
				end



				title('FR/FA rate vs threshold');
				xlabel('threshold');
				ylabel('FR/FA rate, percent');
				
				
				
			case 'FR vs threshold'

				av_status = get(findobj(current_figure_handle,'Tag','model_av'), 'Value');

				if (av_status),
					if (draw_client_index_counter == 1)
						borders_collect = [];
						draw_client_index_vector_collect = [];
						if (N_combination > 1),
							combined_rec_indizes_collect = [];
						else
							draw_rec_indizes_collect = [];
						end
						
					end
					
					if (N_combination > 1),
						[borders, combined_rec_indizes] = get_combined_data(FR_struct, current_draw_client_index, draw_client, fr_display_sessions, N_combination, ext_model_info);
					
						combined_rec_indizes_collect = [ combined_rec_indizes_collect combined_rec_indizes ];
					else
						draw_rec_indizes = find_sessions_in_F_struct(FR_struct{current_draw_client_index}, fr_display_sessions, {'all'}, ext_model_info);
						borders = FR_struct{current_draw_client_index}.data.borders(draw_rec_indizes);

						draw_rec_indizes_collect = [ draw_rec_indizes_collect draw_rec_indizes ];
					
					end
					
					borders_collect  = [ borders_collect borders ];
					draw_client_index_vector_collect = [ draw_client_index_vector_collect repmat(current_draw_client_index,1,length(borders)) ];

					if (draw_client_index_counter == length(draw_client_array)),
						[borders_collect, sort_indizes] = sort(borders_collect);
						draw_client_index_vector_collect = draw_client_index_vector_collect(sort_indizes);
						
						if (N_combination > 1),
							combined_rec_indizes_collect = combined_rec_indizes_collect(:,sort_indizes);
							draw_rec_indizes_collect = 'not used';
						else
							draw_rec_indizes_collect = draw_rec_indizes_collect(sort_indizes);
							combined_rec_indizes_collect = 'not used';
						end
						
						draw_FR_vs_threshold(FR_struct, fr_display_sessions, mycolors, result_index, borders_collect,draw_client_index_vector_collect, spk_info_struct, N_combination, draw_rec_indizes_collect, combined_rec_indizes_collect, draw_histogram, av_status);
					
					end
				else % no average
				
					if (N_combination > 1),
						
						[borders, combined_rec_indizes] = get_combined_data(FR_struct, current_draw_client_index, draw_client, fr_display_sessions, N_combination, ext_model_info);
						
						[borders, sort_indizes] = sort(borders);
						combined_rec_indizes = combined_rec_indizes(:,sort_indizes);
						draw_rec_indizes = 'not used';
					else
						draw_rec_indizes = find_sessions_in_F_struct(FR_struct{current_draw_client_index}, fr_display_sessions, {'all'}, ext_model_info);
						borders = FR_struct{current_draw_client_index}.data.borders(draw_rec_indizes);
						combined_rec_indizes = 'not used';
					end
					draw_FR_vs_threshold(FR_struct, fr_display_sessions, mycolors, result_index, borders,current_draw_client_index, spk_info_struct, N_combination, draw_rec_indizes, combined_rec_indizes,draw_histogram, av_status)					
				end
				
				
				
				

				title('FR rate vs threshold');
				xlabel('threshold');
				ylabel('FR rate, percent');


				
			case {'FR vs FA', 'FR vs FA (double log)', 'FR vs FA (npp)'}
				if (strcmp(draw_functions{function_name_index},'FR vs FA (double log)')),
					display_mode = 1;
				elseif (strcmp(draw_functions{function_name_index},'FR vs FA (npp)')),
					display_mode = 2;
				else
					display_mode = 0;
				end
				
				av_status = get(findobj(current_figure_handle,'Tag','overall_av'), 'Value');

				[imp_spk_names, imp_index_array, several_imp_flag] = local_get_imp_spks_list(result_index,draw_client, current_draw_client_index);
				
				draw_FR_rec_indizes = find_sessions_in_F_struct(FR_struct{current_draw_client_index}, fr_display_sessions, {'all'}, ext_model_info);
				draw_FA_rec_indizes = find_sessions_in_F_struct(FA_struct{current_draw_client_index}, fa_display_sessions, imp_spk_names, ext_model_info);

				FR_borders = FR_struct{current_draw_client_index}.data.borders(draw_FR_rec_indizes);
				FA_borders = FA_struct{current_draw_client_index}.data.borders(draw_FA_rec_indizes);
				

				if (av_status),
					if (draw_client_index_counter == 1)
						FR_b_collect = [];
						FA_b_collect = [];
					end
					
					FR_b_collect  = [ FR_b_collect FR_borders ];
					FA_b_collect  = [ FA_b_collect FA_borders ];
					
					if (draw_client_index_counter == length(draw_client_array)),
						FR_b_collect=sort(FR_b_collect);
						FA_b_collect=sort(FA_b_collect);
						[FR, FA, borders_common] = calc_FR_FA_pairs(FR_b_collect, FA_b_collect);
						
						draw_FR_vs_FA(FR, FA, FR_b_collect, FA_b_collect, mycolors, current_draw_client_index, display_mode, draw_client, fr_display_sessions, fa_display_sessions, spk_info_struct, av_status);

					end
					
				else
					[FR, FA, borders_common] = calc_FR_FA_pairs(FR_borders, FA_borders);
					
					draw_FR_vs_FA(FR, FA, FR_borders, FA_borders, mycolors, current_draw_client_index, display_mode, draw_client, fr_display_sessions, fa_display_sessions, spk_info_struct, av_status);

				end 
				
				if (display_mode==1),
					title('FR vs FA in double log scale');
				elseif (display_mode==2),
					title('FR vs FA in normal probability plot');
				else
					title('FR vs FA');
				end
				xlabel('FA rate, percent');
				ylabel('FR rate, percent');


			case {'(SR) FR vs FA', '(SR) FR vs FA (double log)', '(SR) FR vs FA (npp)',  '(SR) FR vs FA (npp), FA b.', '(SR) FR vs FA (npp), FR b.'}
				switch score_result_struct.part{variante_name_index}.result_type
					case 'det'
						% do nothing, just continue...
					case 'det_bs'
						% do nothing, just continue...
					otherwise
						set(findobj(current_figure_handle,'Tag','draw_busy'), 'BackgroundColor', busy_color_free);
						return;
				end
					
				if (strcmp(draw_functions{function_name_index},'(SR) FR vs FA (double log)')),
					display_mode = 1;
				elseif ( sum(strcmp(draw_functions{function_name_index},{'(SR) FR vs FA (npp)'; '(SR) FR vs FA (npp), FA b.';'(SR) FR vs FA (npp), FR b.'}))),
					display_mode = 2;
				else
					display_mode = 0;
				end
				
				if (strcmp(draw_functions{function_name_index},'(SR) FR vs FA (npp)')),
					bound_mode = 'all';
				elseif (strcmp(draw_functions{function_name_index},'(SR) FR vs FA (npp), FA b.')),
					bound_mode = 'FA';
				elseif (strcmp(draw_functions{function_name_index},'(SR) FR vs FA (npp), FR b.')),
					bound_mode = 'FR';
				else
					bound_mode = 'all';
				end
				

				if (draw_client_index_counter == 1)

					info = score_result_struct.part{variante_name_index}.info;
					imp_spks_list = score_result_struct.part{variante_name_index}.imp_spks_list;

					switch score_result_struct.part{variante_name_index}.result_type
					case 'det'
						FR = score_result_struct.part{variante_name_index}.data.FRs;
						FA = score_result_struct.part{variante_name_index}.data.FAs;
						eer = score_result_struct.part{variante_name_index}.parameters.eer;
						threshold = score_result_struct.part{variante_name_index}.parameters.threshold;
						
						
						if (isfield(score_result_struct.part{variante_name_index}.parameters,'client_low_p_bound_exact')),
							stat_sig_struct.client_low_p_bound_exact = score_result_struct.part{variante_name_index}.parameters.client_low_p_bound_exact;
						end
						
						if (isfield(score_result_struct.part{variante_name_index}.parameters,'imp_low_p_bound_exact')),
							stat_sig_struct.imp_low_p_bound_exact =  score_result_struct.part{variante_name_index}.parameters.imp_low_p_bound_exact;
						end
						if (isfield(score_result_struct.part{variante_name_index}.parameters,'imp_low_p_bound_exact_strict')),
							stat_sig_struct.imp_low_p_bound_exact_strict = score_result_struct.part{variante_name_index}.parameters.imp_low_p_bound_exact_strict;
						end
						
						if (isfield(score_result_struct.part{variante_name_index}.data,'fr_sig_bounds_from_av_of_att')),
							stat_sig_struct.fr_sig_bounds_from_av_of_att = score_result_struct.part{variante_name_index}.data.fr_sig_bounds_from_av_of_att;
							stat_sig_struct.fa_sig_bounds_from_av_of_att = score_result_struct.part{variante_name_index}.data.fa_sig_bounds_from_av_of_att;
						end
						if (isfield(score_result_struct.part{variante_name_index}.data,'fr_av_of_att')),
							stat_sig_struct.fr_av_of_att = score_result_struct.part{variante_name_index}.data.fr_av_of_att;
							stat_sig_struct.fr_N_tests = score_result_struct.part{variante_name_index}.parameters.fr_N_tests;
							stat_sig_struct.fa_av_of_att = score_result_struct.part{variante_name_index}.data.fa_av_of_att;
							stat_sig_struct.fa_N_tests = score_result_struct.part{variante_name_index}.parameters.fa_N_tests;
						end
						
					case 'det_bs'
						FR = score_result_struct.part{variante_name_index}.data.fr_av_of_att;
						FA = score_result_struct.part{variante_name_index}.data.fa_av_of_att;
						eer = NaN;
						threshold = NaN;
						
						stat_sig_struct.fr_sig_bounds_from_av_of_att = score_result_struct.part{variante_name_index}.data.fr_sig_bounds_from_av_of_att;
						stat_sig_struct.fa_sig_bounds_from_av_of_att = score_result_struct.part{variante_name_index}.data.fa_sig_bounds_from_av_of_att;
						stat_sig_struct.fr_av_of_att = score_result_struct.part{variante_name_index}.data.fr_av_of_att;
						stat_sig_struct.fa_av_of_att = score_result_struct.part{variante_name_index}.data.fa_av_of_att;

					end
					
					draw_SR_FR_vs_FA(FR, FA, eer, threshold, mycolors, current_draw_client_index, display_mode, info, imp_spks_list, stat_sig_struct, score_result_struct.part{variante_name_index}.result_type, bound_mode);
	
					
					if (display_mode==1),
						title('FR vs FA in double log scale');
					elseif (display_mode==2),
						title('FR vs FA in normal probability plot');
					else
						title('FR vs FA');
					end
					xlabel('FA rate, percent');
					ylabel('FR rate, percent');
				end



					
			case {'EER vs model';'(SR) EER vs model'}
				if (strcmp(draw_functions{function_name_index},'(SR) EER vs model')),
					switch score_result_struct.part{variante_name_index}.result_type
						case 'eer'
							eer = score_result_struct.part{variante_name_index}.model(current_draw_client_index).data.eer;
							eer_mean = score_result_struct.part{variante_name_index}.parameters.eer_mean;
							eer_male_mean = score_result_struct.part{variante_name_index}.parameters.eer_male_mean;
							eer_female_mean = score_result_struct.part{variante_name_index}.parameters.eer_female_mean;
							eer_gender_balanced_mean = score_result_struct.part{variante_name_index}.parameters.eer_gender_balanced_mean;
		
							ud.exp_info = get(current_figure_handle,'Name');
							ud.simple_info=[draw_client ', ' spk_info_struct(str2num(draw_client)).sex ', ' spk_info_struct(str2num(draw_client)).age ', ' spk_info_struct(str2num(draw_client)).region  '<br>eer = ' num2str(eer,3) ' %'];
						otherwise
							set(findobj(current_figure_handle,'Tag','draw_busy'), 'BackgroundColor', busy_color_free);
							return;
					end
				else
					if (draw_client_index_counter == 1)
						model_set = {};
					end

					[imp_spk_names, imp_index_array, several_imp_flag] = local_get_imp_spks_list(result_index,draw_client, current_draw_client_index);

					draw_FR_rec_indizes = find_sessions_in_F_struct(FR_struct{current_draw_client_index}, fr_display_sessions, {'all'}, ext_model_info);
					draw_FA_rec_indizes = find_sessions_in_F_struct(FA_struct{current_draw_client_index}, fa_display_sessions, imp_spk_names, ext_model_info);
	
					FR_borders = FR_struct{current_draw_client_index}.data.borders(draw_FR_rec_indizes);
					FA_borders = FA_struct{current_draw_client_index}.data.borders(draw_FA_rec_indizes);
	
					[eer, eer_coarse,threshold, threshold_coarse] = calc_EER(FR_borders, FA_borders);
					model_set = {model_set{:} draw_client};
					
					ud.exp_info = get(current_figure_handle,'Name');
					ud.simple_info=[draw_client ', ' spk_info_struct(str2num(draw_client)).sex ', ' spk_info_struct(str2num(draw_client)).age ', ' spk_info_struct(str2num(draw_client)).region  '<br>eer = ' num2str(eer,3) ' %; client spk data: ' join_strings(fr_display_sessions,', ') '; imp spk data: ' join_strings(fa_display_sessions,', ')];
					
				end
				
				hold on;
				
				temp_handle=plot(current_draw_client_index,eer,'+','Color',mycolors(current_draw_client_index,:));
				set(temp_handle,'Tag','DataLine');
				set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
				set(temp_handle,'UserData',ud);

				if (draw_client_index_counter == 1),
					if (strcmp(draw_functions{function_name_index},'(SR) EER vs model')),
						temp_handle=plot([0 (num_client_spks+1)], [eer_mean eer_mean],'w--');
						set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
						set(temp_handle,'UserData','EER mean');
						info_text_cell{1} = ['EER mean: ' num2str(eer_mean,3)];
						
						temp_handle=plot([0 (num_client_spks+1)], [eer_male_mean eer_male_mean],'w--');
						set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
						set(temp_handle,'UserData','EER mean (males)');
						info_text_cell{2} = ['EER mean (males): ' num2str(eer_male_mean,3)];
		
						temp_handle=plot([0 (num_client_spks+1)], [eer_female_mean eer_female_mean],'w--');
						set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
						set(temp_handle,'UserData','EER mean (females)');
						info_text_cell{3} = ['EER mean (females): ' num2str(eer_female_mean,3)];
						
						temp_handle=plot([0 (num_client_spks+1)], [eer_gender_balanced_mean eer_gender_balanced_mean],'w--');
						set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
						set(temp_handle,'UserData','EER mean (gender balanced)');
						info_text_cell{4} = ['EER mean (gender balanced): ' num2str(eer_gender_balanced_mean,3)];

						box_handle = create_legend_box(info_text_cell);
						
					end
					
					title('EER vs client number');
					xlabel('client index');
					ylabel('EER rate, percent');
					
				end
				
				if (draw_client_index_counter == length(draw_client_array)),
					axis auto;
					temp_axis = axis;
					temp_axis(2) = (num_client_spks+1);
					axis(temp_axis);			

					if (strcmp(draw_functions{function_name_index},'(SR) EER vs model')),
						temp_axes = gca;
						axes(box_handle);
						set(current_figure_handle,'currentaxes',temp_axes);
					else
						imp_spks_index = get(findobj(current_figure_handle,'Tag','imp_spks'), 'Value');
						imp_spks_list_strings = get(findobj(current_figure_handle,'Tag','imp_spks'), 'String');
						imp_spks_selected_lists = imp_spks_list_strings(imp_spks_index);

						score_result_struct = {};
						score_result_struct = calc_score_result_eer_part(score_result_struct, 1, Results{result_index}, ext_model_info, model_set, imp_spks_selected_lists, fr_display_sessions, fa_display_sessions);
						score_result_struct.part{1}.parameters
					end
					
					hold_status = get(findobj(current_figure_handle,'Tag','hold'), 'Value');
					if (hold_status)
					else
						hold off;
					end
				end

			case 'FR vs model'
				for i=1:num_client_spks
					if (strcmp(draw_client,client_spks{i}))
						model_index = i;
						break;
					end
				end

				switch score_result_struct.part{variante_name_index}.result_type
					case 'eer'
						fr = score_result_struct.part{variante_name_index}.model(current_draw_client_index).data.eer;
						fr_mean = score_result_struct.part{variante_name_index}.parameters.eer_mean;
						fr_male_mean = score_result_struct.part{variante_name_index}.parameters.eer_male_mean;
						fr_female_mean = score_result_struct.part{variante_name_index}.parameters.eer_female_mean;
						fr_gender_balanced_mean = score_result_struct.part{variante_name_index}.parameters.eer_gender_balanced_mean;
					case {'fr_fa';'det'}
						fr = score_result_struct.part{variante_name_index}.model(current_draw_client_index).data.fr;
						fr_mean = score_result_struct.part{variante_name_index}.parameters.fr_mean;
						fr_male_mean = score_result_struct.part{variante_name_index}.parameters.fr_male_mean;
						fr_female_mean = score_result_struct.part{variante_name_index}.parameters.fr_female_mean;
						fr_gender_balanced_mean = score_result_struct.part{variante_name_index}.parameters.fr_gender_balanced_mean;
					otherwise
						set(findobj(current_figure_handle,'Tag','draw_busy'), 'BackgroundColor', busy_color_free);
						return;
				end % switch variante
				
				hold on;

				temp_handle=plot(current_draw_client_index,fr,'+','Color',mycolors(current_draw_client_index,:));
				set(temp_handle,'Tag','DataLine');
				set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
				ud.exp_info = get(current_figure_handle,'Name');
				ud.simple_info=[draw_client ', ' spk_info_struct(str2num(draw_client)).sex ', ' spk_info_struct(str2num(draw_client)).age ', ' spk_info_struct(str2num(draw_client)).region  '<br>fr = ' num2str(fr,3) ' %'];
				set(temp_handle,'UserData',ud);

				if (draw_client_index_counter == 1),
						temp_handle=plot([0 (num_client_spks+1)], [fr_mean fr_mean],'w--');
						set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
						set(temp_handle,'UserData','FR mean');
						info_text_cell{1} = ['FR mean: ' num2str(fr_mean,3)];
						
						temp_handle=plot([0 (num_client_spks+1)], [fr_male_mean fr_male_mean],'w--');
						set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
						set(temp_handle,'UserData','FR mean (males)');
						info_text_cell{2} = ['FR mean (males): ' num2str(fr_male_mean,3)];
		
						temp_handle=plot([0 (num_client_spks+1)], [fr_female_mean fr_female_mean],'w--');
						set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
						set(temp_handle,'UserData','FR mean (females)');
						info_text_cell{3} = ['FR mean (females): ' num2str(fr_female_mean,3)];
						
						temp_handle=plot([0 (num_client_spks+1)], [fr_gender_balanced_mean fr_gender_balanced_mean],'w--');
						set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
						set(temp_handle,'UserData','FR mean (gender balanced)');
						info_text_cell{4} = ['FR mean (gender balanced): ' num2str(fr_gender_balanced_mean,3)];
						
						
						box_handle = create_legend_box(info_text_cell);
						
						title('FR vs client number');
						xlabel('client index');
						ylabel('FR rate, percent');

				end

				if (draw_client_index_counter == length(draw_client_array)),
						axis auto;
						temp_axis = axis;
						temp_axis(2) = (num_client_spks+1);
						axis(temp_axis);
						temp_axes = gca;
						axes(box_handle);
						set(current_figure_handle,'currentaxes',temp_axes);

						hold_status = get(findobj(current_figure_handle,'Tag','hold'), 'Value');
						if (hold_status)
						else
							hold off;
						end


				end




			case 'FA vs model'

				switch score_result_struct.part{variante_name_index}.result_type
					case 'eer'
						fa = score_result_struct.part{variante_name_index}.model(current_draw_client_index).data.eer;
						fa_mean = score_result_struct.part{variante_name_index}.parameters.eer_mean;
						fa_male_mean = score_result_struct.part{variante_name_index}.parameters.eer_male_mean;
						fa_female_mean = score_result_struct.part{variante_name_index}.parameters.eer_female_mean;
						fa_gender_balanced_mean = score_result_struct.part{variante_name_index}.parameters.eer_gender_balanced_mean;
					case {'fr_fa';'det'}
						fa = score_result_struct.part{variante_name_index}.model(current_draw_client_index).data.fa_against_client_mean;
						fa_mean = score_result_struct.part{variante_name_index}.parameters.fa_mean;
						fa_male_mean = score_result_struct.part{variante_name_index}.parameters.fa_male_mean;
						fa_female_mean = score_result_struct.part{variante_name_index}.parameters.fa_female_mean;
						fa_gender_balanced_mean = score_result_struct.part{variante_name_index}.parameters.fa_gender_balanced_mean;
					otherwise
						set(findobj(current_figure_handle,'Tag','draw_busy'), 'BackgroundColor', busy_color_free);
						return;

				end % switch variante

				hold on;
				
				temp_handle=plot(current_draw_client_index,fa,'+','Color',mycolors(current_draw_client_index,:));
				set(temp_handle,'Tag','DataLine');
				set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
				ud.exp_info = get(current_figure_handle,'Name');
				ud.simple_info=[draw_client ', ' spk_info_struct(str2num(draw_client)).sex ', ' spk_info_struct(str2num(draw_client)).age ', ' spk_info_struct(str2num(draw_client)).region  '<br>fa = ' num2str(fa,3) ' %'];
				set(temp_handle,'UserData',ud);

				if (draw_client_index_counter == 1),
						temp_handle=plot([0 (num_client_spks+1)], [fa_mean fa_mean],'w--');
						set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
						set(temp_handle,'UserData','FA mean');
						info_text_cell{1} = ['FA mean: ' num2str(fa_mean,3)];
						
						temp_handle=plot([0 (num_client_spks+1)], [fa_male_mean fa_male_mean],'w--');
						set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
						set(temp_handle,'UserData','FA mean (males)');
						info_text_cell{2} = ['FA mean (males): ' num2str(fa_male_mean,3)];
		
						temp_handle=plot([0 (num_client_spks+1)], [fa_female_mean fa_female_mean],'w--');
						set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
						set(temp_handle,'UserData','FA mean (females)');
						info_text_cell{3} = ['FA mean (females): ' num2str(fa_female_mean,3)];
						
						temp_handle=plot([0 (num_client_spks+1)], [fa_gender_balanced_mean fa_gender_balanced_mean],'w--');
						set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
						set(temp_handle,'UserData','FA mean (gender balanced)');
						info_text_cell{4} = ['FA mean (gender balanced): ' num2str(fa_gender_balanced_mean,3)];
						
						box_handle = create_legend_box(info_text_cell);
						
						title('FA vs client number');
						xlabel('client index');
						ylabel('FA rate, percent');
						
				end

				if (draw_client_index_counter == length(draw_client_array)),
						axis auto;
						temp_axis = axis;
						temp_axis(2) = (num_client_spks+1);
						axis(temp_axis);
						temp_axes = gca;
						axes(box_handle);
						set(current_figure_handle,'currentaxes',temp_axes);

						hold_status = get(findobj(current_figure_handle,'Tag','hold'), 'Value');
						if (hold_status)
						else
							hold off;
						end

		
				end
				
			case 'FA vs imp. spk'

				if (draw_client_index_counter == 1),
					if (draw_several_models),
						for imp=1:num_imp_spks,
							fa_infavour_imp(imp)=score_result_struct.part{variante_name_index}.parameters.fa_infavour_imp(imp);
						end
					else % fa_infavour_imp for single model
						for imp=1:num_imp_spks,
							[found, index_cell] = findstr_inCell(imp_test_spks{imp}, score_result_struct.part{variante_name_index}.model(current_draw_client_index).imp_spks);
							if (found),
								fa_infavour_imp(imp)=score_result_struct.part{ variante_name_index }.model( current_draw_client_index ).data.fa_imposter(imp);
							else
								fa_infavour_imp(imp)=NaN;
							end
						end
					end

					hold on;
					
					for imp=1:num_imp_spks,
						if (draw_several_models),
							temp_handle=plot(imp,fa_infavour_imp(imp),'+','Color','w');
							set(temp_handle,'UserData',['Imp. spk: ' imp_test_spks{imp} ', Model: all, fa = ' num2str(fa_infavour_imp(imp),3) ' %']);
						else
							temp_handle=plot(imp,fa_infavour_imp(imp),'+','Color',mycolors(current_draw_client_index,:));
							set(temp_handle,'UserData',['Imp. spk: ' imp_test_spks{imp} ', Model: ' draw_client ', fa = ' num2str(fa_infavour_imp(imp),3) ' %']);
						end
						set(temp_handle,'Tag','DataLine');
						set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
					end
				end


				if (draw_client_index_counter == 1),
						
						title('FA in favour impostor vs imposter speaker');
						xlabel('impostor speaker index');
						ylabel('FA rate, percent');
						
				end

				if (draw_client_index_counter == length(draw_client_array)),
						axis auto;
						temp_axis = axis;
						temp_axis(2) = (num_imp_spks+1);
						axis(temp_axis);

						hold_status = get(findobj(current_figure_handle,'Tag','hold'), 'Value');
						if (hold_status)
						else
							hold off;
						end

		
				end
				

			case 'FA client/imp matrix'
				fa_m = repmat( -1, 1, num_imp_spks );
				for imp=1:length(score_result_struct.part{variante_name_index}.model(current_draw_client_index).imp_spks),
					current_imp_speaker = score_result_struct.part{variante_name_index}.model(current_draw_client_index).imp_spks(imp);
					absolut_index = strmatch(current_imp_speaker, imp_test_spks,'exact');
					fa_m(absolut_index)=score_result_struct.part{variante_name_index}.model(current_draw_client_index).data.fa_imposter(imp);
				end
				fa_against_client_mean(current_draw_client_index)=score_result_struct.part{variante_name_index}.model(current_draw_client_index).data.fa_against_client_mean;
				
				
				if (draw_client_index_counter == 1),
					for imp=1:num_imp_spks,
						fa_infavour_imp(imp)=score_result_struct.part{variante_name_index}.parameters.fa_infavour_imp(imp);
					end
				end
				
				hold on;

				for imp=1:num_imp_spks,
					h=patch([imp-0.5 imp-0.5 imp+0.5 imp+0.5],[current_draw_client_index-0.5 current_draw_client_index+0.5 current_draw_client_index+0.5 current_draw_client_index-0.5],fa_m(imp));
					set(h,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
					set(h,'UserData',['model: ' client_spks{current_draw_client_index} '; imp: ' imp_test_spks{imp} '; fa = ' num2str(fa_m(imp),3) ' %']);
					if (fa_m(imp) == 0),
						set(h,'FaceColor',[ 0 0 0.6]);
					elseif (fa_m(imp) == -1),
						set(h,'FaceColor',[ 0 0.3 0.3]);
					end
				end
			
				imp = num_imp_spks + 2;
				h=patch([imp-0.5 imp-0.5 imp+0.5 imp+0.5],[current_draw_client_index-0.5 current_draw_client_index+0.5 current_draw_client_index+0.5 current_draw_client_index-0.5],fa_against_client_mean(current_draw_client_index)*6);
				set(h,'ButtonDownFcn',['mark_model(' num2str(current_draw_client_index) ');Plot_SR_parameters_Callback(''star_click'')']);
				set(h,'UserData',['model: ' client_spks{current_draw_client_index} '; fa against reg mod. = ' num2str(fa_against_client_mean(current_draw_client_index),3) ' %']);
				if (fa_against_client_mean(current_draw_client_index) == 0),
					set(h,'FaceColor',[ 0 0 0.6]);
				end
				
				if (draw_client_index_counter == 1),
					for imp=1:num_imp_spks,
						model_dummy = num_client_spks + 2;
						h=patch([imp-0.5 imp-0.5 imp+0.5 imp+0.5],[model_dummy-0.5 model_dummy+0.5 model_dummy+0.5 model_dummy-0.5],fa_infavour_imp(imp)*3);
						set(h,'ButtonDownFcn',['mark_imp(' num2str(imp) ');Plot_SR_parameters_Callback(''star_click'')']);
						set(h,'UserData',['imp: ' imp_test_spks{imp} '; fa in favour imp. = ' num2str(fa_infavour_imp(imp),3) ' %']);
						if (fa_infavour_imp(imp) == 0),
							set(h,'FaceColor',[ 0 0 0.6]);
						end
					end
					title('FA on grid registered client vs imposter speaker');
					xlabel('impostor speaker index');
					ylabel('registered client index');

				end
				

				if (draw_client_index_counter == length(draw_client_array)),
					set(gca,'XLim',[0 (num_imp_spks+3)]);
					set(gca,'YLim',[0 (num_client_spks+3)]);
					set(gca,'XTick',(0:5:num_imp_spks));
					set(gca,'YTick',(0:5:num_client_spks));
					
					
					colormap('hot')
					caxis([0 30])

					hold_status = get(findobj(current_figure_handle,'Tag','hold'), 'Value');
					if (hold_status)
					else
						hold off;
					end
				end

			case {'Rel. unreliability';'Rel. vulnerability';'Rel. imitation ability'}
				
				
				if (draw_client_index_counter == 1),
					switch draw_functions{function_name_index}
						case 'Rel. unreliability',
							model_index_vector = (1:num_client_spks);
							rel_contr = score_result_struct.part{variante_name_index}.parameters.rel_unreliability;
							theo_rel_contr = 1 / num_client_spks;
						case 'Rel. vulnerability',
							model_index_vector = (1:num_client_spks);
							rel_contr = score_result_struct.part{variante_name_index}.parameters.rel_vulnerability;
							theo_rel_contr = 1 / num_client_spks;
						case 'Rel. imitation ability',
							model_index_vector = (1:num_imp_spks);
							rel_contr = score_result_struct.part{variante_name_index}.parameters.rel_imitation_ability;
							theo_rel_contr = 1 / num_imp_spks;
					end
				end
				
				hold on;

				if (draw_client_index_counter == 1),
					for i=1:length(model_index_vector),
						h = plot(model_index_vector(i),rel_contr(i),'*','Color','y');
						set(h,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
						switch draw_functions{function_name_index}
							case 'Rel. unreliability',
								set(h,'UserData',['model: ' client_spks{i} '; fr rel = ' num2str(rel_contr(i),3)]);
								title('Relative unreliability vs registered speaker');
								xlabel('registered speaker index');
								ylabel('Rel. unreliability');
							case 'Rel. vulnerability',
								set(h,'UserData',['model: ' client_spks{i} '; fa rel = ' num2str(rel_contr(i),3)]);
								title('Relative vulnerability vs registered speaker');
								xlabel('registered speaker index');
								ylabel('Rel. vulnerability');
							case 'Rel. imitation ability',
								set(h,'UserData',['imp: ' imp_test_spks{i} '; fa rel = ' num2str(rel_contr(i),3)]);
								title('Relative imitation ability vs impostor speaker');
								xlabel('impostor speaker index');
								ylabel('Rel. imitation ability');
						end
	
					end
						temp_handle=plot([0 length(model_index_vector)+1], [theo_rel_contr theo_rel_contr],'w--');
						set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
						set(temp_handle,'UserData','theoretical rel. contribution');

				end
				

				if (draw_client_index_counter == length(draw_client_array)),
					switch draw_functions{function_name_index}
						case 'Rel. unreliability',
							set(gca,'XLim',[0 (num_client_spks+1)]);
						case 'Rel. vulnerability',
							set(gca,'XLim',[0 (num_client_spks+1)]);
						case 'Rel. imitation ability',
							set(gca,'XLim',[0 (num_imp_spks+1)]);
					end

					hold_status = get(findobj(current_figure_handle,'Tag','hold'), 'Value');
					if (hold_status)
					else
						hold off;
					end
				end
				
			case 'World scores'
				%imp_spk_list = get(findobj(current_figure_handle,'Tag','s_models'), 'String');

				[imp_spk_names, imp_index_array, several_imp_flag] = local_get_imp_spks_list(result_index,draw_client, current_draw_client_index);
				
				
				if (draw_client_index_counter == 1)
					if (~draw_several_models) & (several_imp_flag)
						temp_F_struct.data = Results{result_index}.worlddata.modeldata{current_draw_client_index};
						draw_rec_indizes = find_sessions_in_F_struct(temp_F_struct, fr_display_sessions, {'all'}, ext_model_info);
						borders_vector = temp_F_struct.data.borders(draw_rec_indizes);
						%borders_vector = temp_F_struct.data.borders;
					elseif (~several_imp_flag)
						% nur single impostor
						if (isfield(Results{result_index}.worlddata , 'impdata')),
							temp_F_struct.data = Results{result_index}.worlddata.impdata{imp_index_array};
							draw_rec_indizes = find_sessions_in_F_struct(temp_F_struct, fa_display_sessions, {'all'}, ext_model_info);
							borders_vector = temp_F_struct.data.borders(draw_rec_indizes);
							%borders_vector = Results{result_index}.worlddata.impdata{imp_index_array}.borders;
						else
							if (isfield(Results{result_index},'cross_validation_flag') & (Results{result_index}.cross_validation_flag)),
								disp('This is a cross validation result struct i.e. client and impostor speakers are the same; see requested world data by selection a spk model!');
								set(findobj(current_figure_handle,'Tag','draw_busy'), 'BackgroundColor', busy_color_free);
								return;
							end
						end
					else
						set(findobj(current_figure_handle,'Tag','draw_busy'), 'BackgroundColor', busy_color_free);
						return;
					end
					
					vector_length=length(borders_vector);
					probabilities = (1:vector_length) / vector_length * 100;
					probabilities = [probabilities];
	
					temp_handle=plot(borders_vector,probabilities,'Color',mycolors(current_draw_client_index,:));
					temp_length=length(get(temp_handle,'XData'));
					set(temp_handle,'ZData',ones(1,temp_length)*(-current_draw_client_index));
					set(temp_handle,'Tag','DataLine');
					
					if (~draw_several_models) & (several_imp_flag)
						ud.exp_info = get(current_figure_handle,'Name');
						ud.simple_info=draw_client;
					else
						% single impostor
						imp_spks = imp_test_spks{imp_index_array};
						ud.exp_info = get(current_figure_handle,'Name');
						ud.simple_info=imp_spks;
					end
					set(temp_handle,'UserData',ud);
					set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');

					stars_status = get(findobj(current_figure_handle,'Tag','stars'), 'Value');
					if (stars_status) & (result_index ~= 0) 
						hold on;
						h_current_main_figure = current_figure_handle;
						set(0,'CurrentFigure',[h_current_main_figure]);
						for j=1:length(draw_rec_indizes),
							temp_handle=plot(borders_vector(j),probabilities(j),'*','Color',mycolors(current_draw_client_index,:));
							set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
							
							if (~draw_several_models) & (several_imp_flag)
								ud.info = [ temp_F_struct.data.rec_info(draw_rec_indizes(j),:) '/' 'world'];
								ud.type = 'world model';
								ud.model_index = current_draw_client_index;
								set(temp_handle,'ZData',[-current_draw_client_index]);
							else
								% single impostor
								ud.info = [ temp_F_struct.data.rec_info(draw_rec_indizes(j),:) '/' 'world'];
								ud.type = 'world imp';
								ud.model_index = imp_index_array;
								set(temp_handle,'ZData',[-imp_index_array]);
							end
							ud.rec_index = draw_rec_indizes(j);
							set(temp_handle,'UserData',ud);
						end
						hold_status = get(findobj(current_figure_handle,'Tag','hold'), 'Value');
						if (hold_status)
						else
							hold off;
						end
		
					end
					title('cum. sum world scores vs llh sum');
					xlabel('llh sum per utterance');
					ylabel('cum. sum world scores, percent');
				end				

			case 'single scores'
				
				if (draw_client_index_counter == 1)

					borders_vector = Score_Structs{score_struct_index}.borders;
					
					vector_length=length(borders_vector);
					probabilities = (1:vector_length) / vector_length * 100;
					probabilities = [probabilities];
	
					temp_handle=plot(borders_vector,probabilities,'Color',mycolors(current_draw_client_index,:));
					temp_length=length(get(temp_handle,'XData'));
					set(temp_handle,'ZData',ones(1,temp_length)*(-current_draw_client_index));
					set(temp_handle,'Tag','DataLine');
					
					ud.exp_info = get(current_figure_handle,'Name');
					ud.simple_info='single score struct';
					set(temp_handle,'UserData',ud);
					set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');

					stars_status = get(findobj(current_figure_handle,'Tag','stars'), 'Value');
					if (stars_status) & (score_struct_index ~= 0) 
						hold on;
						h_current_main_figure = current_figure_handle;
						set(0,'CurrentFigure',[h_current_main_figure]);
						for j=1:length(borders_vector),
							temp_handle=plot(borders_vector(j),probabilities(j),'*','Color',mycolors(current_draw_client_index,:));
							set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
							
							ud.info = [ Score_Structs{score_struct_index}.rec_info(j,:) '/' Score_Structs{score_struct_index}.rec_info(j,(1:4))];
							ud.type = 'single struct';

							ud.rec_index = j;
							set(temp_handle,'UserData',ud);
						end
						hold_status = get(findobj(current_figure_handle,'Tag','hold'), 'Value');
						if (hold_status)
						else
							hold off;
						end
		
					end
					title('cum. sum single scores vs llh sum');
					xlabel('llh sum per utterance');
					ylabel('cum. sum single scores, percent');
				end				
				
				
			end % switch draw_functions{function_name_index}

		
		end % for current_draw_client_index
		if (draw_several_models) & (hold_temp_flag == 0),
			hold off;
		end

		found_handle = findobj(current_figure_handle,'Type','axes','Tag','legend');
		if ~(isempty(found_handle)),
			set(current_figure_handle,'currentaxes',found_handle);
		end
		
		set(findobj(current_figure_handle,'Tag','draw_busy'), 'BackgroundColor', busy_color_free);

	case 'edit'
		edit_handle = findobj(current_figure_handle, 'Tag', 'Edit_Button');
		edit_obj = get(edit_handle,'UserData');
		
		propedit(edit_obj);
	
	
	
	case 'star_click'
		exp_info_handle = findobj(current_figure_handle,'Tag','exp_info');
		info1_handle = findobj(current_figure_handle,'Tag','info1');
		info2_handle = findobj(current_figure_handle,'Tag','info2');
		info3_handle = findobj(current_figure_handle,'Tag','info3');
		label1_handle = findobj(current_figure_handle,'Tag','label1');
		label2_handle = findobj(current_figure_handle,'Tag','label2');
		
		edit_handle = findobj(current_figure_handle, 'Tag', 'Edit_Button');
		set(edit_handle,'UserData',gcbo);
		
		spk_info_struct = get(findobj(current_figure_handle,'Tag','Info_Button'), 'UserData');
		
		point_struct=get(gcbo,'UserData');
		
		if (isfield(point_struct,'exp_info')),
			exp_info = point_struct.exp_info;
		else
			exp_info = '';
		end
		if (ishandle(info1_handle)),
			set(exp_info_handle,'String',exp_info);
		end
		
		if (isfield(point_struct,'info')),
			if (size(point_struct.info,1) == 1)
				text = point_struct.info;
			else % multi column
				text = join_strings(cellstr(point_struct.info), ',');
			end
			if (isfield(point_struct,'model_index')),
				model_index = point_struct.model_index;
			else
				model_index = 0;
			end
			rec_index = point_struct.rec_index;
		elseif (isfield(point_struct,'simple_info')),
			text = point_struct.simple_info;
		else
			text = point_struct;
		end
		if (ishandle(info1_handle)),
			if (isfield(point_struct,'type')) & (strcmp(point_struct.type,'FA')),
				slash_indizes=findstr(text,'/');
				if (~isempty(slash_indizes))
					subject = text(1:slash_indizes(1)-1);
					set(info1_handle,'String',text);
					set(info2_handle,'String',[spk_info_struct(str2num(subject)).sex ', ' spk_info_struct(str2num(subject)).age ', ' spk_info_struct(str2num(subject)).region]);
					set(info3_handle,'String','');
				end
			else
				br_index = findstr(text,'<br>');
				if (~isempty(br_index))
					if (length(br_index) == 1),
						set(info1_handle,'String',text(1:br_index(1)-1));
						set(info2_handle,'String',text(br_index(1)+4:end));
						set(info3_handle,'String','');
					elseif (length(br_index) == 2),
						set(info1_handle,'String',text(1:br_index(1)-1));
						set(info2_handle,'String',text(br_index(1)+4:br_index(2)-1));
						set(info3_handle,'String',text(br_index(2)+4:end));
					end
				else
					set(info1_handle,'String',text);
					set(info2_handle,'String','');
					set(info3_handle,'String','');
				end
			end
		end
		slash_indizes=findstr(text,'/');
		if (~isempty(slash_indizes)),
			sep_indizes = findstr(text,',');
			sep_indizes = sort([1 (sep_indizes-1) sep_indizes length(text)]);
			for i=1:2:(length(sep_indizes)),
				single_info_string = text(sep_indizes(i):sep_indizes(i+1));
				slash_indizes=findstr(single_info_string,'/');
				subject = single_info_string(1:slash_indizes(1)-1);
				session = single_info_string(slash_indizes(1)+1:slash_indizes(2)-1);
				recording = single_info_string(slash_indizes(2)+1:end);
				
				search_pattern = strcat(rawdatapath, subject, filesep, session, filesep, '*', recording,'.', label_file_ext);
				dir_struct = dir(search_pattern);
				if ~(isempty(dir_struct)),
					filename = dir_struct.name;
					[prompt_string, realized_string] = read_label_file( subject, session, filename);
					if (ishandle(label1_handle)),
						set(label1_handle,'String',prompt_string);
					end
					if (ishandle(label2_handle)),
						set(label2_handle,'String',realized_string);
					end
				end
			end
		end
		
		if (isfield(point_struct,'info')) & (((result_index ~= 0) & isfield(FR_struct{1}.data , 'mlf_data')) | (  (score_struct_index ~= 0) & isfield(Score_Structs{score_struct_index}, 'mlf_data'))),
			draw_mlf_struct = struct('start_vector',[],'phoneme_vector',[],'end_time',0);
			draw_rec_info = [];
			for i=1:length(rec_index),
				current_rec_index = rec_index(i);
				if strcmp(point_struct.type,'FR'),
					mlf_struct=FR_struct{model_index}.data.mlf_data(current_rec_index);
					rec_info=FR_struct{model_index}.data.rec_info(current_rec_index,:);
				elseif strcmp(point_struct.type,'FA'),
					mlf_struct=FA_struct{model_index}.data.mlf_data(current_rec_index);
					rec_info=FA_struct{model_index}.data.rec_info(current_rec_index,:);
				elseif strcmp(point_struct.type,'world model'),
					mlf_struct=Results{result_index}.worlddata.modeldata{model_index}.mlf_data(current_rec_index);
					rec_info=Results{result_index}.worlddata.modeldata{model_index}.rec_info(current_rec_index,:);
				elseif strcmp(point_struct.type,'world imp'),
					mlf_struct=Results{result_index}.worlddata.impdata{model_index}.mlf_data(current_rec_index);
					rec_info=Results{result_index}.worlddata.impdata{model_index}.rec_info(current_rec_index,:);
				elseif strcmp(point_struct.type,'single struct'),
					draw_mlf_struct = struct('start_vector',[],'phoneme_vector',[],'end_time',0, 'llh_values', []);
					mlf_struct=Score_Structs{score_struct_index}.mlf_data(current_rec_index);
					rec_info=Score_Structs{score_struct_index}.rec_info(current_rec_index,:);
				end
				draw_mlf_struct = join_mlf_structs(draw_mlf_struct, mlf_struct);
				draw_rec_info(end+1,:) = rec_info;
			end
			draw_force_aligned_borders(draw_mlf_struct, draw_rec_info);
			%keyboard;
			% recompute start end end times  if necessary
			if ( isfield(model_info , 'paramPool_config') )
				if ( model_info.paramPool_config.useSilDet == 1)
					% silence detection was used, 
					old_handles = findobj(current_figure_handle,'Tag','force_aligned_borders','Style','pushbutton');
					if ~(isempty(old_handles)),
						for h=1:length(old_handles),
							%time_struct = get(old_handles(h), 'UserData');
							%time_struct = recompute_dea_time_mapping(time_struct, model_info.paramPool_config);
							%set(old_handles(h), 'UserData', time_struct);
						end
					end
				end
			end
		end
		
	case 'show llh'
		set(findobj(current_figure_handle,'Tag','draw_busy'), 'BackgroundColor', busy_color_working);
		drawnow;
		info1_handle = findobj(current_figure_handle,'Tag','info1');
		info_string = get(info1_handle,'String');
		slash_indizes=findstr(info_string,'/');
		subject = info_string(1:slash_indizes(1)-1);
		session = info_string(slash_indizes(1)+1:slash_indizes(2)-1);
		recording = info_string(slash_indizes(2)+1:slash_indizes(3)-1);
		model = info_string(slash_indizes(3)+1:end);
		
		if (result_index ~= 0),
			model_archive = Results{result_index}.expDetails.model_archive;
		else
			model_archive = [];
		end	

		search_pattern = strcat(rawdatapath, subject, filesep, session, filesep, '*', recording,'.', audio_file_ext);
		dir_struct = dir(search_pattern);
		if ~(isempty(dir_struct)),
			filename = dir_struct.name;
			show_llh_per_frame(exp_name, model_info, subject, session, filename, model, model_archive);
		end
		set(findobj(current_figure_handle,'Tag','draw_busy'), 'BackgroundColor', busy_color_free);

	case {'play', 'play with SD'}
		set(findobj(current_figure_handle,'Tag','draw_busy'), 'BackgroundColor', busy_color_working);
		drawnow;
		info1_handle = findobj(current_figure_handle,'Tag','info1');
		info_string = get(info1_handle,'String');
		slash_indizes=findstr(info_string,'/');
		subject = info_string(1:slash_indizes(1)-1);
		session = info_string(slash_indizes(1)+1:slash_indizes(2)-1);
		recording = info_string(slash_indizes(2)+1:slash_indizes(3)-1);
		
		search_pattern = strcat(rawdatapath, subject, filesep, session, filesep, '*', recording,'.', audio_file_ext);
		dir_struct = dir(search_pattern);
		if ~(isempty(dir_struct)),
			filename = dir_struct.name;
			if (strcmp(action,'play')),
				play_sound_file(subject, session, filename);
			else
				play_sound_file_with_SD(subject, session, filename, model_info);
			end
		end
		set(findobj(current_figure_handle,'Tag','draw_busy'), 'BackgroundColor', busy_color_free);
		
		
	case 'play part'
		set(findobj(current_figure_handle,'Tag','draw_busy'), 'BackgroundColor', busy_color_working);
		drawnow;
		info1_handle = findobj(current_figure_handle,'Tag','info1');
		info_string = get(info1_handle,'String');
		slash_indizes=findstr(info_string,'/');
		subject = info_string(1:slash_indizes(1)-1);
		session = info_string(slash_indizes(1)+1:slash_indizes(2)-1);
		recording = info_string(slash_indizes(2)+1:slash_indizes(3)-1);
		
		label_handle = gcbo;
		time_struct = get(label_handle,'UserData');
		
		search_pattern = strcat(rawdatapath, subject, filesep, session, filesep, '*', recording, '.', audio_file_ext);
		dir_struct = dir(search_pattern);
		if ~(isempty(dir_struct)),
			filename = dir_struct.name;
			play_sound_file(subject, session, filename,time_struct);
		end
		set(findobj(current_figure_handle,'Tag','draw_busy'), 'BackgroundColor', busy_color_free);
		
	case 'info'
		pos = get(current_figure_handle,'Position');
		x_dg = pos(1)+pos(3);
		y_dg = pos(2)+pos(4);
		if (result_index ~= 0),
			info = Results{result_index}.info;	
		end	
		if (score_result_index ~= 0),
			info = score_result_struct.info;
		end
		if ((length(info) == 1) & (isempty(info{1})) ),
			info = {'no info'};
		end
		dg_height = length(info) * 12 + 55;
		h_dg=dialog('Position',[x_dg+20, y_dg-dg_height, 300, dg_height],'WindowStyle','normal');
		set(h_dg,'Resize','on');
		info_handle1 = uicontrol('Parent',h_dg, ...
			'Units','points', ...
			'Position',[1 (dg_height-15) 300 20], ...
			'Style','text', ...
			'String','Remarks', ...
			'FontSize',14);
		info_handle2 = uicontrol('Parent',h_dg, ...
			'Units','points', ...
			'Position',[1 1 300 (dg_height-35)], ...
			'Style','text', ...
			'HorizontalAlignment', 'left', ...
			'String',info, ...
			'FontSize',10);
		
	
	case 'clear_marked_stars'
		set(findobj(current_figure_handle,'Tag','draw_busy'), 'BackgroundColor', busy_color_working);
		drawnow;
		h_marked=findobj(gca,'Color',star_color);
		if (isempty(h_marked)),
			return;
		end
		user_data_cell_temp = get(h_marked,'UserData');
		if (~(iscell(user_data_cell_temp))),
			user_data_cell{1} = user_data_cell_temp;
		else
			user_data_cell = user_data_cell_temp;
		end
		for i=1:length(user_data_cell),
			if (strcmp(user_data_cell{i}.type,'FR'))
				set(h_marked(i),'Color',mycolors(user_data_cell{i}.model_index,:)+0.3*(1-mycolors(user_data_cell{i}.model_index,:)));
			elseif (strcmp(user_data_cell{i}.type,'FA'))
				set(h_marked(i),'Color',mycolors(user_data_cell{i}.model_index,:));		
			elseif (strcmp(user_data_cell{i}.type,'world model'))
				set(h_marked(i),'Color',mycolors(user_data_cell{i}.model_index,:));
			elseif (strcmp(user_data_cell{i}.type,'world imp'))
				set(h_marked(i),'Color',mycolors(1,:));
			elseif (strcmp(user_data_cell{i}.type,'single struct'))
				set(h_marked(i),'Color',mycolors(1,:));
			end
			temp_z=get(h_marked(i),'ZData');
			set(h_marked(i),'ZData',temp_z - 1);
		end
		set(findobj(current_figure_handle,'Tag','draw_busy'), 'BackgroundColor', busy_color_free);
		
	case 'show'
		set(findobj(current_figure_handle,'Tag','draw_busy'), 'BackgroundColor', busy_color_working);
		drawnow;

		search_model_index = get(findobj(current_figure_handle,'Tag','s_models'), 'Value');
		search_session_index = get(findobj(current_figure_handle,'Tag','s_sessions'), 'Value');
		model_list = get(findobj(current_figure_handle,'Tag','s_models'), 'String');
		session_list = get(findobj(current_figure_handle,'Tag','s_sessions'), 'String');

		if (search_model_index < 4)
			search_model = model_list(search_model_index);
		else
			search_model = imp_test_spks(search_model_index - 3);
		end
		search_session = session_list(search_session_index);

		handles_to_search = get(gca, 'Children');

		ext_model_info = get(findobj(current_figure_handle,'Tag','fr_ses'), 'UserData');
		sessions_preDefined = ext_model_info.preDefined;
		
		found_handles = [];
		if (strcmp('all',search_model)),
		%%% all impostor spks with specified session
		%%
			for i = 1:length(handles_to_search),
				ud = get(handles_to_search(i),'UserData');
					if (isfield(ud,'info') & ~(isempty(ud.info)) & (size(ud.info,1) == 1) ),
						if ~(isempty(strmatch(search_session, ud.info(6:7))))
							found_handles = [found_handles handles_to_search(i)];
						elseif (strcmp(search_session,'all')),
							found_handles = [found_handles handles_to_search(i)];
						elseif ( length(search_session{:}) ~= 2 )
							for list_item = 1:length(sessions_preDefined{search_session_index}.item)
								if ~(isempty(strmatch(sessions_preDefined{ search_session_index }.item(list_item), ud.info(6:7)))),
									found_handles = [found_handles handles_to_search(i)];
								end						
							end	
						end
					end
			end
		 
		else
		%%% one impostor spk
			for i = 1:length(handles_to_search),
				ud = get(handles_to_search(i),'UserData');
				%if (strcmp(get(handles_to_search(i),'Tag'), 'temp')),
				%	keyboard;
				%end
				if (isfield(ud,'info') &  ~(isempty(ud.info)) & (size(ud.info,1) == 1) & ~(isempty(strmatch(search_model, ud.info))) )
					if ~(isempty(strmatch(search_session, ud.info(6:7)))),
						found_handles = [found_handles handles_to_search(i)];
					elseif (strcmp(search_session,'all')),
						found_handles = [found_handles handles_to_search(i)];
					elseif ( length(search_session{:}) ~= 2 )
						for list_item = 1:length(sessions_preDefined{search_session_index}.item)
							if ~(isempty(strmatch(sessions_preDefined{search_session_index}.item(list_item), ud.info(6:7)))),
								found_handles = [found_handles handles_to_search(i)];
							end						
						end	
					end
					
				end
			end
		end
		temp_color = get(found_handles,'Color');
		set(found_handles,'Color',star_color);
		for i = 1: length(found_handles)
			temp_z=get(found_handles(i),'ZData');
			set(found_handles(i),'ZData',temp_z + 1);
		end
		set(findobj(current_figure_handle,'Tag','draw_busy'), 'BackgroundColor', busy_color_free);

	end
	
	return;


	% private
	function show_log_grid(h)
		y_ticks = get(h,'YTick');
		x_ticks = get(h,'XTick');
		
		% y grid lines
		for  i = 1:(length(y_ticks) - 1)
			if (i == 1)
				start_index = 2;
			else
				start_index = 1;
			end 
			for j = start_index:9,
				line([x_ticks(1), x_ticks(end)],[y_ticks(i) * j, y_ticks(i) * j], [-100 -100], 'Color',[0.4 0.4 0.4]);
			end
		end
		
		% x grid lines
		for  i = 1:(length(x_ticks) - 1) 
			if (i == 1)
				start_index = 2;
			else
				start_index = 1;
			end 
			for j = start_index:9,
				line([x_ticks(i) * j, x_ticks(i)*j],[y_ticks(1), y_ticks(end)],[-100 -100],'Color',[0.4 0.4 0.4]);
			end
		end
	
	% private
	function show_npp_grid(h)
		y_ticks = get(h,'YTick');
		x_ticks = get(h,'XTick');
		
		% y grid lines
		for  i = 1:(length(y_ticks) - 1)
			line([x_ticks(1), x_ticks(end)],[y_ticks(i), y_ticks(i)], [-100 -100], 'Color',[0.4 0.4 0.4]);
		end
		
		% x grid lines
		for  i = 1:(length(x_ticks) - 1) 
			line([x_ticks(i), x_ticks(i)],[y_ticks(1), y_ticks(end)],[-100 -100],'Color',[0.4 0.4 0.4]);
		end
	

	
	function string_cell = break_string(s)
				string_cell = {};
				br_index = findstr(s,'<br>');
				sem_index = findstr(s, ';');
				if (~isempty(br_index)),
					string_cell{1} = s(1:br_index(1)-1);
					string_cell{2} = s(br_index(1)+4:end);
				elseif (~isempty(sem_index)),
					string_cell{1} = s(1:sem_index(1)-1);
					string_cell{2} = s(sem_index(1)+1:end);
				elseif (length(s) > 30),
					string_cell{1} = s(1:25);
					string_cell{2} = s(26:end);
				else
					string_cell{1} = s;
					string_cell{2} = '';
				end

				
	function draw_FR_vs_threshold(FR_struct, fr_display_sessions, mycolors, result_index, borders, current_draw_client_index, spk_info_struct, N_combination, draw_rec_indizes, combined_rec_indizes,draw_histogram, av_status)
	
				global current_figure_handle;

				if (isempty(borders)),
					return;
				end
				% extension for better drawing
				borders =[ (borders(1)-0.00001*abs(borders(1))) borders];
				
				borders=sort(borders);
				vector_length_fr=length(borders) - 1;
				probabilities_fr = (1:vector_length_fr) / vector_length_fr * 100;
				probabilities_fr = [0 probabilities_fr];
				if (av_status),
					draw_color = [0.9 0.9 0.9];
				else
					draw_color = mycolors(current_draw_client_index,:);
				end
				if (draw_histogram),
					[x_hist,y_hist] = calc_rel_hist_outline(borders);					
					temp_handle=plot(x_hist,100*y_hist/max(y_hist),'Color',draw_color);
				else
					temp_handle=plot(borders,probabilities_fr,'Color',draw_color+0.3*(1-draw_color));
				end

				temp_length=length(get(temp_handle,'XData'));
				if (av_status),
					z_level = 0;
				else
					z_level = - current_draw_client_index;
				end
				set(temp_handle,'ZData',ones(1,temp_length)*(z_level));
				set(temp_handle,'Tag','DataLine');

				if (av_status)
					draw_client_index = get(findobj(current_figure_handle,'Tag','models'), 'Value');
					draw_client_list = get(findobj(current_figure_handle,'Tag','models'), 'String');
					draw_client_selected_list = draw_client_list(draw_client_index);
					ud.exp_info = get(current_figure_handle,'Name');
					ud.simple_info=['av. over client spks: ' join_strings(draw_client_selected_list,', ') '<br>data: '  join_strings(fr_display_sessions,', ')];
				else
					draw_client = FR_struct{current_draw_client_index}.model_name;
					ud.exp_info = get(current_figure_handle,'Name');
					ud.simple_info=[draw_client ', ' spk_info_struct(str2num(draw_client)).sex ', ' spk_info_struct(str2num(draw_client)).age  ', ' spk_info_struct(str2num(draw_client)).region '<br>data: ' join_strings(fr_display_sessions,', ')];
				end
				set(temp_handle,'UserData',ud);
				set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');

				stars_status = get(findobj(current_figure_handle,'Tag','stars'), 'Value');
				if (stars_status) &  (~(draw_histogram)) & (result_index ~= 0)
					hold on;
					if (N_combination > 1),
						for j=1:size(combined_rec_indizes,2),
							temp_handle=plot(borders(j+1),probabilities_fr(j+1),'*','Color',draw_color+0.3*(1-draw_color));
							set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
							
							ud.rec_index = reshape(combined_rec_indizes(:,j), 1, size(combined_rec_indizes,1));
							ud.info = [];
							if (av_status)
								c_index = current_draw_client_index(j);
							else
								c_index = current_draw_client_index;
							end
							for i=1:length(ud.rec_index),
								ud.info = [ud.info; [ FR_struct{c_index}.data.rec_info(ud.rec_index(i),:) '/' FR_struct{c_index}.data.rec_info(ud.rec_index(i),(1:4))] ]; % append model name
							end
							ud.model_index = c_index;
							ud.type='FR';
							set(temp_handle,'UserData',ud);
							set(temp_handle,'ZData',[z_level]);
						end
					else
						for j=1:length(draw_rec_indizes),

							if (av_status)
								c_index = current_draw_client_index(j);
							else
								c_index = current_draw_client_index;
							end
							temp_handle=plot(borders(j+1), probabilities_fr(j+1),'*','Color', draw_color+0.3*(1-draw_color));
							set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
							
							ud.info = [ FR_struct{c_index}.data.rec_info(draw_rec_indizes(j),:) '/' FR_struct{c_index}.data.rec_info(draw_rec_indizes(j),(1:4))]; % append model name
							
							ud.model_index = c_index;
							ud.rec_index = draw_rec_indizes(j);
							ud.type='FR';
							set(temp_handle,'UserData',ud);
							set(temp_handle,'ZData',[z_level]);
						end
					end
				end
	return;
						
						
	function draw_FA_vs_threshold(FA_struct, fa_display_sessions, mycolors, result_index, borders, current_draw_client_index, spk_info_struct, N_combination, draw_rec_indizes, combined_rec_indizes,draw_histogram, av_model_status, av_imp_status)
				
				global current_figure_handle;

				if (isempty(borders)),
					return;
				end
				% extension for better drawing
				borders =[ (borders(1)-0.00001*abs(borders(1))) borders];

				borders=sort(borders);
				vector_length_fa=length(borders) - 1;
				probabilities_fa = (1:vector_length_fa) / vector_length_fa * 100;
				probabilities_fa = [100 (100 - probabilities_fa)];
				
				if (av_model_status),
					draw_color = [0.9 0.9 0.9];
				else
					draw_color = mycolors(current_draw_client_index,:);
				end
				if (draw_histogram),
					[x_hist,y_hist] = calc_rel_hist_outline(borders);
					temp_handle=plot(x_hist,100*y_hist/max(y_hist),'Color',draw_color);
				else
					temp_handle=plot(borders,probabilities_fa,'Color',draw_color);
				end
				temp_length=length(get(temp_handle,'XData'));
				if (av_model_status),
					z_level = 0;
				else
					z_level = - current_draw_client_index;
				end
				set(temp_handle,'ZData',ones(1,temp_length)*(z_level));
				set(temp_handle,'Tag','DataLine');
				
				imp_spk_index = get(findobj(current_figure_handle,'Tag','imp_spks'), 'Value');
				imp_spk_list_strings = get(findobj(current_figure_handle,'Tag','imp_spks'), 'String');
				imp_spk_selected_lists = imp_spk_list_strings(imp_spk_index);
				imp_spk_selected_lists_display = join_strings(imp_spk_selected_lists,',');
				if (av_model_status)
					draw_client_index = get(findobj(current_figure_handle,'Tag','models'), 'Value');
					draw_client_list = get(findobj(current_figure_handle,'Tag','models'), 'String');
					draw_client_selected_list = draw_client_list(draw_client_index);
					ud.exp_info = get(current_figure_handle,'Name');
					ud.simple_info=['av. over client spks: ' join_strings(draw_client_selected_list,', ') '; imps: ' imp_spk_selected_lists_display '<br>data: '  join_strings(fa_display_sessions,', ')];
				else
					draw_client = FA_struct{current_draw_client_index}.model_name;
					ud.exp_info = get(current_figure_handle,'Name');
					ud.simple_info=[draw_client ', ' spk_info_struct(str2num(draw_client)).sex ', ' spk_info_struct(str2num(draw_client)).age ', ' spk_info_struct(str2num(draw_client)).region '; imps: ' imp_spk_selected_lists_display '<br>data: ' join_strings(fa_display_sessions,', ')];
				end
				set(temp_handle,'UserData',ud);
				set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
				
				stars_status = get(findobj(current_figure_handle,'Tag','stars'), 'Value');
				if (stars_status) &  (~(draw_histogram)) & (result_index ~= 0) & (vector_length_fa < 10000)
					hold on;
					h_current_main_figure = current_figure_handle;
					h_wait = waitbar(0,'Please wait...');
					set(0,'CurrentFigure',[h_current_main_figure]);
					if (N_combination > 1),
						for j=1:size(combined_rec_indizes,2),
							temp_handle=plot(borders(j+1),probabilities_fa(j+1),'*','Color',draw_color);
							set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
							ud.rec_index = reshape(combined_rec_indizes(:,j), 1, size(combined_rec_indizes,1));
							ud.info = [];
							if (av_model_status)
								c_index = current_draw_client_index(j);
							else
								c_index = current_draw_client_index;
							end
							for i=1:length(ud.rec_index),
								ud.info = [ud.info; [ FA_struct{c_index}.data.rec_info(ud.rec_index(i),:) '/' FA_struct{c_index}.model_name;] ]; % append model name
							end
							%ud.info = [ FA_struct{c_index}.data.rec_info(combined_rec_indizes(1,j),:) ; FA_struct{c_index}.data.rec_info(combined_rec_indizes(2,j),:) ];
							
							ud.model_index = c_index;
							%ud.rec_index = [combined_rec_indizes(1,j) combined_rec_indizes(2,j)];
							ud.type = 'FA';
							set(temp_handle,'UserData',ud);
							set(temp_handle,'ZData',[z_level]);
						end
					else
						for j=1:length(draw_rec_indizes),
							if (av_model_status)
								c_index = current_draw_client_index(j);
							else
								c_index = current_draw_client_index;
							end
							temp_handle=plot(borders(j+1), probabilities_fa(j+1),'*','Color',draw_color);
							set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
							
							ud.info = [ FA_struct{c_index}.data.rec_info(draw_rec_indizes(j),:) '/' FA_struct{c_index}.model_name]; % append model name
							
							ud.model_index = c_index;
							ud.rec_index = draw_rec_indizes(j);
							ud.type = 'FA';
							set(temp_handle,'UserData',ud);
							set(temp_handle,'ZData',[z_level]);
						end
					end
					close(h_wait);
	
				end
	
	
	function draw_FR_vs_FA(FR, FA, FR_borders, FA_borders, mycolors, current_draw_client_index, display_mode, draw_client, fr_display_sessions, fa_display_sessions, spk_info_struct, av_flag)
	
				global current_figure_handle;

				if (isempty(FA) | isempty(FR)),
					return;
				end
				if (display_mode==1),
					FA_plot = FA;
					FR_plot = FR;
				elseif (display_mode==2),
					FA_plot = my_norminv(FA/100);
					FR_plot = my_norminv(FR/100);
				else
					FA_plot=FA;
					FR_plot=FR;
				end
				temp_handle=plot(FA_plot,FR_plot,'Color',mycolors(current_draw_client_index,:));
				temp_length=length(get(temp_handle,'XData'));
				set(temp_handle,'ZData',ones(1,temp_length)*(-current_draw_client_index));
				set(temp_handle,'Tag','DataLine');

				if (display_mode==1),
					set(get(temp_handle,'Parent'),'XScale','log');
					set(get(temp_handle,'Parent'),'YScale','log');
					set(get(temp_handle,'Parent'),'YLim',[0.01 100]);
					set(get(temp_handle,'Parent'),'XLim',[0.01 100]);
				elseif (display_mode==2),					
					set(get(temp_handle,'Parent'),'YLim',[my_norminv(0.001) my_norminv(0.99)]);
					set(get(temp_handle,'Parent'),'XLim',[my_norminv(0.001) my_norminv(0.99)]);
					ticks=[0.001, 0.002, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.4, 0.6, 0.8, 0.9, 0.95, 0.98, 0.99 ];
					labels={'0.1', '0.2', '0.5', '1', '2', '5', '10', '20', '40', '60', '80', '90', '95', '98', '99' };
					set(get(temp_handle,'Parent'),'YTick', my_norminv(ticks));
					set(get(temp_handle,'Parent'),'YTickLabel', labels);
					set(get(temp_handle,'Parent'),'XTick', my_norminv(ticks));
					set(get(temp_handle,'Parent'),'XTickLabel', labels);
				end
				
				imp_spk_index = get(findobj(current_figure_handle,'Tag','imp_spks'), 'Value');
				imp_spk_list_strings = get(findobj(current_figure_handle,'Tag','imp_spks'), 'String');
				imp_spk_selected_lists = imp_spk_list_strings(imp_spk_index);
				imp_spk_selected_lists_display = join_strings(imp_spk_selected_lists,',');
				if (av_flag),
					draw_client_index = get(findobj(current_figure_handle,'Tag','models'), 'Value');
					draw_client_list = get(findobj(current_figure_handle,'Tag','models'), 'String');
					draw_client_selected_list = draw_client_list(draw_client_index);
					ud.exp_info = get(current_figure_handle,'Name');
					ud.simple_info=[ 'overall average; spks: ' join_strings(draw_client_selected_list,', ') '; imps: ' imp_spk_selected_lists_display '<br>client spk data: ' join_strings(fr_display_sessions,', ') '; imp spk data: ' join_strings(fa_display_sessions,', ')];
				else
					ud.exp_info = get(current_figure_handle,'Name');
					ud.simple_info=[draw_client ', ' spk_info_struct(str2num(draw_client)).sex ', ' spk_info_struct(str2num(draw_client)).age ', ' spk_info_struct(str2num(draw_client)).region '; imps: ' imp_spk_selected_lists_display '<br>client spk data: ' join_strings(fr_display_sessions,', ') '; imp spk data: ' join_strings(fa_display_sessions,', ')];
				end
				set(temp_handle,'UserData',ud);
				set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
				if (display_mode==1),
					show_log_grid(get(temp_handle,'Parent'));
				elseif (display_mode==2),
					show_npp_grid(get(temp_handle,'Parent'));
				end
								
				
				stars_status = get(findobj(current_figure_handle,'Tag','stars'), 'Value');
				if (stars_status)

					if (av_flag),
						eer_star_prefix = 'Overall average';
					else
						eer_star_prefix = draw_client;
					end
					[eer, eer_coarse, threshold, threshold_coarse] = calc_EER(FR_borders, FA_borders);
					hold on;
					if (display_mode==1),
						eer_plot = eer;
					elseif (display_mode==2),
						eer_plot = my_norminv(eer/100);
					else
						eer_plot=eer;
					end
					
					temp_handle=plot(eer_plot,eer_plot,'x','Color',mycolors(current_draw_client_index,:));
					set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
					ud.exp_info = get(current_figure_handle,'Name');
					ud.simple_info = [ eer_star_prefix '; EER: ' num2str(eer) ' %; thresh.: ' num2str(threshold)];
					set(temp_handle,'UserData',ud);
					temp_length=length(get(temp_handle,'XData'));
					set(temp_handle,'ZData',ones(1,temp_length)*(-current_draw_client_index));
	
					hold_status = get(findobj(current_figure_handle,'Tag','hold'), 'Value');
					if (hold_status)
					else
						hold off;
					end
					
				end

	function draw_SR_FR_vs_FA(FR, FA, eer, threshold, mycolors,current_draw_client_index, display_mode, info, imp_spks_list, stat_sig_struct, part_type, bound_mode)
				%colors
				global current_figure_handle;
				
				sig_bounds_bickel_color = [0.2 0.2 0.9];
				sig_bounds_bs_color = [0.7 0.2 0.7];
				sig_bounds_bin_approx_color = [0.2 0.8 0.8];
				sig_bounds_bin_exact_color = [0.8 0.8 0.2];
				borders_color = [0.2 0.8 0.2];
				
				found_handle = findobj(current_figure_handle,'Tag','more');
				if (~isempty(found_handle)),
					more_state = get(found_handle,'Value');
				else
					more_state = 0;
				end

				ud.exp_info = get(current_figure_handle,'Name');
				
				if (display_mode==1),
					FA_plot = FA;
					FR_plot = FR;
				elseif (display_mode==2),
					FA_plot = my_norminv(double(FA)/100);
					FR_plot = my_norminv(double(FR)/100);
				else
					FA_plot=FA;
					FR_plot=FR;
				end
	
				temp_handle=plot(FA_plot,FR_plot,'Color',mycolors(current_draw_client_index,:));
				temp_length=length(get(temp_handle,'XData'));
				set(temp_handle,'ZData',ones(1,temp_length)*(-current_draw_client_index));
				set(temp_handle,'Tag','DataLine');

				if (display_mode==1),
					set(get(temp_handle,'Parent'),'XScale','log');
					set(get(temp_handle,'Parent'),'YScale','log');
					set(get(temp_handle,'Parent'),'YLim',[0.01 100]);
					set(get(temp_handle,'Parent'),'XLim',[0.01 100]);
				elseif (display_mode==2),					
					set(get(temp_handle,'Parent'),'YLim',[my_norminv(0.001) my_norminv(0.99)]);
					set(get(temp_handle,'Parent'),'XLim',[my_norminv(0.001) my_norminv(0.99)]);
					ticks=[0.001, 0.002, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.4, 0.6, 0.8, 0.9, 0.95, 0.98, 0.99 ];
					labels={'0.1', '0.2', '0.5', '1', '2', '5', '10', '20', '40', '60', '80', '90', '95', '98', '99' };
					set(get(temp_handle,'Parent'),'YTick', my_norminv(ticks));
					set(get(temp_handle,'Parent'),'YTickLabel', labels);
					set(get(temp_handle,'Parent'),'XTick', my_norminv(ticks));
					set(get(temp_handle,'Parent'),'XTickLabel', labels);
				else
					set(get(temp_handle,'Parent'),'YLim',[0 100]);
					set(get(temp_handle,'Parent'),'XLim',[0 100]);
				end
				
				if (strcmp(part_type, 'det_bs')),
					ud.simple_info=[ 'median from bootstrap samples; ' info '<br>imp speakers: ' join_strings(imp_spks_list,', ')];
				elseif (strcmp(part_type, 'det')),
					ud.simple_info=[ 'overall average; ' info '<br>imp speakers: ' join_strings(imp_spks_list,', ')];
				end % elseif strcmp(part_type, 'det')

				set(temp_handle,'UserData',ud);

				set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
					
				if (display_mode==1),
					show_log_grid(get(temp_handle,'Parent'));
				elseif (display_mode==2),
					show_npp_grid(get(temp_handle,'Parent'));
				end
				
				y_ticks = get(get(temp_handle,'Parent'),'YTick');
				x_ticks = get(get(temp_handle,'Parent'),'XTick');
				
				if (isfield(stat_sig_struct,'client_low_p_bound_exact')),
					p = stat_sig_struct.client_low_p_bound_exact;
					p_plot = p;
					if (display_mode==2),
						p_plot = my_norminv(p/100);
					end
					h_line = line([x_ticks(1) x_ticks(end)], [p_plot p_plot], 'Color', borders_color, 'Tag', 'more_info2');
					ud.simple_info=[ 'client: lower fr bound (exact): p_{low} = ' num2str(p) '%' '<br>' info '<br>imp speakers: ' join_strings(imp_spks_list,', ')];
					set(h_line,'UserData',ud);
					if (~more_state),
						set(h_line,'Visible', 'off');
					end
					set(h_line,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
				end
				
				if (isfield(stat_sig_struct,'imp_low_p_bound_exact')),
					p = stat_sig_struct.imp_low_p_bound_exact;
					p_plot = p;
					if (display_mode==2),
						p_plot = my_norminv(p/100);
					end
					h_line = line([p_plot p_plot], [y_ticks(1) y_ticks(end)], 'Color', borders_color, 'Tag', 'more_info2');
					ud.simple_info=[ 'imp: lower fa bound (exact): p_{low} = ' num2str(p) '%' '<br>' info '<br>imp speakers: ' join_strings(imp_spks_list,', ')];
					set(h_line,'UserData',ud);
					if (~more_state),
						set(h_line,'Visible', 'off');
					end
					set(h_line,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
				end
				
				if (isfield(stat_sig_struct,'imp_low_p_bound_exact_strict')),
					p = stat_sig_struct.imp_low_p_bound_exact_strict;
					p_plot = p;
					if (display_mode==2),
						p_plot = my_norminv(p/100);
					end
					h_line = line([p_plot p_plot], [y_ticks(1) y_ticks(end)], 'Color', borders_color, 'Tag', 'more_info2');
					ud.simple_info=[ 'imp: lower fa bound (strict, one test per impostor): <br>p_{low} = ' num2str(p)];
					set(h_line,'UserData',ud);
					if (~more_state),
						set(h_line,'Visible', 'off');
					end
					set(h_line,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
				end
				
				if (isfield(stat_sig_struct,'fr_sig_bounds_from_av_of_att')),
					fr_lower = stat_sig_struct.fr_sig_bounds_from_av_of_att(1,:);
					fr_upper = stat_sig_struct.fr_sig_bounds_from_av_of_att(2,:);
					fa_lower = stat_sig_struct.fa_sig_bounds_from_av_of_att(1,:);
					fa_upper = stat_sig_struct.fa_sig_bounds_from_av_of_att(2,:);
					if (strcmp(part_type, 'det_bs')),
						FA_sub = stat_sig_struct.fa_av_of_att; % based on median!!
						FR_sub = stat_sig_struct.fr_av_of_att;
					elseif (strcmp(part_type, 'det')),
						FA_sub = stat_sig_struct.fa_av_of_att;
						FR_sub = stat_sig_struct.fr_av_of_att;
					end
					
					
					if (strcmp(bound_mode, 'all')),
						% do nothing
					elseif (strcmp(bound_mode, 'FR')),
						fa_lower = FA_sub;
						fa_upper = FA_sub;
					elseif (strcmp(bound_mode, 'FA')),
						fr_lower = FR_sub;
						fr_upper = FR_sub;						
					end
					if (display_mode==1),
						lower_l_fr_plot = fr_lower;
						lower_l_fa_plot = fa_lower;
						upper_l_fr_plot = fr_upper;
						upper_l_fa_plot = fa_upper;
					elseif (display_mode==2),
						lower_l_fr_plot = my_norminv(fr_lower / 100);
						lower_l_fa_plot = my_norminv(fa_lower / 100);
						upper_l_fr_plot = my_norminv(fr_upper / 100);
						upper_l_fa_plot = my_norminv(fa_upper / 100);
					else
						lower_l_fr_plot = fr_lower;
						lower_l_fa_plot = fa_lower;
						upper_l_fr_plot = fr_upper;
						upper_l_fa_plot = fa_upper;
					end
					if (strcmp(part_type, 'det_bs')),
						the_color = sig_bounds_bs_color;
					elseif (strcmp(part_type, 'det')),
						the_color = sig_bounds_bickel_color;
					end
					h_line = plot(lower_l_fa_plot, lower_l_fr_plot, 'Color', the_color, 'Tag', 'more_info1');
					if (strcmp(part_type, 'det_bs')),
						ud.simple_info=[ 'lower bootstrap bound; ' info ];
					elseif (strcmp(part_type, 'det')),
						ud.simple_info=[ 'lower det bound' ];
					end % elseif strcmp(part_type, 'det')
					set(h_line,'UserData',ud);
					if (~more_state),
						set(h_line,'Visible', 'off');
					end
					set(h_line,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
					 
					h_line = plot(upper_l_fa_plot, upper_l_fr_plot, 'Color', the_color, 'Tag', 'more_info1');
					if (strcmp(part_type, 'det_bs')),
						ud.simple_info=[ 'upper bootstrap bound; ' info ];
					elseif (strcmp(part_type, 'det')),
						ud.simple_info=[ 'upper det bound' ];
					end % elseif strcmp(part_type, 'det')
					set(h_line,'UserData',ud);
					if (~more_state),
						set(h_line,'Visible', 'off');
					end
					set(h_line,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');

				end
				
				if (isfield(stat_sig_struct,'fr_av_of_att')),
				
					if (strcmp(part_type, 'det_bs')),
						% do nothing
					elseif (strcmp(part_type, 'det')),
						% draw approx. binomial borders ( valid for p <= 0.1 )
						alpha = 0.05; %error prob.
						z_scale = abs(norminv(alpha/2));
						fr_hits_vs_th = stat_sig_struct.fr_av_of_att ./ 100 .* stat_sig_struct.fr_N_tests;
						fr_base_prob = stat_sig_struct.fr_av_of_att;
						fr_hits_vs_th ( fr_hits_vs_th == 0 ) = 0.1;
						prop_factor = z_scale ./ sqrt(fr_hits_vs_th);
						fr_sig_bounds_binomial = [ (fr_base_prob.*(1-prop_factor)); (fr_base_prob.*(1+prop_factor))];
						fr_sig_bounds_binomial ( fr_sig_bounds_binomial < 0 ) = 0;
						fr_sig_bounds_binomial ( fr_sig_bounds_binomial > 100 ) = 100;
	
						fa_hits_vs_th = stat_sig_struct.fa_av_of_att ./ 100 .* stat_sig_struct.fa_N_tests;
						fa_base_prob = stat_sig_struct.fa_av_of_att;
						fa_hits_vs_th ( fa_hits_vs_th == 0 ) = 0.1;
						prop_factor = z_scale ./ sqrt(fa_hits_vs_th);
						fa_sig_bounds_binomial = [ (fa_base_prob.*(1-prop_factor)); (fa_base_prob.*(1+prop_factor))];
						fa_sig_bounds_binomial ( fa_sig_bounds_binomial < 0 ) = 0;
						fa_sig_bounds_binomial ( fa_sig_bounds_binomial > 100 ) = 100;
	
						fr_lower = fr_sig_bounds_binomial(1,:);
						fr_upper = fr_sig_bounds_binomial(2,:);
						fa_lower = fa_sig_bounds_binomial(1,:);
						fa_upper = fa_sig_bounds_binomial(2,:);
						if (strcmp(part_type, 'det_bs')),
							FA_sub = stat_sig_struct.fa_av_of_att; % based on median!!
							FR_sub = stat_sig_struct.fr_av_of_att;
						elseif (strcmp(part_type, 'det')),
							FA_sub = stat_sig_struct.fa_av_of_att;
							FR_sub = stat_sig_struct.fr_av_of_att;
						end
						
						
						if (strcmp(bound_mode, 'all')),
							% do nothing
						elseif (strcmp(bound_mode, 'FR')),
							fa_lower = FA_sub;
							fa_upper = FA_sub;
						elseif (strcmp(bound_mode, 'FA')),
							fr_lower = FR_sub;
							fr_upper = FR_sub;						
						end
						
						if (display_mode==1),
							lower_l_fr_plot = fr_lower;
							lower_l_fa_plot = fa_lower;
							upper_l_fr_plot = fr_upper;
							upper_l_fa_plot = fa_upper;
						elseif (display_mode==2),
							lower_l_fr_plot = my_norminv(fr_lower / 100);
							lower_l_fa_plot = my_norminv(fa_lower / 100);
							upper_l_fr_plot = my_norminv(fr_upper / 100);
							upper_l_fa_plot = my_norminv(fa_upper / 100);
						else
							lower_l_fr_plot = fr_lower;
							lower_l_fa_plot = fa_lower;
							upper_l_fr_plot = fr_upper;
							upper_l_fa_plot = fa_upper;
						end
	
						h_line = plot(lower_l_fa_plot, lower_l_fr_plot, 'Color', sig_bounds_bin_approx_color, 'Tag', 'more_info2');
						ud.simple_info=[ 'lower det bound binomial approx.' ];
						set(h_line,'UserData',ud);
						if (~more_state),
							set(h_line,'Visible', 'off');
						end
						set(h_line,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
						 
						h_line = plot(upper_l_fa_plot, upper_l_fr_plot, 'Color', sig_bounds_bin_approx_color, 'Tag', 'more_info2');
						ud.simple_info=[ 'upper det bound binomial approx.' ];
						set(h_line,'UserData',ud);
						if (~more_state),
							set(h_line,'Visible', 'off');
						end
						set(h_line,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
						
						
						
						
						% exact binomial conf. interval
						fr_base_prob = stat_sig_struct.fr_av_of_att;
						epsilon = z_scale .* sqrt( fr_base_prob .* (100 - fr_base_prob) ./ stat_sig_struct.fr_N_tests);
						fr_sig_bounds_binomial = [ (fr_base_prob - epsilon); (fr_base_prob + epsilon)];
						fr_sig_bounds_binomial ( fr_sig_bounds_binomial < 0 ) = 0;
						fr_sig_bounds_binomial ( fr_sig_bounds_binomial > 100 ) = 100;
	
						fa_base_prob = stat_sig_struct.fa_av_of_att;
						epsilon = z_scale .* sqrt( fa_base_prob .* (100 - fa_base_prob) ./ stat_sig_struct.fa_N_tests);
						fa_sig_bounds_binomial = [ (fa_base_prob - epsilon); (fa_base_prob + epsilon)];
						fa_sig_bounds_binomial ( fa_sig_bounds_binomial < 0 ) = 0;
						fa_sig_bounds_binomial ( fa_sig_bounds_binomial > 100 ) = 100;
	
						fr_lower = fr_sig_bounds_binomial(1,:);
						fr_upper = fr_sig_bounds_binomial(2,:);
						fa_lower = fa_sig_bounds_binomial(1,:);
						fa_upper = fa_sig_bounds_binomial(2,:);
						if (strcmp(part_type, 'det_bs')),
							FA_sub = stat_sig_struct.fa_av_of_att; % based on median!!
							FR_sub = stat_sig_struct.fr_av_of_att;
						elseif (strcmp(part_type, 'det')),
							FA_sub = stat_sig_struct.fa_av_of_att;
							FR_sub = stat_sig_struct.fr_av_of_att;
						end
						
						
						if (strcmp(bound_mode, 'all')),
							% do nothing
						elseif (strcmp(bound_mode, 'FR')),
							fa_lower = FA_sub;
							fa_upper = FA_sub;
						elseif (strcmp(bound_mode, 'FA')),
							fr_lower = FR_sub;
							fr_upper = FR_sub;						
						end
						
						if (display_mode==1),
							lower_l_fr_plot = fr_lower;
							lower_l_fa_plot = fa_lower;
							upper_l_fr_plot = fr_upper;
							upper_l_fa_plot = fa_upper;
						elseif (display_mode==2),
							lower_l_fr_plot = my_norminv(fr_lower / 100);
							lower_l_fa_plot = my_norminv(fa_lower / 100);
							upper_l_fr_plot = my_norminv(fr_upper / 100);
							upper_l_fa_plot = my_norminv(fa_upper / 100);
						else
							lower_l_fr_plot = fr_lower;
							lower_l_fa_plot = fa_lower;
							upper_l_fr_plot = fr_upper;
							upper_l_fa_plot = fa_upper;
						end
	
						h_line = plot(lower_l_fa_plot, lower_l_fr_plot, 'Color', sig_bounds_bin_exact_color, 'Tag', 'more_info2');
						ud.simple_info=[ 'lower det bound binomial exact' ];
						set(h_line,'UserData',ud);
						if (~more_state),
							set(h_line,'Visible', 'off');
						end
						set(h_line,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
						 
						h_line = plot(upper_l_fa_plot, upper_l_fr_plot, 'Color', sig_bounds_bin_exact_color, 'Tag', 'more_info2');
						ud.simple_info=[ 'upper det bound binomial exact' ];
						set(h_line,'UserData',ud);
						if (~more_state),
							set(h_line,'Visible', 'off');
						end
						set(h_line,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
					end % elseif strcmp(part_type, 'det')
					
				end
				
                stars_status = get(findobj(current_figure_handle,'Tag','stars'), 'Value');
				if (stars_status)


					if (strcmp(part_type, 'det_bs')),
						% do nothing 
					elseif (strcmp(part_type, 'det')),
						hold on;
						
						if (display_mode==1),
							eer_plot = eer;
						elseif (display_mode==2),
							eer_plot = my_norminv(eer/100);
						else
							eer_plot=eer;
						end
	
						temp_handle=plot(eer_plot,eer_plot,'x','Color',mycolors(current_draw_client_index,:));
						set(temp_handle,'ButtonDownFcn','Plot_SR_parameters_Callback(''star_click'')');
						ud.simple_info = ['From DET-curve; EER: ' num2str(eer) ' %; thresh.: ' num2str(threshold)  '<br>' info '<br>imp speakers: ' join_strings(imp_spks_list,', ')];
						set(temp_handle,'UserData',ud);
						temp_length=length(get(temp_handle,'XData'));
						set(temp_handle,'ZData',ones(1,temp_length)*(-current_draw_client_index));
		
						hold_status = get(findobj(current_figure_handle,'Tag','hold'), 'Value');
						if (hold_status)
						else
							hold off;
						end
					end % elseif strcmp(part_type, 'det')
					
				end
				
					
	
	function [imp_spk_names, imp_index_array, several_imp_flag] = local_get_imp_spks_list(result_index, current_speaker, current_speaker_index)
	
				global Results;
				global current_figure_handle;
				
				imp_spk_index = get(findobj(current_figure_handle,'Tag','imp_spks'), 'Value');
				imp_spk_list_strings = get(findobj(gcbf,'Tag','imp_spks'), 'String');
				imp_spk_selected_lists = imp_spk_list_strings(imp_spk_index);
				
				% filter gender info from spk names
				s_indizes = strmatch('0',imp_spk_selected_lists);
				for i=1:length(s_indizes),
					temp=imp_spk_selected_lists{s_indizes(i)};
					imp_spk_selected_lists{s_indizes(i)} = temp(1:4);
				end
				
				[imp_spk_names, imp_index_array] = get_imp_speakers(imp_spk_selected_lists, {current_speaker}, Results{result_index}.model_info, Results{result_index}.FA_struct{current_speaker_index}.imp_test_spks);
				
				if (length(imp_spk_names) > 1),
					several_imp_flag = 1;
				else
					several_imp_flag = 0;
				end

	return;
	
	
	function [borders_vector, combined_rec_indizes] = get_combined_data(FR_struct, current_draw_client_index, draw_client, fr_display_sessions, N_combination, ext_model_info)
	
		if (~strcmp(ext_model_info.score_type, 'per frame'))
			error('combination of items with score type being not ''per frame'' not implemented yet!');
		end
		combined_rec_indizes = find_combined_rec_indizes(FR_struct{current_draw_client_index}, {draw_client}, fr_display_sessions, N_combination, ext_model_info);
		if (~isempty(FR_struct{current_draw_client_index}.data.duration)),
			duration(1,:) = double(FR_struct{current_draw_client_index}.data.duration(combined_rec_indizes(1,:)));
			borders_vector = FR_struct{current_draw_client_index}.data.borders(combined_rec_indizes(1,:)) .* duration(1,:);
			
			for comb_index = 2:size(combined_rec_indizes, 1),
				duration(comb_index,:) = double(FR_struct{current_draw_client_index}.data.duration(combined_rec_indizes(comb_index,:)));

				borders_vector = borders_vector + FR_struct{current_draw_client_index}.data.borders(combined_rec_indizes(comb_index,:)) .* duration(comb_index,:);
			end
			duration_combined = sum(duration);
			
			borders_vector = (1./duration_combined) .* borders_vector;
		else
			combined_rec_indizes = combined_rec_indizes(1,:);
			borders_vector = FR_struct{current_draw_client_index}.data.borders(combined_rec_indizes);
		end
	return;


	
	function [borders, combined_rec_indizes] = get_combined_data_FA(FA_struct, ...
	                                            current_draw_client_index, ...
												imp_spk_names, ...
												fa_display_sessions, ...
												N_combination, ...
												ext_model_info)
		if (~strcmp(ext_model_info.score_type, 'per frame'))
			error('combination of items with score type being not ''per frame'' not implemented yet!');
		end
		
		combined_rec_indizes = find_combined_rec_indizes(FA_struct{current_draw_client_index}, imp_spk_names, fa_display_sessions, N_combination, ext_model_info);
		if (~isempty(FA_struct{current_draw_client_index}.data.duration)),
			duration(1,:) = double(FA_struct{current_draw_client_index}.data.duration(combined_rec_indizes(1,:)));
			borders_vector = FA_struct{current_draw_client_index}.data.borders(combined_rec_indizes(1,:)) .* duration(1,:);
			for comb_index = 2:size(combined_rec_indizes, 1),
				duration(comb_index,:) = double(FA_struct{current_draw_client_index}.data.duration(combined_rec_indizes(comb_index,:)));

				borders_vector = borders_vector + FA_struct{current_draw_client_index}.data.borders(combined_rec_indizes(comb_index,:)) .* duration(comb_index,:);
			end
			duration_combined = sum(duration);
			
			borders_vector = (1./duration_combined) .* borders_vector;
		else
			combined_rec_indizes = combined_rec_indizes(1,:);
			borders_vector = FA_struct{current_draw_client_index}.data.borders(combined_rec_indizes);
		end
		
	return;
		
