function figure_handle = Plot_SR_parameters_init(result_index, score_result_index, score_struct_index, result_type, init_type)
% function figure_handle = Plot_SR_parameters_init(result_index, 
%                          score_result_index, score_struct_index, 
%                          result_type, init_type)
%
% CVS_Version_String = '$Id: Plot_SR_parameters_init.m,v 1.40 2004/06/01 13:06:17 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



if ((result_index == 0) & (score_result_index == 0) & (score_struct_index ==0)),
	figure_handle = 0;
	return;
end

global Results;
global Score_Results;
global Score_Structs;

SR_lib;

spk_info_struct = read_spk_info;

draw_functions_score_result = {'(SR) FR vs FA';'(SR) FR vs FA (double log)';'(SR) FR vs FA (npp)';'(SR) FR vs FA (npp), FA b.';'(SR) FR vs FA (npp), FR b.';'(SR) EER vs model'; 'FR vs model'; 'FA vs model' ; 'FA vs imp. spk'; 'FA client/imp matrix';'Rel. unreliability';'Rel. vulnerability';'Rel. imitation ability'};
draw_functions_score_struct = {'single scores'};
draw_functions_result = {'FA vs threshold';'FR vs threshold';'FR vs FA';'FR vs FA (double log)';'FR vs FA (npp)';'EER vs model'};

if (strcmp(result_type,'result') | strcmp(result_type,'combined')),
	if (isfield(Results{result_index},'worlddata'))
		draw_functions_result = { draw_functions_result{:} 'World scores'};
	end
end

if (strcmp(result_type,'result')),
	draw_functions={draw_functions_result{:}};
	fr_fa_variantes={''};
elseif (strcmp(result_type,'score_result')),
	draw_functions={draw_functions_score_result{:} };
	
	for i = 1:length(Score_Results{score_result_index}.part),
		fr_fa_variantes{i} = ['(' num2str(i) ') ' Score_Results{score_result_index}.part{i}.menu_descr];
	end
elseif (strcmp(result_type,'combined')),
	% combined
	draw_functions={draw_functions_result{:} draw_functions_score_result{:} };
	for i = 1:length(Score_Results{score_result_index}.part),
		fr_fa_variantes{i} = ['(' num2str(i) ') '  Score_Results{score_result_index}.part{i}.menu_descr];
	end
elseif (strcmp(result_type,'score_struct')),
	% score struct
	draw_functions=draw_functions_score_struct;
	fr_fa_variantes={''};
end



model_display{1} = 'all';
model_display{2} = 'all male';
model_display{3} = 'all female';

if (strcmp(result_type,'result') | strcmp(result_type,'combined')),
	[trained_male_indizes, trained_female_indizes]	= get_gender_indizes(Results{result_index}.model_info.trained_models, Results{result_index}.model_info);
	for i = 1:length(Results{result_index}.FR_struct),
		if ((~isempty(trained_male_indizes)) & (~isempty(find(trained_male_indizes==i))))
			sex = '(M)';
		else
			sex = '(F)';
		end
		model_display{length(model_display)+1} = [Results{result_index}.FR_struct{i}.model_name  sex];
	end
	result_name=Results{result_index}.result_name;
	exp_name=Results{result_index}.exp_name;

	s_model_display{1} = 'all';
	s_model_display{2} = 'all male';
	s_model_display{3} = 'all female';
	[imp_male_indizes, imp_female_indizes]	= get_gender_indizes(Results{result_index}.model_info.imp_test_spks, Results{result_index}.model_info);
	for i = 1:length(Results{result_index}.model_info.imp_test_spks),
		if ((~isempty(imp_male_indizes)) & (~isempty(find(imp_male_indizes==i))))
			sex = '(M)';
		else
			sex = '(F)';
		end
		s_model_display{length(s_model_display)+1} = [Results{result_index}.model_info.imp_test_spks{i}  sex];
	end
	
	imp_display{1} = 'all';
	imp_display{2} = 'all male';
	imp_display{3} = 'all female';
	imp_display{4} = 'same gender';
	imp_display{5} = 'cross-gender';
	[imp_male_indizes, imp_female_indizes]	= get_gender_indizes(Results{result_index}.model_info.imp_test_spks, Results{result_index}.model_info);
	for i = 1:length(Results{result_index}.model_info.imp_test_spks),
		if ((~isempty(imp_male_indizes)) & (~isempty(find(imp_male_indizes==i))))
			sex = '(M)';
		else
			sex = '(F)';
		end
		imp_display{length(imp_display)+1} = [Results{result_index}.model_info.imp_test_spks{i}  sex];
	end


	sessions_info = Results{result_index}.model_info;

elseif (strcmp(result_type,'score_result')),

	result_name=Score_Results{score_result_index}.result_name;
	exp_name=Score_Results{score_result_index}.exp_name;

	if (isfield(Score_Results{score_result_index}, 'model_info')),
	
		[trained_male_indizes, trained_female_indizes]	= get_gender_indizes(Score_Results{score_result_index}.model_info.trained_models, Score_Results{score_result_index}.model_info);
		for i = 1:Score_Results{score_result_index}.part{1}.num_of_models,
			if ( (~isempty(trained_male_indizes)) & (~isempty(find(trained_male_indizes==i))))
				sex = '(M)';
			else
				sex = '(F)';
			end
			model_display{length(model_display)+1} = [Score_Results{score_result_index}.part{1}.model(i).model_name  sex];
		end	
	
		s_model_display{1} = 'all';
		s_model_display{2} = 'all male';
		s_model_display{3} = 'all female';
		[imp_male_indizes, imp_female_indizes]	= get_gender_indizes(Score_Results{score_result_index}.model_info.imp_test_spks, Score_Results{score_result_index}.model_info);
		for i = 1:length(Score_Results{score_result_index}.model_info.imp_test_spks),
			if ( (~isempty(imp_male_indizes)) & (~isempty(find(imp_male_indizes==i))))
				sex = '(M)';
			else
				sex = '(F)';
			end
			s_model_display{length(s_model_display)+1} = [Score_Results{score_result_index}.model_info.imp_test_spks{i}  sex];
		end	
	
		imp_display{1} = 'all';
		imp_display{2} = 'all male';
		imp_display{3} = 'all female';
		imp_display{4} = 'same gender';
		imp_display{5} = 'cross-gender';
		[imp_male_indizes, imp_female_indizes]	= get_gender_indizes(Score_Results{score_result_index}.model_info.imp_test_spks, Score_Results{score_result_index}.model_info);
		for i = 1:length(Score_Results{score_result_index}.model_info.imp_test_spks),
			if ( (~isempty(imp_male_indizes)) & (~isempty(find(imp_male_indizes==i))))
				sex = '(M)';
			else
				sex = '(F)';
			end
			imp_display{length(imp_display)+1} = [Score_Results{score_result_index}.model_info.imp_test_spks{i}  sex];
		end	
		
		sessions_info = Score_Results{score_result_index}.model_info;
	else
		model_display = {'all'};
		s_model_display = {'all'};
		imp_display = {'all'};
		sessions_info = [];
	end
	
elseif (strcmp(result_type,'score_struct')),
	model_display = {''};
	result_name=Score_Structs{score_struct_index}.result_name;
	exp_name=Score_Structs{score_struct_index}.exp_name;

	s_model_display = {''};
	imp_display = s_model_display;

	sessions_info = {};

end


s_sessions_preDefined = {};
for i = 1:length(sessions_lists),
	s_sessions_preDefined  = [s_sessions_preDefined {sessions_lists{i}.set_name}];
end
s_session_display = [s_sessions_preDefined {'all'}];
all_sessions_lists = [get_set(sessions_lists,'all')];
s_session_display = [s_session_display all_sessions_lists];


if (strcmp(init_type,'new window')),
	figure_handle=init_screen;
end

temp_handle = findobj(gcf,'Tag','functions');
set(temp_handle, 'String',draw_functions);
if (strcmp(init_type,'new window')),
	set(temp_handle, 'Value',1);
end

temp_handle = findobj(gcf,'Tag','Info_Button');
set(temp_handle, 'UserData',spk_info_struct);

temp_handle = findobj(gcf,'Tag','fr_fa_var');
set(temp_handle, 'String',fr_fa_variantes);
if ( (get(temp_handle, 'Value') > length(fr_fa_variantes) ) | (strcmp(init_type,'new window')) ),
	set(temp_handle, 'Value', 1);
end

temp_handle = findobj(gcf,'Tag','models');
set(temp_handle, 'String',model_display);


temp_handle = findobj(gcf,'Tag','imp_spks');
set(temp_handle, 'String',imp_display);

temp_handle = findobj(gcf,'Tag','s_models');
set(temp_handle, 'String',s_model_display);

temp_handle = findobj(gcf,'Tag','s_sessions');
set(temp_handle, 'String',s_session_display);

set(gcf, 'UserData', [result_index score_result_index, score_struct_index]);


if (strcmp(result_type,'score_result')),
	rm_handle=findobj(gcf,'Tag','Play_Button');
	set(rm_handle,'Visible','off');
	rm_handle=findobj(gcf,'Tag','label1');
	set(rm_handle,'Visible','off');
	rm_handle=findobj(gcf,'Tag','label2');
	set(rm_handle,'Visible','off');
end



set(findobj(gcf,'Tag','Load_Button'),'UserData',[exp_name '-' result_name]);

Plot_SR_parameters_Callback('update');
Plot_SR_parameters_Callback('update fr_fa_session list');
Plot_SR_parameters_Callback('change_fr_fa_var');
Plot_SR_parameters_Callback('change_info_var');

return;





function figure_handle=init_screen

	if (strcmp(computer,'MAC'))
		pos = [30 200 680 535];
	else
		pos = [15    65   800   646];
	end
	
	logo_data = imread( 'Logo.png', 'png');
	x_logo = size(logo_data,2);
	y_logo = size(logo_data,1);
	
	figure_handle = figure('Color',[0.1 0.1 0.1], ...
		'Position',pos, ...
		'Tag','mainFigure');
	axes_handle = axes('Parent',figure_handle, ...
		'Box','on', ...
		'CameraUpVector',[0 1 0], ...
		'Color',[0 0 0], ...
		'FontSize',9, ...
		'Position',[0.10 0.21 0.58 0.71], ...
		'Tag','Axes1');
		
	axes_logo_handle = axes('Parent',figure_handle, ...
		'Box','off', ...
		'Visible', 'off', ...
		'DataAspectRatio', [ 1 1 1 ], ...
		'Units', 'pixels', ...
		'CameraUpVector',[0 1 0], ...
		'Color',[0 0 0], ...
		'Position',[ 10 592 x_logo y_logo], ...
		'Tag','Axes_Logo');
	image( logo_data(:,:,1:3), 'Parent', axes_logo_handle );
	set( axes_logo_handle, 'Visible', 'off');
	
	results_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Enable','on', ...
		'Position',[60 490 330 20], ...
		'String','', ...
		'Style','popupmenu', ...
		'Callback','[ri, sri, ssi, rt]=Plot_SR_parameters_Callback(''update'');Plot_SR_parameters_init(ri, sri,ssi, rt, '''');',...
		'Tag','results');
	load_button_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[400 490 40 20], ...
		'String','load', ...
		'Tag','Load_Button', ...
		'Callback','[ri, sri, ssi, rt]=Plot_SR_parameters_Callback(''load'');Plot_SR_parameters_init(ri, sri, ssi, rt, '''');');
	function_list_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'BackgroundColor',[1 1 1], ...
		'Position',[461 427 146 83], ...
		'String','', ...
		'Style','listbox', ...
		'Tag','functions', ...
		'Callback','Plot_SR_parameters_Callback(''change_fr_fa_var'');');
	overall_av_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[461 411 146 15], ...
		'Style','checkbox', ...
		'Visible','off', ...
		'String','overall average', ...
		'Tag','overall_av');
	info_button_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[610 490 20 20], ...
		'String','i', ...
		'FontWeight', 'bold', ...
		'Tag','Info_Button', ...
		'UserData','', ...
		'Callback','Plot_SR_parameters_Callback(''info'')');
	busy_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[610 460 15 15], ...
		'Tag','draw_busy', ...
		'BackgroundColor',[0 1 0]);
	fr_fa_variante_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Enable','off', ...
		'Position',[461 390 146 20], ...
		'String','', ...
		'FontSize',8,...
		'Style','popupmenu', ...
		'Callback','Plot_SR_parameters_Callback(''change_info_var'');',...
		'Tag','fr_fa_var');
	info_variante_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'BackgroundColor',[0.945 0.95 0.945], ...
		'Position',[461 369 146 20], ...
		'Style','text', ...
		'FontSize',8,...
		'String','', ...
		'Tag','info_variante', ...
		'HorizontalAlignment','left');
	model_list_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'BackgroundColor',[0.95 1 0.95], ...
		'Position',[461 305 80 60], ...
		'Max',[2], ...
		'String','', ...
		'Style','listbox', ...
		'Tag','models');
	fr_sessions_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'BackgroundColor',[0.95 1 0.95], ...
		'Enable','on', ...
		'Max',[2], ...
		'Position',[541 305 80 60], ...
		'String','', ...
		'Style','listbox', ...
		'Tag','fr_ses');
	overall_av_model_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[461 293 146 14], ...
		'Style','checkbox', ...
		'Visible','off', ...
		'String','average', ...
		'Tag','model_av');
	imp_list_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'BackgroundColor',[1 0.95 0.95], ...
		'Position',[461 231 80 60], ...
		'String','', ...
		'Style','listbox', ...
		'Tag','imp_spks');
	fa_sessions_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'BackgroundColor',[1 0.95 0.95], ...
		'Enable','on', ...
		'Max',[2], ...
		'Position',[541 231 80 60], ...
		'String','', ...
		'Style','listbox', ...
		'Tag','fa_ses');
	overall_av_imp_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[461 219 146 14], ...
		'Style','checkbox', ...
		'Visible','on', ...
		'String','average', ...
		'Tag','imp_av');
	combination_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Enable','on', ...
		'Position',[461 204 146 14], ...
		'String',{'1 utt.', '2 utts.'}, ...
		'Style','popupmenu', ...
		'Callback','',...
		'Tag','combinations');
	new_figure_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[524 144 83 18], ...
		'Style','checkbox', ...
		'String','new figure', ...
		'Tag','new_figure');
	hold_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[461 144 60 18], ...
		'Style','checkbox', ...
		'String','hold', ...
		'Tag','hold', ...
		'Callback','if get(gcbo,''Value'') Plot_SR_parameters_Callback(''hold on''); else Plot_SR_parameters_Callback(''hold off''); end');
	star_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[461 126 146 18], ...
		'Style','checkbox', ...
		'String','show data points', ...
		'Tag','stars');
	draw_button_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[461 184 38 18], ...
		'String','Draw', ...
		'Tag','Draw_Button', ...
		'Callback','Plot_SR_parameters_Callback(''draw'')');
	clear_button_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[502 184 38 18], ...
		'String','Clear', ...
		'Tag','Clear_Button', ...
		'Callback','Plot_SR_parameters_Callback(''clear_figure'')');
	clone_button_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[546 184 38 18], ...
		'String','Clone', ...
		'Tag','Clone_Button', ...
		'Callback','Plot_SR_parameters_Callback(''clone_figure'')');
	hist_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[461 164 60 18], ...
		'Style','checkbox', ...
		'String','draw histogram', ...
		'Tag','hist');
	more_info_handle1 = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[524 164 54 18], ...
		'Style','togglebutton', ...
		'String','show more', ...
		'Tag','more1', ...
		'Callback', 'Plot_SR_parameters_Callback(''show_more1'')');
	more_info_handle2 = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[580 164 26 18], ...
		'Style','togglebutton', ...
		'String','sm2', ...
		'Tag','more2', ...
		'Callback', 'Plot_SR_parameters_Callback(''show_more2'')');
	zoom_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[461 108 60 18], ...
		'Style','checkbox', ...
		'String','zoom', ...
		'Tag','zoom', ...
		'Callback','zoom');
	zoomout_button_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[524 108 60 18], ...
		'String','zoom out', ...
		'Tag','Zoom_Button', ...
		'Callback','zoom out');				
	s_model_list_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'BackgroundColor',[0.8 1 0.8], ...
		'Position',[461 34 65 70], ...
		'String','', ...
		'Style','listbox', ...
		'Tag','s_models');
	s_session_list_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'BackgroundColor',[0.8 1 0.8], ...
		'Position',[524 34 73 70], ...
		'String','', ...
		'Style','listbox', ...
		'Tag','s_sessions');
	show_button_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'BackgroundColor',[0.8 1 0.8], ...
		'Position',[460 14 60 18], ...
		'String','Show', ...
		'Tag','Show_Button', ...
		'Callback','Plot_SR_parameters_Callback(''show'')');
	clearstars_button_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'BackgroundColor',[0.8 1 0.8], ...
		'Position',[522 14 60 18], ...
		'String','Clear', ...
		'Tag','ClearStars_Button', ...
		'Callback','Plot_SR_parameters_Callback(''clear_marked_stars'')');
	exp_info_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[80 67 356 10], ...
		'BackgroundColor', [0.1 0.1 0.1], ...
		'ForegroundColor', [1 1 1], ...
		'Style','text', ...
		'FontSize',8,...
		'String','', ...
		'Tag','exp_info', ...
		'HorizontalAlignment','left');
	info1_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[80 58 296 10], ...
		'Style','text', ...
		'FontSize',8,...
		'String','', ...
		'Tag','info1', ...
		'HorizontalAlignment','left');
	info2_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[80 48 296 10], ...
		'Style','text', ...
		'FontSize',8,...
		'String','', ...
		'Tag','info2', ...
		'HorizontalAlignment','left');
	info3_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[80 38 296 10], ...
		'Style','text', ...
		'FontSize',8,...
		'String','', ...
		'Tag','info3', ...
		'HorizontalAlignment','left');
	label1_info_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[80 26 296 10], ...
		'Style','text', ...
		'FontSize',8,...
		'String','', ...
		'Tag','label1', ...
		'HorizontalAlignment','left');
	label2_info_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[80 16 360 10], ...
		'Style','text', ...
		'FontSize',8,...
		'String','', ...
		'Tag','label2', ...
		'HorizontalAlignment','left');
	play_button_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[380 54 20 15], ...
		'FontSize',7,...
		'String','Play', ...
		'Tag','Play_Button', ...
		'Callback','Plot_SR_parameters_Callback(''play'')');
	play_sd_button_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[400 54 40 15], ...
		'FontSize',7,...
		'String','Play (SD)', ...
		'Tag','Play_SD_Button', ...
		'Callback','Plot_SR_parameters_Callback(''play with SD'')');
	show_llh_button_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[380 42 60 12], ...
		'FontSize',7,...
		'String','llh details', ...
		'Tag','Show_llh_Button', ...
		'Callback','Plot_SR_parameters_Callback(''show llh'')');
	edit_button_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'Position',[380 29 60 12], ...
		'FontSize',7,...
		'String','Edit', ...
		'Tag','Edit_Button', ...
		'Callback','Plot_SR_parameters_Callback(''edit'')');
		
	
	colormap(hsv);
	m=colormap;
	for i=1:32,
		mycolors(i,:)=m(2*i,:);
	end
	% extend for large populations
	mycolors = [ mycolors; (mycolors + 0.2*(1-mycolors)); (mycolors + 0.4*(1-mycolors)); (mycolors + 0.6*(1-mycolors)); (mycolors + 0.8*(1-mycolors))]; 
	
	set(model_list_handle,'UserData',mycolors);
