#!/usr/bin/perl


# #####################################################
#
# This file is part of the Perl scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

my $CVS_Version_String = '$Id: message2log.pl,v 1.7 2004/02/17 09:43:09 tuerk Exp $';
my $CVS_Name_String = '$Name: rel-1-4-01 $';


use lib $ENV{"MASV_PERL_ROOT"};

use SR_lib;
use strict;

use File::Copy;
use File::Path;
use Getopt::Long qw( GetOptions );
use Pod::Usage;


###########################
# Default values for options
my $help = 0;
my $visible = 0;
my $log_file = '';
my $Identify = 0;
###########################
# Processing Options

# flat
GetOptions('help|?' => \$help,
		   'visible|v' => \$visible,
		   'logfile=s' => \$log_file,
           'version' => \$Identify);

if ($Identify) {
	printf "$0\n$CVS_Version_String\n$CVS_Name_String\n\n"; 
}

if ((@ARGV != 2) || ($help)) {
   pod2usage(1);
   exit 1;
}

 
my $message = $ARGV[0];
my $sv_system_name = $ARGV[1];


my $sv_system_path = "${SR_lib::sv_systems_dir}${sv_system_name}$SR_lib::sign";
my $log_path = "${sv_system_path}log$SR_lib::sign";
$log_file = ($log_file) ? $log_file : "log.txt";



&SR_lib::check_and_create_dir($log_path);
my $log_handle = &SR_lib::open_file(">>", "$log_path" . "$log_file");
print $log_handle "\n\n";
print $log_handle scalar localtime, "\n";
print $log_handle "message2log\n";
print $log_handle "-----------\n";
print $log_handle "$message\n";

close $log_handle;

if ($visible) {
	print STDOUT "\n\n";
	print STDOUT scalar localtime, "\n";
	print STDOUT "-----------\n";
	print STDOUT "$message\n";
	print STDOUT "-----------\n\n";
}


exit 0;





__END__

=head1 NAME

message2log.pl  - write message to log file of a SV system

=head1 SYNOPSIS

message2log.pl [options] message sv_system_name

 Writes the message to the log file of a SV system. Standard log file is
 log.txt.
 All log files are kept in the "log/" directory inside the SV system directory.
 
 Options:
                          
 -visible | v              display message also on STDOUT.

 -logfile                  set logfile; default is log.txt.

 -? | help                 display this message.
 
=cut

