#!/bin/bash

MLFFILE=$1

# remove trailing head and tail of mlf file 
NUMSEG=`cat $MLFFILE | wc -l`
NUMSEG=$(( $NUMSEG - 3 ))

NUMSUBWORDS=`cat $MLFFILE | grep -e '[0-9]\.[0-9]..*[0-9]\.[0-9]' -c`

MAXTIME=`tail -n 2 $MLFFILE | head -n 1 | awk '{time = $2 / 10000000; printf("%f", time)}'`

# first tier (segments)
cat > /tmp/temp_mlf2TextGrid  <<-'TextGrid_EOF'
	File type = "ooTextFile"
	Object class = "TextGrid"
	
	xmin = 0 
	xmax = ##XMAX
	tiers? <exists> 
	size = 2 
	item []: 
	    item [1]:
	       	class = "IntervalTier" 
	        name = "HTK segmentation" 
	        xmin = 0 
	        xmax = ##XMAX
	        intervals: size = ##NUMSEG 
TextGrid_EOF


cat /tmp/temp_mlf2TextGrid | sed "s/##XMAX/$MAXTIME/" | sed "s/##NUMSEG/$NUMSEG/"

cat $MLFFILE | tail -n $(( $NUMSEG + 1 )) | head -n $NUMSEG | awk -f ${MASV_PERL_ROOT}mlf2TextGrid.awk


# second tier (sub words
cat > /tmp/temp_mlf2TextGrid  <<-'TextGrid_EOF'
	    item [2]:
	       	class = "IntervalTier" 
	        name = "sub words" 
	        xmin = 0 
	        xmax = ##XMAX
	        intervals: size = ##NUMSEG 
TextGrid_EOF


cat /tmp/temp_mlf2TextGrid | sed "s/##XMAX/$MAXTIME/" | sed "s/##NUMSEG/$NUMSUBWORDS/"

cat $MLFFILE | tail -n $(( $NUMSEG + 1 )) | head -n $NUMSEG | awk -f ${MASV_PERL_ROOT}mlf2subWordsTextGrid.awk


