#!/usr/bin/perl


# #####################################################
#
# This file is part of the Perl scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

my $CVS_Version_String = '$Id: split_file_lists.pl,v 1.10 2004/05/01 12:32:06 tuerk Exp $';
my $CVS_Name_String = '$Name: rel-1-4-01 $';


use lib $ENV{"MASV_PERL_ROOT"};

use SR_lib;
use strict;

use File::Copy;
use File::Path;
use Getopt::Long qw( GetOptions );
use Pod::Usage;

my $head = 0;
my $help = 0;
my $Identify = 0;

GetOptions('h|head' => \$head,
			'help|?' => \$help,
			'version' => \$Identify);

if ($Identify) {
	printf "$0\n$CVS_Version_String\n$CVS_Name_String\n\n"; 
}

if ((@ARGV != 3) || ($help)) {
   pod2usage(1);
   exit 1;
}

my $inputfile = $ARGV[0];
my $outputfile = $ARGV[1];

my $decimate_rec_number = $ARGV[2];


my $in_handle = &SR_lib::open_file("<", $inputfile);
my @in_content = <$in_handle>;
close $in_handle;

# keep only path with spk no, session no and filename
my $param_base_path = substr($in_content[0],0, (length($in_content[0]) - 23));
my $line = $in_content[0];
$line =~ s/$param_base_path//;
my @linecontent = split (/\//, $line);


my $spkID = $linecontent[0];

my $prev_spk = $spkID;


my %DataHash = ();
my @SessionArray = ();
my @sessions = ();
my @recs = ();

my $spkID;

my $out_handle = &SR_lib::open_file(">", $outputfile);

foreach my $line (@in_content) {
	$line =~ s/$param_base_path//;
	@linecontent = split (/\//, $line);
	
	$spkID = $linecontent[0];
	my $sesID = $linecontent[1];
	my $recID =$linecontent[2];
	chomp($recID);
	
	if ($prev_spk eq $spkID) {
		push @sessions, $sesID;
		push @recs, $recID;
	}
	else {
		# new spk
		@SessionArray = ([@sessions], [@recs]);
		$DataHash{$prev_spk} = [ @SessionArray ];
		@sessions = ();
		@recs = ();
		push @sessions, $sesID;
		push @recs, $recID;		
	}
	
	$prev_spk = $spkID;
	
}
@SessionArray = ([@sessions], [@recs]);
$DataHash{$spkID} = [ @SessionArray ];


foreach my $current_key (sort(keys(%DataHash))) {
	
	my $orig_length = scalar @{$DataHash{$current_key}->[0]};
	#print $orig_length , "\n";
	if ($head) {
		for (my $new_rec_counter = 1; $new_rec_counter <= $decimate_rec_number; $new_rec_counter++) {
			my $rec_index = $new_rec_counter - 1;
			print $out_handle "${param_base_path}${current_key}/$DataHash{$current_key}->[0]->[$rec_index]" . "/" . "$DataHash{$current_key}->[1]->[$rec_index]" . "\n";
		}
	}
	else {
		for (my $new_rec_counter = 1; $new_rec_counter <= $decimate_rec_number; $new_rec_counter++) {
			my $rec_index = &ceil( ($orig_length / ($decimate_rec_number - 1))* ($new_rec_counter - 1) ) - 1;
			print $out_handle "${param_base_path}${current_key}/$DataHash{$current_key}->[0]->[$rec_index]" . "/" . "$DataHash{$current_key}->[1]->[$rec_index]" . "\n";
		}
	}
}

close $out_handle;


sub ceil {
	my $number = $_[0];
	my $return_value = (int($number) == $number) ? $number : int($number) + 1;
	$return_value = ($return_value < 1 ) ? $return_value + 1 : $return_value;
	return $return_value;
}



__END__

=head1 NAME

split_file_lists.pl  - split script files

=head1 SYNOPSIS

split_file_lists.pl [options]   inputlist   outputlist   output_no_of_entries


Reduce a script file to  <output_no_of_entries> list entries. If more than one speaker
is contained in the inputlist (e.g. world lists), the reduction is done for 
each speaker seperately. The selection is done evenly spaced over all entries of 
a speaker. In contrast, the option -h takes the first <output_no_of_entries> 
entries.

Use the shell script "create_difference_list.sh" to create the 
complementary part.

 Options:

 -h | head                return the first <output_no_of_entries> entries
                          in a contiguous block. 

 -? | help                display this message.
 
=cut

