function return_value=compare_cell_lists(cell_list1, cell_list2)
%
% function return_value=compare_cell_lists(cell_list1, cell_list2)
%              return_value: 1 = equal, 0 = not equal
%
% CVS_Version_String = '$Id: compare_cell_lists.m,v 1.5 2004/05/06 12:39:52 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

	

	return_value = 1;

	for item = 1:length(cell_list1),
		if ~(contained_in_cell(cell_list1{item}, cell_list2)),
			return_value = 0;
			break;
		end
	end

	for item = 1:length(cell_list2),
		if ~(contained_in_cell(cell_list2{item}, cell_list1)),
			return_value = 0;
			break;
		end
	end
	
	
