function [new_vector, varargout] = remove_vector_items(vector, indizes_to_remove)
% function [new_vector, [new_indizes_based_on_old_vector]] = remove_vector_items(vector, indizes_to_remove)
%
% CVS_Version_String = '$Id: remove_vector_items.m,v 1.4 2004/01/26 18:21:18 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################
	if (isempty(indizes_to_remove)),
		new_vector = vector;
		return;
	end
	
	indizes_to_remove=sort(indizes_to_remove);
	current_search_item = 1;
	new_indizes=zeros(1, (length(vector) - length(indizes_to_remove)));
	indizes_counter=1;
	for i=1:length(vector),
		if ( (current_search_item <= length(indizes_to_remove)) & (i == indizes_to_remove(current_search_item) ) ),
			current_search_item = current_search_item + 1;
		else
			new_indizes(indizes_counter) = i;
			indizes_counter=indizes_counter + 1;
		end
	
	end
	
	new_vector=vector(new_indizes);
	if (nargout == 2),
		varargout{1} = new_indizes;
	end
	return;
	

