function result = textwrite(filename, cell_array, varargin)
% function result = textwrite(filename, cell_array, [filemode])
%
% default for filemode: 'w' (write)
% 	use 'a' for append
%
% CVS_Version_String = '$Id: textwrite.m,v 1.3 2003/11/08 15:14:24 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

	if (nargin == 3),
		filemode = varargin{1};
	else
		filemode = 'w';
	end
	

	result = 0;
	
	fid = fopen(filename, filemode);
	
	for i=1:length(cell_array),
		fprintf(fid, '%s\n', cell_array{i});
	end
	
	fclose(fid);
	
