function fb = HTK_InitFBank(frameSize,sampPeriod, numChans, lopass, hipass,  usePower)

   %/* Save sizes to cross-check subsequent usage */
   fb.frameSize = frameSize;
   fb.numChans = numChans;
   fb.sampPeriod = sampPeriod; 
   fb.usePower = usePower;
   %/* Calculate required FFT size */
   fb.fftN = 2;   
   while (frameSize>fb.fftN)
	   fb.fftN = fb.fftN * 2;
   end

   Nby2 = fb.fftN / 2;
   fb.fres = 1.0E7/(sampPeriod * fb.fftN * 700.0);
   maxChan = numChans+1;
   %/* set lo and hi pass cut offs if any */
   fb.klo = 2;
   fb.khi = Nby2;      % /* apply lo/hi pass filtering */
   mlo = 0;
   mhi = HTK_Mel(Nby2+1,fb.fres);
   if (lopass>=0)
      mlo = 1127*log(1+lopass/700.0);
      fb.klo = ((lopass * sampPeriod * 1.0e-7 * fb.fftN) + 2.5);
      if (fb.klo<2) 
		  fb.klo = 2;
	  end
   end
   if (hipass>=0)
      mhi = 1127*log(1+hipass/700.0);
      fb.khi = ((hipass * sampPeriod * 1.0e-7 * fb.fftN) + 0.5);
      if (fb.khi>Nby2) 
		  fb.khi = Nby2;
	  end
  end
   %/* Create vector of fbank centre frequencies */
   fb.cf = zeros(maxChan,1);
   ms = mhi - mlo;
   for chan=1:maxChan,
         fb.cf(chan) = (chan/maxChan)*ms + mlo;
   end
   
   %/* Create loChan map, loChan[fftindex] -> lower channel index */
   fb.loChan = zeros(Nby2,1);
   chan=1;
   for k=1:Nby2,
      melk = HTK_Mel(k,fb.fres);
      if ( (k<fb.klo) | (k>fb.khi))
		  fb.loChan(k) = -1;
      else
         while ((fb.cf(chan) < melk)  & (chan<=maxChan)),
			 chan=chan + 1; %++chan;
		 end
         fb.loChan(k) = chan-1;
	 end
  end

   %/* Create vector of lower channel weights */   
   fb.loWt = zeros(Nby2,1);
   for k=1:Nby2
      chan = fb.loChan(k);
      if ( (k<fb.klo) | (k>fb.khi)),
		  fb.loWt(k)=0.0;
      else
         if (chan>0) 
            fb.loWt(k) = ((fb.cf(chan+1) - HTK_Mel(k,fb.fres)) /  (fb.cf(chan+1) - fb.cf(chan)));
         else
            fb.loWt(k) = (fb.cf(1) - HTK_Mel(k,fb.fres))/(fb.cf(1) - mlo);
		end
	  end
   end
return;

   
function mel = HTK_Mel(k,fres)
	
   mel = 1127 * log(1 + (k-1)*fres);
   
return;
   
