function [cut_wave_data, varargout] = HTK_SigP_SilenceDetection( wave_data, SD_config)
% function [cut_wave_data, [border_info] ] = HTK_SigP_SilenceDetection( 
%                                             wave_data, SD_config)
%
% CVS_Version_String = '$Id: HTK_SigP_SilenceDetection.m,v 1.8 2004/04/29 11:28:29 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	SR_lib;
	
	frame_length = round(SD_config.windowSize / SD_config.sourceRate);
	frame_shift = round(SD_config.targetRate / SD_config.sourceRate);

	proc_wave_data =wave_data * (32768/ 4096);
	
	
	[SD_param, energy_db] = HTK_Parm_SetWaveSPDetParms( proc_wave_data, SD_config, frame_length, frame_shift);
	
	[spDetSt, spDetEn] = HTK_Parm_RunSilDet(SD_param, SD_config, energy_db);
	
	spDetStart_samples = (spDetSt*frame_shift + 1);
	spDetEnd_samples = ((spDetEn - 1) * frame_shift + frame_length );
	cut_wave_data = wave_data( spDetStart_samples:spDetEnd_samples );
	
	if (nargout >= 2),
		varargout{1} = struct('spDetStart_samples',spDetStart_samples,'spDetEnd_samples',spDetEnd_samples, 'spDetSt', spDetSt, 'spDetEn', spDetEn, 'SD_param', SD_param, 'energy_db', energy_db);
	end
	if (nargout >= 3),
		varargout{2} = energy_db;
	end
	if (nargout >= 4),
		varargout{3} = SD_param;
	end
	



function [SD_param, energy_db] = HTK_Parm_SetWaveSPDetParms( wave_data, SD_config, frame_length, frame_shift)

	wave_start=1;
	wave_end=length(wave_data);
	


	frames = enframe(wave_data,frame_length,frame_shift);
	
	no_frames = size(frames,1);

	speech_frames = zeros(no_frames,1);
	
	energy = [];
	for i=1:no_frames,
		frame=frames(i,:);
		energy(i) = sum(frame.^2);
		mean_f(i) = mean(frame);
	end

	energy_norm = energy./frame_length - mean_f.*mean_f;
	indizes = find(energy_norm <= 0);
	if (~(isempty(indizes))),
		energy_norm(indizes) = 0.32768;
	end
	
	% eFr[] in HParm.c, line 2041
	energy_db = 10*log10(energy_norm/0.32768);

	range = (max(wave_data) - min(wave_data))/65536;
	
	offset = mean(mean_f);
	
	SD_param = HTK_Parm_CalcSilDetParms(wave_data, energy_db, offset, range, SD_config.speechThresh);


	

function [spDetSt, spDetEn] = HTK_Parm_RunSilDet(SD_param,SD_config, energy_db)

	energy_db = energy_db - SD_param.ml_thresh;
	
	no_frames = length(energy_db);
	
	spDetCur = 0;
	spDetLst = 0;
	spDetSt = 0;
	spDetEn = 0;
	spDetFin = 0;

	spDetCnt = 0;
	silDetCnt = 0;
	
	state = 'PB_WAITING';
	
	for i=0:(no_frames-1),
	
		if (energy_db(i+1) > 0 ),
			spDetCnt = spDetCnt + 1;
		else
			silDetCnt = silDetCnt + 1;
		end
		
		if (spDetCur >= SD_config.spcSeqCount ),
			if (energy_db(i-SD_config.spcSeqCount  + 1) > 0)
				spDetCnt = spDetCnt - 1;
			else
				silDetCnt = silDetCnt - 1;
			end
		end
		
		switch state
			
			case 'PB_WAITING'
			
				if ( (spDetCnt >= SD_config.spcSeqCount - SD_config.spcGlchCount) & (spDetCur >= SD_config.spcSeqCount))
					state = 'PB_STOPPING';
					spDetLst = spDetCur;
					spDetSt=spDetCur - SD_config.spcSeqCount - SD_config.silMargin;
					if (spDetSt < 0),
						spDetSt = 0;
					end
					spDetFin = spDetCur;
					%disp(['In Speech: ' num2str(spDetSt) ]);
				end
				
			case 'PB_STOPPING'
			
				if ((spDetCur - spDetLst) >= (SD_config.silSeqCount + SD_config.spcSeqCount)) 
					state = 'PB_STOPPED';
					spDetEn=spDetLst + SD_config.silMargin;
					spDetFin = spDetEn - 1;
					%disp(['Finished Speech: ' num2str(spDetEn) ]);
				end
				
				if ( spDetCnt >= (SD_config.spcSeqCount - SD_config.silGlchCount)),
					spDetLst = spDetCur;
				else
					if (( spDetLst == (spDetCur - 1)))
						%disp(['Start Sil: ' num2str(i) ]);
					end
				
				end
				
				if (spDetCur < (spDetLst + SD_config.silMargin))
					spDetFin=spDetCur;
				end
				
			case 'PB_STOPPED'
			
				spDetFin = spDetEn - 1;
		
		end
	
	
		spDetCur = spDetCur + 1;
	end
	
	switch state
		case 'PB_STOPPING'
			spDetEn=spDetCur;
			spDetFin = spDetEn - 1;
			
		case 'PB_WAITING'
			spDetSt = 0;
			spDetEn = 0;
			spDetFin = -1;
			
	end


function SD_param = HTK_Parm_CalcSilDetParms(wave_data, energy_db, offset, range, spThresh);

	ML_PARTS = 10;

	ML_SIL_ST=2;
	ML_SIL_EN=3;
	ML_SP_ST=8;
	ML_SP_EN=9;
	
	nFr = length(energy_db);
	
	energy_db_sorted = sort(energy_db);
	
	% assume: silDiscard = 0.0
	% skip 1884-1887
	
	aBl(1) = 0; % matlab arrays starting with 1!
	
	aBl(2:ML_PARTS+1) = 0;
	
	%skip if (line 1889) and elsif (line 1894)
	nBl = nFr / ML_PARTS;
	
	frame_counter = 1;
	thresh = nBl;
	
	for current_block=1:ML_PARTS,
		e = round(thresh);
		block_begin_frame = frame_counter;
		block_end_frame = e;
		aBl(current_block+1) = mean(energy_db_sorted(block_begin_frame:block_end_frame));
	
		frame_counter = block_end_frame + 1 ;
		thresh =  thresh + nBl;
	end

	sil = mean(aBl(ML_SIL_ST+1:ML_SIL_EN+1));
	sp = mean(aBl(ML_SP_ST+1:ML_SP_EN+1));
	
	snr = aBl(2);
	
	if ( (sil-snr) > spThresh )
		sil = snr;
	end
	if ( (( energy_db_sorted(end) - energy_db_sorted(2)) > spThresh ) &  ((sp-sil) > spThresh) ),
		snr = sp - sil;
	else
		sp = -1;
		snr = 3*spThresh;
		thresh = sil + spThresh;
	end
	
	thresh = sil + spThresh;
	
	SD_param.ml_min = energy_db_sorted(2);
	SD_param.ml_sil = sil;
	SD_param.ml_thresh=thresh;
	SD_param.ml_sp = sp;
	SD_param.ml_max = energy_db_sorted(end);
	SD_param.ml_range = range;
	SD_param.ml_off = offset;
	SD_param.ml_snr = snr;
		
	
