function score_result_struct = add_part_to_score_result(result_struct, score_result_struct, result_type, description, menu_descr, threshold, include_models, imp_spks_list, fr_sel_sessions, fa_sel_sessions)
% function score_result_struct = add_part_to_score_result(result_struct,
%                                   score_result_struct, result_type, 
%                                   description, menu_descr, threshold, include_models, imp_spks_list,
%                                   fr_sel_sessions, fa_sel_sessions)
%
% CVS_Version_String = '$Id: add_part_to_score_result.m,v 1.15 2004/05/25 15:08:30 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	SR_lib;
	

	ext_model_info = create_ext_model_info(result_struct.model_info);


	num_of_models = length(include_models);
	
	if length(threshold) == 1,
		internal_type = 'SI';
	elseif length(threshold) == num_of_models,
		internal_type = 'SD';
	else
		error('[add_part_to_score_result]: wrong length of threshold.');
	end
	
	if strcmp(internal_type,'SI'),
		threshold = repmat(threshold,1,num_of_models);
	end
	
	part_index = length(score_result_struct.part) + 1;

	score_result_struct.part{part_index}.num_of_models = num_of_models;
	score_result_struct.part{part_index}.models = include_models;
	score_result_struct.part{part_index}.imp_spks_list = imp_spks_list;
	score_result_struct.part{part_index}.fr_sel_sessions = fr_sel_sessions;
	score_result_struct.part{part_index}.fa_sel_sessions = fa_sel_sessions;
	
	switch result_type
		case {'fr_fa'}
			for i=1:num_of_models,
				% threshold
				score_result_struct.part{part_index}.model(i).data.threshold = threshold(i);
			end
		case 'det'
			% do nothing
		case 'det_bs_sample'
			% do nothing
		case 'eer'
			% do nothing
	end
	
	score_result_struct.part{part_index}.menu_descr = menu_descr;
	score_result_struct.part{part_index}.info = ['model spk sessions: ' join_strings(fr_sel_sessions,', ') ';imp spk sessions: ' join_strings(fa_sel_sessions,', ') ';imp spks: '  join_strings(imp_spks_list,', ') ];

	score_result_struct.part{part_index}.description = description;
	
	switch result_type
		case 'eer'
			score_result_struct = calc_score_result_eer_part(score_result_struct, part_index, result_struct, ext_model_info, include_models,  imp_spks_list, fr_sel_sessions, fa_sel_sessions);
			score_result_struct = calc_score_result_cmn_part(score_result_struct, part_index, result_struct, ext_model_info, include_models, imp_spks_list, fr_sel_sessions, fa_sel_sessions, result_type);
		case 'fr_fa'
			score_result_struct = calc_score_result_fra_part(score_result_struct, part_index, result_struct, ext_model_info, include_models, imp_spks_list, fr_sel_sessions, fa_sel_sessions);
			score_result_struct = calc_score_result_cmn_part(score_result_struct, part_index, result_struct, ext_model_info, include_models, imp_spks_list, fr_sel_sessions, fa_sel_sessions, result_type);
		case 'det'
			score_result_struct = calc_score_result_det_part(score_result_struct, part_index, result_struct, ext_model_info, include_models, imp_spks_list, fr_sel_sessions, fa_sel_sessions, 'det');
			score_result_struct = calc_score_result_cmn_part(score_result_struct, part_index, result_struct, ext_model_info, include_models, imp_spks_list, fr_sel_sessions, fa_sel_sessions, result_type);
		case 'det_bs_sample'
			score_result_struct = calc_score_result_det_part(score_result_struct, part_index, result_struct, ext_model_info, include_models, imp_spks_list, fr_sel_sessions, fa_sel_sessions, 'det_bs_sample');
	end

	
