function [FR, FA, borders_common, varargout] = calc_FR_FA_pairs(FR_borders, FA_borders)
% function [FR, FA, borders_common, [type_common, [sort_index]] ] =
%       calc_FR_FA_pairs(FR_borders, FA_borders)
%
% CVS_Version_String = '$Id: calc_FR_FA_pairs.m,v 1.9 2004/05/28 14:45:16 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	vector_length_fr=length(FR_borders);
	probabilities_fr = (1:vector_length_fr) / vector_length_fr * 100;
	
	vector_length_fa=length(FA_borders);
	probabilities_fa = (1:vector_length_fa) / vector_length_fa * 100;
	probabilities_fa = [(100 - probabilities_fa)];

	
	% common border array
	concat_prob = [probabilities_fr probabilities_fa];
	[borders_common, sort_index] = sort([ FR_borders  FA_borders]);
	clear probabilities_fr;
	clear probabilities_fa;
	
	
	
	length_sort_index = length(sort_index);
	
	
	FR_indicator = uint8(ones(1,vector_length_fr));
	FA_indicator = uint8(zeros(1,vector_length_fa));
	concat_indicator = [FR_indicator FA_indicator];
	type_common = concat_indicator(sort_index);
	clear concat_indicator;
	clear FR_indicator;
	clear FA_indicator;
	
	FA=zeros(1,length_sort_index);
	FR=zeros(1,length_sort_index);

	%FA(1)=100;
	%FR(1)=0;
	
	sorted_prob = concat_prob(sort_index);
	clear concat_prob;
	
	%FA(2:end)=sorted_prob(2:end);
	%FR(2:end)=sorted_prob(2:end);
	FA=sorted_prob;
	FR=sorted_prob;
	if (type_common(1) == 0),
		FR(1) = 0;
	else
		FA(1) = 100;
	end
	
	for i=2:length_sort_index
		indicator = type_common(i);
		
		if (indicator)
			% change in value of FR_borders
			% FA keeps value
			FA(i)=FA(i-1);
		else
			% change in value of FA_borders
			% FR keeps value
			FR(i)=FR(i-1);
		end

	end
	
	
	if (nargout >= 4),
		varargout{1} = uint8(type_common);
	end
	
	if (nargout >= 5),
		varargout{2} = sort_index;
	end
	
