function model_struct=calc_model_values(mlf_file,llhsum_type,full_calc_flag,full_info_flag)
% function model_struct=calc_model_values(mlf_file,llhsum_type,full_calc_flag,full_info_flag)
%
% CVS_Version_String = '$Id: calc_model_values.m,v 1.4 2003/11/04 10:34:05 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


			model_struct.data = mlf2matlab(mlf_file,1);
			model_struct.num_of_testfiles = length(model_struct.data);
			temp_sum = 0;
			temp_total_length = 0;
			temp_mean_sum = 0;
			temp_std_sum = 0;
			if (strcmp(llhsum_type,'with pauses')),
				% durch alle einzelnen Soundfiles gehen
				for k = 1:model_struct.num_of_testfiles,
					%%%
					%%%  singleFile = model_struct.data(k);
					%%%
					% Summe fuer ein File berechnen
					model_struct.data(k).simple_llh_sum=sum(model_struct.data(k).llh_vector);
					duration = (double(model_struct.data(k).end_time) - double(model_struct.data(k).start_vector(1)));
					model_struct.data(k).llh_per_frame = model_struct.data(k).simple_llh_sum / duration;
					model_struct.data(k).duration = uint16(duration);
				end
				if (full_calc_flag),
					for k = 1:model_struct.num_of_testfiles,
						% Anzahl States in einem File
						length_llh_vector = length(model_struct.data(k).llh_vector);
						temp_total_length = temp_total_length + length_llh_vector;
						% mean und std fuer ein File
						model_struct.data(k).simple_llh_mean=mean(model_struct.data(k).llh_vector);
						model_struct.data(k).simple_llh_std=std(model_struct.data(k).llh_vector);
						% globale Summe fr alle Files berechnen
						temp_sum = temp_sum + model_struct.data(k).simple_llh_sum;
						% Aufsummieren fr globales mean und globales std
						temp_mean_sum = temp_mean_sum + model_struct.data(k).simple_llh_mean * length_llh_vector;
						temp_std_sum = temp_std_sum + (length_llh_vector - 1 ) * (model_struct.data(k).simple_llh_std)^2;
					end
				end
			end
			if (strcmp(llhsum_type,'without pauses')),
				% durch alle einzelnen Soundfiles gehen
				for k = 1:model_struct.num_of_testfiles,
					%%%
					%%%  singleFile = model_struct.data(k);
					%%%
					% Summe fuer ein File berechnen, durch alle einzelnen States gehen
					% keine sil und sp Pausen
					selected_phonemes_indizes = find(model_struct.data(k).phoneme_vector < 100);
					model_struct.data(k).simple_llh_sum=sum(model_struct.data(k).llh_vector(selected_phonemes_indizes));
					s_time = double(model_struct.data(k).start_vector(selected_phonemes_indizes));
					end_time_vector = [double(model_struct.data(k).start_vector) double(model_struct.data(k).end_time)];
					e_time = end_time_vector(selected_phonemes_indizes + 1);
					duration = sum(e_time - s_time);
					model_struct.data(k).llh_per_frame = model_struct.data(k).simple_llh_sum / (duration);
					model_struct.data(k).duration = uint16(duration);
				end
				if (full_calc_flag),
					for k = 1:model_struct.num_of_testfiles,
						% keine sil und sp Pausen
						selected_phonemes_indizes = find(model_struct.data(k).phoneme_vector < 100);
						% Anzahl States in einem File
						length_llh_vector = length(model_struct.data(k).llh_vector(selected_phonemes_indizes));
						temp_total_length = temp_total_length + length_llh_vector;
						% mean und std fuer ein File
						model_struct.data(k).simple_llh_mean=mean(model_struct.data(k).llh_vector(selected_phonemes_indizes));
						model_struct.data(k).simple_llh_std=std(model_struct.data(k).llh_vector(selected_phonemes_indizes));
						% globale Summe fr alle Files berechnen
						temp_sum = temp_sum + model_struct.data(k).simple_llh_sum;
						% Aufsummieren fr globales mean und globales std
						temp_mean_sum = temp_mean_sum + model_struct.data(k).simple_llh_mean * length_llh_vector;
						temp_std_sum = temp_std_sum + (length_llh_vector - 1 ) * (model_struct.data(k).simple_llh_std)^2;
					end
				end
			end
			
			if (full_calc_flag),
				model_struct.param.total_llh_sum=temp_sum;
				model_struct.param.total_llh_mean=temp_mean_sum / temp_total_length;
				model_struct.param.total_llh_length = temp_total_length;
				
				% durch alle einzelnen Soundfiles gehen
				for k = 1:length(model_struct.data),
					temp_std_sum = temp_std_sum + length_llh_vector * (model_struct.data(k).simple_llh_mean - model_struct.param.total_llh_mean)^2;
				end
			
				model_struct.param.total_llh_std=sqrt(temp_std_sum / (model_struct.param.total_llh_length - 1));
			end
			
			if ( ~(full_info_flag)), 
				model_struct.data=rmfield(model_struct.data,{'phoneme_vector','start_vector','end_time'});
			end


