function [x,y] = calc_rel_hist_outline_smooth(data)
% function [x,y] = calc_rel_hist_outline_smooth(data)
%
% CVS_Version_String = '$Id: calc_rel_hist_outline_smooth.m,v 1.4 2003/11/04 10:34:05 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	N_hist = round(length(data)/10);
	if (N_hist < 4)
		N_hist = 4;
	end
	if (N_hist > 100)
		N_hist = 100;
	end

	[N,centers] = hist(data,N_hist);

	delta = centers(2)-centers(1);
	
	ext_step = (max(data)-min(data))/5;
	data_ext = [min(data)-2*ext_step min(data)-1*ext_step min(data)-0.5*ext_step ...
	            data max(data)+0.5*ext_step max(data)+1*ext_step max(data)+2*ext_step];

	y_step = 1/length(data_ext);
	fitting_y = (y_step:y_step:1);
	p = polyfit(data_ext,fitting_y,13);
	pdiff = polyder(p);
	
	mean_data = mean(data);
	r = roots(pdiff);
	
	r_r_indizes = [];
	for i=1:length(r),
		if (isreal(r(i))),
			r_r_indizes = [r_r_indizes i];
		end
	end
	r_sorted = sort(r(r_r_indizes));
	
	r1=r_sorted(max(find((r_sorted - mean_data)<0)));
	r2=r_sorted(min(find((r_sorted - mean_data)>0)));

	drawing_x = linspace(r1,r2,200);

	x = [drawing_x];
	y = polyval(pdiff,drawing_x);
	
	indizes = find(y<0);
	y(indizes) = 0;
	
	area = trapz(x,y);
	y=(1/area)*delta * y;
