function score_result_struct = calc_score_result_det_part(score_result_struct, part_index, result_struct, ext_model_info, included_models, imp_spks_list, fr_sel_sessions, fa_sel_sessions, result_type)
% function score_result_struct = calc_score_result_det_part(score_result_struct, 
%                                 part_index, result_struct, ext_model_info, 
%                                 included_models, imp_spks_list, fr_sel_sessions, fa_sel_sessions, result_type)
%
% CVS_Version_String = '$Id: calc_score_result_det_part.m,v 1.23 2004/06/02 09:32:45 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	alpha = 0.05; %error prob.
	z_scale = abs(norminv(alpha/2));
	
	full_speaker_info_flag=0;
	
	score_result_struct.part{part_index}.result_type = result_type;

	num_of_models = length(included_models);
	
	disp('DET part: Calculating FR/FA ...');

	FR_b_collect = [];
	FA_b_collect = [];
	
	FR_speaker_info_collect = [];
	FA_speaker_info_collect = [];
	
	FR_model_info_collect = [];
	FA_model_info_collect = [];
	N_imp_spks_per_model = [];
	
	for i=1:num_of_models,
		absolute_index = strmatch(included_models(i), ext_model_info.trained_models,'exact');

		current_speaker = result_struct.FR_struct{absolute_index}.model_name;
		
		if (strcmp( result_type , 'det_bs_sample')),
			imp_spks_names = get_imp_speakers(imp_spks_list, {current_speaker}, result_struct.model_info, result_struct.FA_struct{absolute_index}.imp_test_spks, included_models); % select only impostors that are also in included_models (cross comparison condition)
		else
			imp_spks_names = get_imp_speakers(imp_spks_list, {current_speaker}, result_struct.model_info, result_struct.FA_struct{absolute_index}.imp_test_spks);
		end
		
		N_imp_spks_per_model(i) = length(imp_spks_names);

		FR_rec_indizes{i} = find_sessions_in_F_struct(result_struct.FR_struct{absolute_index}, fr_sel_sessions, {'all'}, ext_model_info);
		FA_rec_indizes{i} = find_sessions_in_F_struct(result_struct.FA_struct{absolute_index}, fa_sel_sessions, imp_spks_names, ext_model_info);
		
		FR_borders = result_struct.FR_struct{absolute_index}.data.borders(FR_rec_indizes{i});
		FA_borders = result_struct.FA_struct{absolute_index}.data.borders(FA_rec_indizes{i});
		
		FR_b_collect  = [ FR_b_collect FR_borders ];
		FA_b_collect  = [ FA_b_collect FA_borders ];
		
		FR_model_info = uint8(str2num(repmat(current_speaker, length(FR_borders),1)));
		FA_model_info = uint8(str2num(repmat(current_speaker, length(FA_borders),1)));
		
		FR_model_info_collect = [ FR_model_info_collect; FR_model_info];
		FA_model_info_collect = [ FA_model_info_collect; FA_model_info];
		
		
		if (~full_speaker_info_flag),
			FR_speaker_info = result_struct.FR_struct{absolute_index}.data.rec_info(FR_rec_indizes{i},1:4);
			FA_speaker_info = result_struct.FA_struct{absolute_index}.data.rec_info(FA_rec_indizes{i},1:4);
			
			FR_speaker_info_collect = [ FR_speaker_info_collect; uint8(str2num(FR_speaker_info))];
			FA_speaker_info_collect = [ FA_speaker_info_collect; uint8(str2num(FA_speaker_info))];
		
		else
		
			FR_speaker_info = result_struct.FR_struct{absolute_index}.data.rec_info(FR_rec_indizes{i},[(1:4) (6:7) (9:10)]); % remove slashes only real information is stored due to large data size!!
			FA_speaker_info = result_struct.FA_struct{absolute_index}.data.rec_info(FA_rec_indizes{i},[(1:4) (6:7) (9:10)]);
			
			FR_speaker_info_collect = [ FR_speaker_info_collect; uint8(FR_speaker_info)];
			FA_speaker_info_collect = [ FA_speaker_info_collect; uint8(FA_speaker_info)];
		end
		
	end
	clear FR_borders;
	clear FA_borders;
	
	
	[FR_b_collect, FR_sort_indizes]=sort(FR_b_collect);
	if (ndims( FR_speaker_info_collect ) == 2)
		FR_speaker_info_collect = FR_speaker_info_collect(FR_sort_indizes,:);
	else	
		FR_speaker_info_collect = FR_speaker_info_collect(FR_sort_indizes);
	end
	
	FR_model_info_collect = FR_model_info_collect(FR_sort_indizes);
	
	[FA_b_collect, FA_sort_indizes]=sort(FA_b_collect);
	if (ndims( FA_speaker_info_collect ) == 2)
		FA_speaker_info_collect = FA_speaker_info_collect(FA_sort_indizes,:);
	else
		FA_speaker_info_collect = FA_speaker_info_collect(FA_sort_indizes);
	end
	FA_model_info_collect = FA_model_info_collect(FA_sort_indizes);


	
	[FR, FA, borders_common, type_common, fr_fa_sort_index] = calc_FR_FA_pairs(FR_b_collect, FA_b_collect);
	concat_speaker_info = [ FR_speaker_info_collect; FA_speaker_info_collect ];
	
	if (ndims(concat_speaker_info) == 2),
		speaker_info_common = concat_speaker_info(fr_fa_sort_index,:);
	else
		speaker_info_common = concat_speaker_info(fr_fa_sort_index);
	end
	
	concat_model_info = [ FR_model_info_collect; FA_model_info_collect ];
	model_info_common = concat_model_info(fr_fa_sort_index);
	
	
	[eer, eer_coarse,threshold, threshold_coarse, fa_hits, fr_hits, fa_N_tests, fr_N_tests] = calc_EER(FR_b_collect, FA_b_collect);
	
	score_result_struct.part{part_index}.parameters = struct('eer',eer,'eer_coarse', eer_coarse,'threshold', threshold,'threshold_coarse', threshold_coarse, 'fa_hits', fa_hits, 'fr_hits', fr_hits, 'fa_N_tests', fa_N_tests, 'fr_N_tests', fr_N_tests);
	
	


	if (strcmp( result_type , 'det_bs_sample')),
		for i=1:num_of_models
			score_result_struct.part{part_index}.model(i).data.fa_N_tests=length(FA_rec_indizes{i});
			score_result_struct.part{part_index}.model(i).data.fr_N_tests=length(FR_rec_indizes{i});
		end
	else
	
		disp('DET part: calculating individual FR/FA');
		for i=1:num_of_models
	
			absolute_index = strmatch(included_models(i), ext_model_info.trained_models,'exact');
	
			session_filtered_FA_struct.data.borders = result_struct.FA_struct{absolute_index}.data.borders(FA_rec_indizes{i});
			session_filtered_FR_struct.data.borders = result_struct.FR_struct{absolute_index}.data.borders(FR_rec_indizes{i});
	
			%keyboard;
			[fa, fa_coarse, fr, fr_coarse, fa_hits, fr_hits, fa_N_tests, fr_N_tests] = calc_FR_FA_coarse(session_filtered_FR_struct.data,session_filtered_FA_struct.data, threshold_coarse);
	
			score_result_struct.part{part_index}.model(i).data.threshold = threshold;
			score_result_struct.part{part_index}.model(i).data.threshold_coarse = threshold_coarse;
			score_result_struct.part{part_index}.model(i).data.fr=fr_coarse;
			score_result_struct.part{part_index}.model(i).data.fr_hits=fr_hits;
			score_result_struct.part{part_index}.model(i).data.fr_N_tests=fr_N_tests;
			
			score_result_struct.part{part_index}.model(i).data.fa=fa_coarse;
			score_result_struct.part{part_index}.model(i).data.fa_hits=fa_hits;
			score_result_struct.part{part_index}.model(i).data.fa_N_tests=fa_N_tests;
			
			score_result_struct.part{part_index}.model(i).model_name=included_models{i};
		end
	end
	
	
	
	
	
	
	fr_hits_vector = zeros(1,num_of_models);

	
	
	fr_N_tests_vector = get_nested_field(score_result_struct.part{part_index}.model,'data.fr_N_tests');
	fa_N_tests_vector = get_nested_field(score_result_struct.part{part_index}.model,'data.fa_N_tests');
	
	
	

	sub_sampling_ci = 100; % every 100th FR/FA pair is used for calculation conf. intervals
	predefined_length = ceil(length(borders_common) / sub_sampling_ci);
	fr_av_of_attV=zeros(1,predefined_length);
	
	fa_av_of_attV=zeros(1,predefined_length);
	
	thresholds_V=zeros(1,predefined_length);
	%cont_anyway = 1;
	vector_counter = 1;
	
	if (isfield(result_struct,'cross_validation_flag') & (result_struct.cross_validation_flag)),
		
		for i=1:num_of_models,
			absolute_index = strmatch(included_models(i), ext_model_info.trained_models,'exact');
			sub_absolute_index = i;
			current_speaker = included_models{i};
			imp_spks_names = get_imp_speakers(imp_spks_list, {current_speaker}, result_struct.model_info, result_struct.FA_struct{absolute_index}.imp_test_spks, included_models); % select only impostors that are also in included_models (cross comparison condition)
			
			spk_info_array = result_struct.FA_struct{absolute_index}.data.rec_info(FA_rec_indizes{i},:);
			spk_info_array = spk_info_array(:,1:4); 
			for j = 1:length(imp_spks_names)
				current_imp_spk = imp_spks_names(j);
				sub_absolute_imp_index = strmatch(current_imp_spk, included_models,'exact');
				fa_N_tests_array(sub_absolute_index, sub_absolute_imp_index) = length(strmatch( current_imp_spk, spk_info_array ));
			end
		end
		fa_hits_infavour_imp_array = fa_N_tests_array;
		
		
		score_result_struct.part{part_index}.cross_validation_flag = result_struct.cross_validation_flag;
		
		std_of_fr_av_of_attV=zeros(1,predefined_length);
		fr_sig_bounds_from_av_of_attV=zeros(2,predefined_length);
		std_of_fa_av_of_attV=zeros(1,predefined_length);
		std_of_fa_av_of_att_approxV=zeros(1,predefined_length);
		fa_sig_bounds_from_av_of_attV=zeros(2,predefined_length);

		for th_index = 1:length(borders_common)
			
			if (mod(th_index,100000)==0),
				disp([ 'iteration ' num2str(th_index)]);
			end
			current_model = model_info_common(th_index);
			current_type = type_common(th_index); % 1=FR, 0=FA;
			
			sub_absolute_model_index = find( current_model ==  str2num(char(included_models)));
			if (current_type == 1),
				% FR
				fr_hits_vector(sub_absolute_model_index) = fr_hits_vector(sub_absolute_model_index) + 1;
			else
				% FA
				if (~full_speaker_info_flag),
					current_speaker = speaker_info_common(th_index);
				else
					current_speaker = str2num(char(speaker_info_common(th_index,1:4)));
				end

				sub_absolute_imp_index = find(current_speaker == str2num(char(included_models)));
				fa_hits_infavour_imp_array(sub_absolute_model_index, sub_absolute_imp_index) = fa_hits_infavour_imp_array(sub_absolute_model_index, sub_absolute_imp_index) - 1;
			end
			
			
			if ( (th_index == 1) | (mod(th_index,sub_sampling_ci)==0) | (th_index==length(borders_common)) ),
			%if (0)
				% fr, multiple attempts per volunteer, each attempt equal weight
				% according 6.2.2, Biometric, Testing Best Practices
				
				thresholds_V(vector_counter) = borders_common(th_index);
				
				[fr_av_of_att, std_of_fr_av_of_att, fr_sig_bounds_from_av_of_att] = get_best_pract_fr_var(z_scale, fr_hits_vector, fr_N_tests_vector, ext_model_info, included_models, imp_spks_list);
				
				fr_av_of_attV(vector_counter) = fr_av_of_att;
				std_of_fr_av_of_attV(vector_counter) = std_of_fr_av_of_att;
				fr_sig_bounds_from_av_of_attV(:,vector_counter) = fr_sig_bounds_from_av_of_att';
				
				
				
				% fa, multiple attempts per volunteer, each attempt equal weight
				% according 6.3, Biometric, Testing Best Practices
				% only for cross-evaluation ( n-1 impostors with one client )
				% try to look also for formula for seperate impostor set ...				
				
				[std_of_fa_av_of_att, std_of_fa_av_of_att_approx, fa_sig_bounds_from_av_of_att, fa_av_of_att] = get_best_pract_fa_var(z_scale, fa_N_tests_vector, N_imp_spks_per_model, fa_hits_infavour_imp_array, ext_model_info, included_models, imp_spks_list);
				
				
				fa_av_of_attV(vector_counter) = fa_av_of_att;
				std_of_fa_av_of_attV(vector_counter) = std_of_fa_av_of_att;
				std_of_fa_av_of_att_approxV(vector_counter) = std_of_fa_av_of_att_approx;
				fa_sig_bounds_from_av_of_attV(:,vector_counter) = fa_sig_bounds_from_av_of_att';

				vector_counter = vector_counter + 1;

			end
		end
	
	else

		
		for i=1:num_of_models,
			absolute_index = strmatch(included_models(i), ext_model_info.trained_models,'exact');
			sub_absolute_index = i;
			current_speaker = included_models{i};
			imp_spks_names = get_imp_speakers(imp_spks_list, {current_speaker}, result_struct.model_info, result_struct.FA_struct{absolute_index}.imp_test_spks);
			
			spk_info_array = result_struct.FA_struct{absolute_index}.data.rec_info(FA_rec_indizes{i},:);
			spk_info_array = spk_info_array(:,1:4); 
			for j = 1:length(imp_spks_names)
				current_imp_spk = imp_spks_names(j);
				sub_absolute_imp_index = strmatch(current_imp_spk, ext_model_info.imp_test_spks,'exact');
				fa_N_tests_array(sub_absolute_index, sub_absolute_imp_index) = length(strmatch( current_imp_spk, spk_info_array ));
			end
		end
		fa_hits_infavour_imp_array = fa_N_tests_array;

		for th_index = 1:length(borders_common)
			
			if (mod(th_index,100000)==0),
				disp([ 'iteration ' num2str(th_index)]);
			end
			current_model = model_info_common(th_index);
			current_type = type_common(th_index); % 1=FR, 0=FA;
			
			sub_absolute_model_index = find( current_model ==  str2num(char(included_models)));
			if (current_type == 1),
				% FR
				fr_hits_vector(sub_absolute_model_index) = fr_hits_vector(sub_absolute_model_index) + 1;
			else
				% FA
				if (~full_speaker_info_flag),
					current_speaker = speaker_info_common(th_index);
				else
					current_speaker = str2num(char(speaker_info_common(th_index,1:4)));
				end

				sub_absolute_imp_index = find(current_speaker == str2num(char(ext_model_info.imp_test_spks)));
				fa_hits_infavour_imp_array(sub_absolute_model_index, sub_absolute_imp_index) = fa_hits_infavour_imp_array(sub_absolute_model_index, sub_absolute_imp_index) - 1;
			end
			
			
			if ( (th_index == 1) | (mod(th_index,sub_sampling_ci)==0) | (th_index==length(borders_common)) ),
				
				thresholds_V(vector_counter) = borders_common(th_index);
				
				fr_av_of_att = sum(fr_hits_vector) / sum(fr_N_tests_vector) * 100;
				fr_av_of_attV(vector_counter) = fr_av_of_att;
				
				
				fa_hits_vector = (sum(fa_hits_infavour_imp_array,2))';
				fa_av_of_att = sum(fa_hits_vector) / sum(fa_N_tests_vector) * 100;
				fa_av_of_attV(vector_counter) = fa_av_of_att;


				vector_counter = vector_counter + 1;

			end
		end
		
	end
	
	
	
	
	
	FR = single(FR);
	FA = single(FA);
	borders_common = single(borders_common);
	
	score_result_struct.part{part_index}.data = struct('FRs',FR,'FAs', FA, 'borders_common', borders_common);
	score_result_struct.part{part_index}.data.imp_spks_list = imp_spks_list;
	score_result_struct.part{part_index}.data.speaker_info_common = speaker_info_common;
	score_result_struct.part{part_index}.data.model_info_common = model_info_common;
	score_result_struct.part{part_index}.data.type_common = type_common;
	
	
	score_result_struct.part{part_index}.data.fr_av_of_att = fr_av_of_attV;
	score_result_struct.part{part_index}.data.fa_av_of_att = fa_av_of_attV;
	
	
	if (isfield(result_struct,'cross_validation_flag') & (result_struct.cross_validation_flag)),
	
		score_result_struct.part{part_index}.data.std_of_fr_av_of_att = std_of_fr_av_of_attV;
		score_result_struct.part{part_index}.data.fr_sig_bounds_from_av_of_att = fr_sig_bounds_from_av_of_attV;
		
		score_result_struct.part{part_index}.data.std_of_fa_av_of_att = std_of_fa_av_of_attV;
		score_result_struct.part{part_index}.data.std_of_fa_av_of_att_approx = std_of_fa_av_of_att_approxV;
		score_result_struct.part{part_index}.data.fa_sig_bounds_from_av_of_att = fa_sig_bounds_from_av_of_attV;
		score_result_struct.part{part_index}.data.thresholds = thresholds_V;
		score_result_struct.part{part_index}.data.fa_N_tests_array = fa_N_tests_array;
	end
	

