function score_result_struct = calc_score_result_fra_part(score_result_struct, part_index, result_struct, ext_model_info, included_models, imp_spks_list, fr_sel_sessions, fa_sel_sessions)
% function score_result_struct = calc_score_result_fra_part(score_result_struct, 
%                                 part_index, result_struct, ext_model_info, 
%                                 included_models, imp_spks_list, fr_sel_sessions, fa_sel_sessions)
%
% CVS_Version_String = '$Id: calc_score_result_fra_part.m,v 1.10 2004/06/01 08:27:09 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	score_result_struct.part{part_index}.result_type = 'fr_fa';

	num_of_models = length(included_models);

	[male_indizes, female_indizes]	= get_gender_indizes(included_models, ext_model_info);

	disp('Calculating fr rates ...');	
	for i=1:num_of_models
		absolute_index = strmatch(included_models(i), ext_model_info.trained_models,'exact');
		current_speaker = result_struct.FR_struct{absolute_index}.model_name;
		imp_spks_names = get_imp_speakers(imp_spks_list, {current_speaker}, result_struct.model_info, result_struct.FA_struct{absolute_index}.imp_test_spks);

		FR_rec_indizes = find_sessions_in_F_struct(result_struct.FR_struct{absolute_index}, fr_sel_sessions, {'all'}, ext_model_info);
		FA_rec_indizes = find_sessions_in_F_struct(result_struct.FA_struct{absolute_index}, fa_sel_sessions, imp_spks_names, ext_model_info);
		session_filtered_FA_struct.data.borders = result_struct.FA_struct{absolute_index}.data.borders(FA_rec_indizes);
		session_filtered_FR_struct.data.borders = result_struct.FR_struct{absolute_index}.data.borders(FR_rec_indizes);
		[fa, fa_coarse, fr, fr_coarse, fa_hits, fr_hits, fa_N_tests, fr_N_tests] = calc_FR_FA_coarse(session_filtered_FR_struct.data,session_filtered_FA_struct.data, score_result_struct.part{part_index}.model(i).data.threshold);
		score_result_struct.part{part_index}.model(i).data.fr=fr_coarse;
		score_result_struct.part{part_index}.model(i).data.fr_hits=fr_hits;
		score_result_struct.part{part_index}.model(i).data.fr_N_tests=fr_N_tests;
		
		score_result_struct.part{part_index}.model(i).data.fa=fa_coarse;
		score_result_struct.part{part_index}.model(i).data.fa_hits=fa_hits;
		score_result_struct.part{part_index}.model(i).data.fa_N_tests=fa_N_tests;
		
		score_result_struct.part{part_index}.model(i).model_name=result_struct.FR_struct{absolute_index}.model_name;
	end
	
	fr_vector = get_nested_field(score_result_struct.part{part_index}.model,'data.fr');
	score_result_struct.part{part_index}.parameters.fr_mean = mean(fr_vector);


	score_result_struct.part{part_index}.parameters.fr_male_mean = mean(fr_vector(male_indizes));
	score_result_struct.part{part_index}.parameters.fr_female_mean = mean(fr_vector(female_indizes));
	score_result_struct.part{part_index}.parameters.fr_gender_balanced_mean = mean([score_result_struct.part{part_index}.parameters.fr_male_mean score_result_struct.part{part_index}.parameters.fr_female_mean]);
	
	sum_fr_hits = sum(get_nested_field(score_result_struct.part{part_index}.model,'data.fr_hits'));
	score_result_struct.part{part_index}.parameters.fr_hits = sum_fr_hits;
	
	sum_fr_N_tests = sum(get_nested_field(score_result_struct.part{part_index}.model,'data.fr_N_tests'));
	score_result_struct.part{part_index}.parameters.fr_N_tests = sum_fr_N_tests;
	
	sum_fa_hits = sum(get_nested_field(score_result_struct.part{part_index}.model,'data.fa_hits'));
	score_result_struct.part{part_index}.parameters.fa_hits = sum_fa_hits;
	
	sum_fa_N_tests = sum(get_nested_field(score_result_struct.part{part_index}.model,'data.fa_N_tests'));
	score_result_struct.part{part_index}.parameters.fa_N_tests = sum_fa_N_tests;
		
