function [p_struct, varargout]=count_cdf_with_borders(X,varargin)
% function [p_struct, [sorted_indizes]=count_cdf_with_borders(X,[infostring_cellarray])
%
% Gives the sorted values of vector X in the field 
% borders.
% With the optional argument, the cell_array is reordered according to
% the sort of the values in X. The sorted infostrings (if available) 
% are pasted in the field "rec_info".
%
% CVS_Version_String = '$Id: count_cdf_with_borders.m,v 1.6 2004/02/10 22:10:42 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



[sorted_X, index_sort]=sort(X);
%[sorted_and_unique_X,index_unique1, index_unique2]=unique(sorted_X);

if (nargin == 2)
	recs = varargin{1};
	recs_sorted = recs(index_sort,:);

end



p_struct.borders = sorted_X;
if (nargin == 2)
	p_struct.rec_info = recs_sorted;	
end

if (nargout == 2)
	varargout{1} = index_sort;
end
