function sample_pop=draw_bst_samples_from_pop( pop, sample_size )
% functions sample_pop = draw_bst_samples_from_pop( pop, sample_size )
% draw with replacement.
% 
% CVS_Version_String = '$Id: draw_bst_samples_from_pop.m,v 1.3 2004/06/01 10:22:02 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	
	rnd_indizes = floor(rand(1,sample_size) * length(pop)) + 1;
	ind = find( rnd_indizes > length(pop));
	rnd_indizes(ind) = length(pop);
	
	sample_pop = pop(rnd_indizes);
	
