function draw_force_aligned_borders(mlf_struct, rec_info)
% function draw_force_aligned_borders(mlf_struct, rec_info)
%
% CVS_Version_String = '$Id: draw_force_aligned_borders.m,v 1.8 2004/02/16 10:11:15 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

	old_handles = findobj(gcf,'Tag','force_aligned_borders');
	delete(old_handles);
	
	file_length = double(mlf_struct.end_time);
	total_length_x = 360;
	frame_begin_x = 0;
	corr = 0;
	
	for i=1:length(mlf_struct.start_vector),
		corr_flag = 0;
		double(mlf_struct.phoneme_vector(i));
		phoneme = translate_model_short_label(double(mlf_struct.phoneme_vector(i)));
		%phoneme = mlf_struct.phoneme_vector{i};
		frame_color=get_frame_color(phoneme);
		
		frame_begin = double(mlf_struct.start_vector(i));
		if (i == length(mlf_struct.start_vector)),
			frame_end = double(mlf_struct.end_time);
		else
			frame_end = double(mlf_struct.start_vector(i+1));
		end	
		
		frame_begin_x = frame_begin / file_length * total_length_x;
				
		frame_length_x = (frame_end - frame_begin )/ file_length * total_length_x;
		
		if (frame_length_x < 5)
			diff_length = 5 - frame_length_x;
			frame_length_x = 5;
			corr_flag = 1;
		else
			corr_flag = 0;
		end
		
		label = [translate_model_short_label(double(mlf_struct.phoneme_vector(i))) ';  start: ' num2str(frame_begin*10) 'ms ; end: ' num2str(frame_end*10) 'ms'];
		if (isfield(mlf_struct, 'llh_values')),
			label = [label '; llh: ' num2str(double(mlf_struct.llh_values(i)))];
		end
		ud.start = frame_begin*10;
		ud.end = frame_end*10;
		ud.rec_info = rec_info(1,:);
		
		uicontrol('Parent',gcf, ...
			'Units','points', ...
			'BackgroundColor',frame_color, ...
			'Position',[80+frame_begin_x+corr 5 frame_length_x 10], ...
			'TooltipString',label, ...
			'Tag','force_aligned_borders', ...
			'Style','frame');

		if ((ud.end - ud.start) > 0)
			uicontrol('Parent',gcf, ...
			'Units','points', ...
			'BackgroundColor',frame_color, ...
			'Position',[80+frame_begin_x+corr 0 frame_length_x 5], ...
			'Tag','force_aligned_borders', ...
			'UserData',ud, ...
			'Callback','Plot_SR_parameters_Callback(''play part'')', ...
			'Style','pushbutton');
		end
		
		if (corr_flag),
			corr = corr + diff_length;
		end
	end
return;
	
	% private
	
	function color = get_frame_color(phoneme)
		
		get_model_translation;

		color = [];
		for i=1:length(translation_table_labels),
			if (strcmp(translation_table_labels(i).model_name, phoneme)),
				color = translation_table_labels(i).color;
				break;
			end
		end
		if (isempty(color)),
			color = [0 1 1];
		end
		
	return;
	
