function new_F_struct = filter_F_struct(F_struct,model,session)
% function new_F_struct = filter_F_struct(F_struct,model,session)
%
% CVS_Version_String = '$Id: filter_F_struct.m,v 1.6 2004/02/10 22:10:42 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################




	if ~(nargin == 3)
		error('filter_F_struct: wrong number of input parameters');
	end
	
	new_entry_counter = 1;
	for i = 1:length(F_struct.data.borders)
		
		rec_info = F_struct.data.rec_info(i,:);
		model_info = rec_info(1:4);
		session_info = rec_info(6:7);
		if strcmp(model,'all') | sum(strcmp(model_info,model)),
			
			if strcmp(session,'all') | sum(strcmp(session,session_info)),
			
				new_F_struct.data.borders(new_entry_counter) = F_struct.data.borders(i);
				new_F_struct.data.rec_info(new_entry_counter,:) = F_struct.data.rec_info(i,:);
				if (isfield(F_struct.data, 'mlf_data')),
					new_F_struct.data.mlf_data(new_entry_counter) = F_struct.data.mlf_data(i); 
				end
				new_entry_counter = new_entry_counter + 1;
			end
		
		end
	
	
	end
	
	new_F_struct.model_name = F_struct.model_name;
	