function [fa, fa_coarse, fa_hits, N_tests] = find_FA_coarse(FA_struct_data, threshold, interpl_flag)
% 	function [fa, fa_coarse, fa_hits, N_tests] = find_FA_coarse(FA_struct_data, threshold, interpl_flag)
%
%
% CVS_Version_String = '$Id: find_FA_coarse.m,v 1.8 2004/05/06 13:40:20 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	FA_borders = [ FA_struct_data.borders ];
	N_tests = length(FA_borders);
	
	% order of polyfit
	interpl_order_FA = 5;

	% find coarse intersection point
	index_near_FA = max(find((FA_borders - threshold) < 0));
	fa_hits = length(find((FA_borders > threshold)));

	if  isempty(index_near_FA),
		% threshold below left edge of  FA border values
		fa = 100;
		fa_coarse = 100;
		return;
	end

	if (index_near_FA == N_tests)
		% threshold above right edge of FA border values
		fa = 0;
		fa_coarse = 0;
		return;
	end
	

	probabilities_fa = (1:N_tests) / N_tests * 100;
	probabilities_fa = [(100 - probabilities_fa)];


	fa_coarse = probabilities_fa(index_near_FA);
	
	if (strcmp(interpl_flag, 'no_interpolation')),
		fa = -1;
	else
		if (strcmp(interpl_flag, 'lin_interpolation')),
			index_sub_low = max([1 (index_near_FA) ]);
			index_sub_high = min([N_tests (index_near_FA + 1) ]);
		else
			index_sub_low = max([1 (index_near_FA - 3) ]);
			index_sub_high = min([N_tests (index_near_FA + 4) ]);
		end
		
		sub_FA_borders = FA_borders(index_sub_low:index_sub_high);
		sub_FA_prob = probabilities_fa(index_sub_low:index_sub_high);
		
		% interpolate
		if (strcmp(interpl_flag, 'lin_interpolation')),
			coeff_FA=polyfit(sub_FA_borders,sub_FA_prob,1);
		else
			coeff_FA=polyfit(sub_FA_borders,sub_FA_prob,interpl_order_FA);
		end
		
		% find intersection point, this time with interpolated values
		fa = polyval(coeff_FA,threshold);
		
	end


