function [fr_av_of_attempts, std_of_fr_av_of_attempts, fr_sig_bounds_from_av_of_attempts] = get_best_pract_fr_var(z_scale, fr_hits_vector, fr_N_tests_vector, ext_model_info, models, imp_spks_list)
% function [fr_av_of_attempts, std_of_fr_av_of_attempts, fr_sig_bounds_from_av_of_attempts] 
%                                = get_best_pract_fr_var(z_scale, fr_hits_vector, fr_N_tests_vector
%                                  ext_model_info, models, imp_spks_list)
%
% fr, multiple attempts per volunteer, each attempt equal weight
% according 6.2.2, Biometric, Testing Best Practices
%
% CVS_Version_String = '$Id: get_best_pract_fr_var.m,v 1.4 2004/05/19 08:50:54 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

	[male_indizes, female_indizes]	= get_gender_indizes(models, ext_model_info);

	if (isequal({'same gender'}, imp_spks_list)),
		result_type = 'same gender';
	else
		result_type = 'normal';
	end
	
	% !!!!!!!!!!
	% deactivated seperate comp. for fr!
	result_type = 'normal';
	
	
	
	switch (result_type),
		case {'same gender'}

			fr_hits_vector_m = fr_hits_vector(male_indizes);
			fr_hits_vector_f = fr_hits_vector(female_indizes);
			fr_N_tests_vector_m = fr_N_tests_vector(male_indizes);
			fr_N_tests_vector_f = fr_N_tests_vector(female_indizes);
			
			
			[fr_av_m, var_fr_m] = calc_var_fr(fr_hits_vector_m, fr_N_tests_vector_m);
			[fr_av_f, var_fr_f] = calc_var_fr(fr_hits_vector_f, fr_N_tests_vector_f);
		
			weight_m = 0.5;
			weight_f = 0.5;
			
			fr_av = weight_m * fr_av_m + weight_f * fr_av_f;
			var_fr = weight_m^2 * var_fr_m + weight_f^2 * var_fr_f;
			
			
			
		otherwise
		
			[fr_av, var_fr] = calc_var_fr(fr_hits_vector, fr_N_tests_vector);
			
	end
	
	
	
	% scale output results by 100 -> percent
	std_of_fr_av_of_attempts = sqrt(var_fr) * 100;
	fr_sig_bounds_from_av_of_attempts = [ (fr_av - z_scale * sqrt(var_fr))  (fr_av + z_scale * sqrt(var_fr))] * 100;
	fr_av_of_attempts = fr_av * 100;
	
return;
	
	
	
	function [fr_av, var_fr] = calc_var_fr(fr_hits_vector, fr_N_tests_vector)
	
		num_of_models = length(fr_hits_vector);

		sum_fr_hits = sum(fr_hits_vector);
		sum_fr_N_tests = sum(fr_N_tests_vector);
		fr_av = sum_fr_hits / sum_fr_N_tests;
		
		av_fr_N_tests = sum_fr_N_tests / num_of_models;
		
		fr_vector = fr_hits_vector ./ fr_N_tests_vector;
		var_fr = sum( (fr_N_tests_vector .* (fr_vector - fr_av) ).^2 ) / ( (av_fr_N_tests^2) * num_of_models * (num_of_models - 1));
	
	return;
