function [score_result_struct, sorted_dets] = get_conf_int_bootstrap_det( result_name, alpha )
% function score_result_struct, [sorted_dets] = get_conf_int_bootstrap_det( result_name, alpha )
%
% CVS_Version_String = '$Id: get_conf_int_bootstrap_det.m,v 1.10 2004/05/25 11:36:48 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

	sorted_dets.frs = [];
	sorted_dets.fas = [];
	if (nargout > 1 ),
		store_sorted_dets = 1;
	else
		store_sorted_dets = 0;
	end
	
	bs_id = '_bs_det_';
	
	%upper_det, lower_det, alpha

	name_base = [ result_name bs_id ];
	name_search = [ '*' name_base '*' ];

	d = dir( name_search );
	
	th_max=[];
	th_min=[];
	
	for result_index = 1:length(d),
		
		id_indizes = findstr( d(result_index).name , '_score.mat');
		score_result_name = d(result_index).name(1:id_indizes - 1);
		sr=load_score_result( score_result_name, pwd);
		
		FRs{result_index} = sr.part{1}.data.fr_av_of_att;
		FAs{result_index} = sr.part{1}.data.fa_av_of_att;
		th{result_index} = sr.part{1}.data.thresholds;
		th_min(result_index) = min(th{result_index});
		th_max(result_index) = max(th{result_index});
	
	end
	
	total_max = min(th_max); % lowest max th
	total_min = max(th_min); % highest min th
	
	new_ths = linspace(total_min, total_max, 1000);
	
	index_low = round(length(FRs) / 100 * alpha / 2);
	if (index_low == 0),
		index_low = 1;
	end
	index_high = round(length(FRs) / 100 * (100 - alpha / 2));
	
	index_median = round( length(FRs) / 2 );
	
	% alt. method, consumes more memory
	for j = 1:length(FRs),
		frs_i(j,:) = interp1(th{j}, FRs{j}, new_ths, 'linear');
		fas_i(j,:) = interp1(th{j}, FAs{j}, new_ths, 'linear');
	end
	
	progress_total = length(new_ths);
	progress_sub = round(progress_total / 20);
	
	for th_i = 1:length(new_ths),
		
		if ( mod(th_i, progress_sub) == 0),
			disp( [ 'Current th-index ' num2str(th_i) ' out of ' num2str(progress_total)]);
		end
		
		%current_th = new_ths(th_i);
		
		%new_frs = zeros(1,length(FRs));
		%new_fas = zeros(1,length(FRs));
		
		%for j = 1:length(FRs),
		%	new_frs(j) = interp1(th{j}, FRs{j}, current_th, 'linear');
		%	new_fas(j) = interp1(th{j}, FAs{j}, current_th, 'linear');
		%end
		% alt. method
		new_frs=sort( frs_i(:,th_i));
		new_fas=sort( fas_i(:,th_i));
		
		if (store_sorted_dets),
			sorted_dets.frs(:,th_i) = new_frs;
			sorted_dets.fas(:,th_i) = new_fas;
		end
		
		%new_frs = sort(new_frs);
		%new_fas = sort(new_fas);
		
		
		fr_conf_int(:,th_i) = [ new_frs(index_low); new_frs(index_high) ] ;
		fa_conf_int(:,th_i) = [ new_fas(index_low); new_fas(index_high) ] ;
		
		median_fr(th_i) = new_frs(index_median);
		median_fa(th_i) = new_fas(index_median);
		
	end
	
	score_result_struct=struct('exp_name','','result_name','');
	
	% use last loaded sr as basis
	score_result_struct.exp_name = sr.exp_name;
	score_result_struct.result_name = [ name_base( length(sr.exp_name)+1+1:end) 'results_with_alpha_' num2str(alpha)];
	score_result_struct.full_name = [score_result_struct.exp_name '-' score_result_struct.result_name];
	if isfield(sr, 'info'),
		score_result_struct.info = sr.info;
	end
	score_result_struct.part = {};

	menu_descr = ['btstrp rslts,alpha=' num2str(alpha)];
	description = [menu_descr '; results from ' num2str(length(d)) ' bootstrap samples,  each containing ' num2str(length(sr.part{1}.model))  ' speakers'];
	
	part_index = 1;
	score_result_struct.part{part_index}.menu_descr = menu_descr;
	score_result_struct.part{part_index}.description = description;
	score_result_struct.part{part_index}.cross_validation_flag = sr.part{1}.cross_validation_flag;
	score_result_struct.part{part_index}.result_type = 'det_bs';
	
	score_result_struct.part{part_index}.data.alpha = alpha;
	score_result_struct.part{part_index}.data.fr_av_of_att = median_fr;
	score_result_struct.part{part_index}.data.fr_sig_bounds_from_av_of_att = fr_conf_int;
	
	score_result_struct.part{part_index}.data.fa_av_of_att = median_fa;
	score_result_struct.part{part_index}.data.fa_sig_bounds_from_av_of_att = fa_conf_int;
	score_result_struct.part{part_index}.data.thresholds = new_ths;
	
	score_result_struct.part{part_index}.info = description;
	
	score_result_struct.part{part_index}.imp_spks_list = sr.part{1}.imp_spks_list;
	score_result_struct.part{part_index}.fr_sel_sessions = sr.part{1}.fr_sel_sessions;
	score_result_struct.part{part_index}.fa_sel_sessions = sr.part{1}.fa_sel_sessions;
	
	return;
	
