function coeff = linear_cepstrum(frame, Fs, numChans, numCeps, lin_fb_info)
% function coeff = linear_cepstrum(frame, Fs, numChans, numCeps, lin_fb_info)
%
% CVS_Version_String = '$Id: linear_cepstrum.m,v 1.2 2004/03/29 14:56:55 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

	
	fftSize = 2^(ceil(log2(length(frame))));
	
	SpecFrame = fft(frame,fftSize);
	fbank = lin_fb_info * ((abs(SpecFrame(1:(1+floor(fftSize/2)))))');
	
	log_fbank = log( max( [ ones(length(fbank),1)  fbank ], [], 2 ) );
	
	
	coeff=dct(log_fbank);
	coeff=coeff(2:(numCeps+1));

return;


