function [score_struct, found_result] = load_score_struct(name, varargin)
% function [score_struct, found_result] = load_score_struct(name, [path])
%
% CVS_Version_String = '$Id: load_score_struct.m,v 1.6 2004/02/10 10:51:28 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	SR_lib;

	seperator_indizes = findstr('-',name);
	if (length(seperator_indizes) > 1),
		error(['load_score_struct: more than one dash in result filename!']);
	end
	exp_name = name(1:seperator_indizes(1)-1);
	result_name = name(seperator_indizes(1)+1:end);
	
	
	if (nargin == 2)
		result_filename = strcat(name,'_single_score_struct.mat');
		result_path = varargin{1};
	end
	if (nargin == 1)
		result_filename = strcat(name,'_single_score_struct.mat');
		result_path = fullfile(basepath, 'results');
	end

	result_info_filename =  strcat(name,'.info');
	
	found_result = 0;
	dir_struct = dir(result_path);
	for i=1:length(dir_struct),
		if (strcmp(result_filename, dir_struct(i).name)),
			result_date = dir_struct(i).date;
			found_result = 1;
			break;
		end
	end

	if (found_result)
		disp([result_filename]);
		disp(['found matching _single_score_struct.mat file from ' result_date]);
		load(fullfile(result_path,result_filename));
		disp('loading done.');
	else
		score_struct = [];
		return;
	end
	
	score_struct.exp_name = exp_name;
	score_struct.result_name = result_name;
	score_struct.full_name = [exp_name '-' result_name];
