function feature_set_struct=read_feature_set( filename)
% feature_set_struct=read_feature_set( filename)
%
% CVS_Version_String = '$Id: read_feature_set.m,v 1.1 2004/03/31 21:34:27 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	
	line_array=textread(filename,'%s','delimiter','\n','whitespace','');

	total_lines = length(line_array);

	set_counter = 1;
	for i=1:total_lines,
		
		theLine = line_array{i};
		tempLine = theLine(end:-1:1); % reverse string
		deblank(tempLine);
		tempLine = tempLine(end:-1:1); % reverse string
		if ( ( ~isempty(findstr(tempLine,'#')) ) & ( findstr(tempLine,'#')== 1) ),
			% do nothing
		else
			% remove comment
			if ( ~isempty(findstr(tempLine,'#'))),
				hash_ind = findstr(tempLine,'#');
				tempLine = tempLine(1:hash_ind(1));
			end
			tempLine = deblank(tempLine);
			tab_indizes = findstr(tempLine,char(9));
			
			if (~isempty(tab_indizes)),
				field1 = tempLine(1:tab_indizes(1)-1);
				d_i = diff(tab_indizes);
				step_i = find(d_i > 1);
				field_starts=tab_indizes(step_i) + 1;
				field_ends=tab_indizes(step_i+1) - 1;
				if (length(field_ends) ~= 1),
					error([mfilename ': need three by tab(s) seperated fields']);
				end
				field2=tempLine(field_starts(1):field_ends(1));
				field3=tempLine(tab_indizes(end)+1:end);
				
				if (strcmp(field2,'all')),
					%do nothing
				else
					field2 = (sscanf(field2,'%d,'))';
				end
				if (strcmp(field3,'none')),
					%do nothing
				else
					field3 = (sscanf(field3,'%d,'))';
				end
				
				feature_set_struct(set_counter)=struct('feature_set_name', field1, 'include_list', field2, 'exclude_list', field3);
				set_counter = set_counter + 1;
			end
			
		end	
	
	end
