function state_seq_struct=read_stateSeq( filename)
% state_seq_struct=read_stateSeq( filename)
%
% CVS_Version_String = '$Id: read_stateSeq.m,v 1.2 2004/04/13 16:40:52 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	
	line_array=textread(filename,'%s','delimiter','\n','whitespace','');

	total_lines = length(line_array);

	
	for line = 1:total_lines,

		tmp_line = line_array{line};
		
		fields = split_str_by_character( tmp_line, ' ');
		if (length(fields) ~= 7),
			error( [mfilename ': expected seven entries per line in state seq file ' filename '\n'] );
		end
		
		frame_num = line;
		model_name = fields{4};
		state_num = str2num(fields{6});
		llh = str2num(fields{7});
		
		state_seq_struct(frame_num) = struct('frame', frame_num, 'model', model_name, 'state', state_num, 'llh', llh);
		
		
	end % for line ...
	
	num_of_frames = length(state_seq_struct);
	temp_llh_vector = [state_seq_struct.llh];
	temp_llh_vector = temp_llh_vector .* (1:num_of_frames);
	new_llh_vector = [temp_llh_vector(1) diff(temp_llh_vector) ];
	
	for frame = 1:num_of_frames,
		state_seq_struct(frame).llh = new_llh_vector(frame);
	end

return;
	
	
	function string_cell = split_str_by_character( string, character )
		item_counter = 1;
		character_indizes = findstr( character, string );
		diff_indizes = diff( character_indizes );
		[dummy, steps] = find(diff_indizes > 1);
		start_indizes = [ 1 (character_indizes( steps ) + 1)  (character_indizes(end) + 1)];
		end_indizes = [ (character_indizes(1)-1) (character_indizes( steps+1 ) - 1 ) length(string)];
		
		for i=1:length(start_indizes),
			string_cell{i} = string(start_indizes(i):end_indizes(i));	
		end
		
	return;