function pool_config_struct = read_sv_system_paramPool_Info(sv_system_name)
% function pool_config_struct = read_sv_system_paramPool_Info(sv_system_name)
%
% CVS_Version_String = '$Id: read_sv_system_paramPool_Info.m,v 1.1 2004/02/13 13:27:56 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	SR_lib;
	

	info_filename = '';

	path_info_file = fullfile(basepath, sv_system_name, 'links', 'currentParamPool', 'configs');

	list_dir = dir(path_info_file);
	for i=1:length(list_dir),
		if ( (~isempty(findstr(list_dir(i).name, 'C_'))) & (sum(find(findstr(list_dir(i).name, 'C_') == 1) ))),
			info_filename = fullfile(path_info_file, list_dir(i).name);
			break;
		end
	end
	
	if (isempty(info_filename))
		disp('Warning [read_sv_system_paramPool_Info]: No PoolConfig file found!');
		pool_config_struct = '';
		return;
	end
	
	
	pool_config_struct = read_paramPool_config(info_filename);
	

