function show_dea( subject, session, recording)
% function show_dea( subject, session, recording)
%
% CVS_Version_String = '$Id: show_dea.m,v 1.8 2004/02/13 13:21:12 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	SR_lib;

	full_name = fullfile(rawdatapath, subject, session, recording);
	
	maxAmp = 4096;
	
	frame_shift = 80;
	frame_length = 200;
	
	%% read sound file
	wave_data = read_raw_alaw(full_name);
	wave_data =wave_data * 4096;
	%%	[wave_data,fs]=readwav(['/homes/tuerk/temp/Feature_test/' testfile],'rz');

	% read param pool config
	sv_system_name = 'LPCC_trAllAVSD';
	configName = 'C_smalltest_pool';
	
	%configFullPath = [basepath sv_system_name '/' 'poolConfig' '/' configName]; 
	configFullPath = ['/homes/tuerk/temp/Feature_test/' 'C_test'];
	
	pool_config = read_paramPool_config(configFullPath);


	[cut_wave_data, border_info, energy_db, SD_param] = HTK_SigP_SilenceDetection(wave_data, pool_config);

	

	
	
	
	spDetSt = border_info.spDetSt;
	spDetEn = border_info.spDetEn;
	

	figure_handle = figure;

	no_frames = length(energy_db);
	no_samples = length(wave_data);
	
	block_axis = ( ((1:no_frames) - 1) * frame_shift) + 1;
	plot(wave_data/200,'b');
	hold on;
	plot(block_axis,energy_db,'g');
	play_handle = uicontrol('Parent',figure_handle, ...
		'Units','points', ...
		'BackgroundColor',[1 1 1], ...
		'Position',[5 5 40 20], ...
		'String','Play', ...
		'Callback','wave_to_play = get(gcbo,''UserData'');sound(wave_to_play,8000)');

	set(play_handle,'UserData', (wave_data((spDetSt)*frame_shift + 1:(spDetEn * frame_shift + frame_shift -1)) ) / 32768);
	
	t_start = 1;
	t_end = no_samples;
	max_file = 120;
	
	st = SD_param.ml_thresh;
	
	lh=line([t_start t_end],[st st]); 
	set(lh,'Color','r','LineStyle','--');
	th=text(0.8*t_end, st+50, 'speech threshold');
	%lh=line([t_start t_end],[-st -st]); 
	%set(lh,'Color','r','LineStyle','--');
	%lh=line( ((1:no_frames)-1)*80, speech_frames * 0.08*max_file - 1.1*max_file);
	%set(lh,'Color','r');
	
	%lh=line( ((1:no_windows)-1)*80*pool_config_struct.spcSeqCount, windows * 0.08*max_file - 1.2*max_file);
	%set(lh,'Color','g');
	
	lh=line( ([spDetSt spDetSt] - 1) * frame_shift, [-1.1*max_file 1.1*max_file] );
	set(lh,'Color','y');
	
	lh=line( ([spDetEn spDetEn] - 1) * frame_shift, [-1.1*max_file 1.1*max_file] );
	set(lh,'Color','y');
	
	%line(-50, 0);
	
	
	frame_draw_offset = 0;
	
	
	for i=1:no_frames,
		f_start = (i-1)*frame_shift;
		f_end = f_start + frame_length;
		lh = line ([f_start f_start],[-0.02*max_file 0.02*max_file] + frame_draw_offset - 1.35 * max_file);
		set(lh,'Color','w');
		lh = line ([f_end f_end],[-0.02*max_file 0.02*max_file] + frame_draw_offset - 1.35 * max_file);
		set(lh,'Color','w');
		lh = line ([f_start f_end], [frame_draw_offset frame_draw_offset] - 1.35 * max_file);
		set(lh,'Color','w');
		
		frame_draw_offset = frame_draw_offset + 0.05*max_file;
		if (frame_draw_offset > 0.1*max_file)
			frame_draw_offset = 0;
		end
		
	end




