function play_sound_file_with_SD(subject, session, recording, model_info)
% function play_sound_file_with_SD(subject, session, recording, model_info)
%
% CVS_Version_String = '$Id: play_sound_file_with_SD.m,v 1.2 2004/04/13 10:48:51 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	SR_lib;

	full_name = fullfile(rawdatapath, subject, session, recording);
	
	rate=sampling_freq; % defined in MASV_db_desc.pm
	
	SD_config = model_info.paramPool_config;

	raw_lin = read_raw_alaw(full_name);
	raw_lin = raw_lin * 4096;
	if (SD_config.useSilDet),
		[raw_lin, SD_time_info] = HTK_SigP_SilenceDetection( raw_lin, SD_config);
	end
	
	if (strcmp(computer,'MAC'))
		sound(raw_lin/4096,rate,8);
	else
		if (exist('SD_time_info')),
			start_s = SD_time_info.spDetStart_samples;
			end_s = SD_time_info.spDetEnd_samples;
			part_length = end_s - start_s;
			[scriptpath 'play_sound_part_remote.sh ' full_name ' ' num2str(start_s) ' ' num2str(part_length)]
			unix([scriptpath 'play_sound_part_remote.sh ' full_name ' ' num2str(start_s) ' ' num2str(part_length)]);
		else
			unix([scriptpath 'play_sound_remote.sh ' full_name]);
		end
	end
