function ret = batch_process_results(path, pattern, command, withSave)
% function ret = batch_process_results(path, pattern, command, withSave)
%    use ret, rs (for Result_Struct) and sr (for Score_Result_Struct)
%    in the commands <command>.
%
% CVS_Version_String = '$Id: batch_process_results.m,v 1.6 2004/03/12 22:37:56 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

	temp_path = pwd;
	cd(path);
	
	d = dir(pattern);

	if (length(d) == 0),
		return;
	end

	names = {d.name};

	[f, score_index_cell_temp] = findstr_inCell('_score.mat',names);
	
	score_indizes = [];
	result_indizes = [];
	for i = 1:length(score_index_cell_temp),
		if (~(isempty(score_index_cell_temp{i}))),
			score_indizes = [score_indizes i];
		else
			result_indizes = [result_indizes i];
		end
	end
	
	if (~isempty(result_indizes)), 
		for i=1:length(result_indizes),
			result_name = names{result_indizes(i)};
			result_name = result_name(1:end-4);
			[rs,found] = load_result(result_name, pwd);
			if (~(found)),
				error(['result file not found: ' result_name]);
			end	
			[sr,found] = load_score_result(result_name , pwd);
			if (~(found)),
				error(['score file not found: ' result_name]);
			end	
			eval(command);
			if (withSave),
				save_result(rs,pwd);
				save_score_result(sr,pwd);
			end
		end
	else
		for i=1:length(score_indizes),
			result_name = names{score_indizes(i)};
			result_name = result_name(1:end-10);
			[sr,found] = load_score_result(result_name, pwd);
			if (~(found)),
				error(['score result file not found: ' result_name]);
			end
			eval(command);
			if (withSave),
				save_score_result(sr,pwd);
			end
		end
	end
	
	cd(temp_path);

	if (exist('ret') & (~isempty(ret))),
		% do nothing
	else
		ret = [];
	end	
