#!/usr/bin/perl


# #####################################################
#
# This file is part of the Perl scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

my $CVS_Version_String = '$Id: archive_experiment.pl,v 1.4 2004/05/03 11:03:30 tuerk Exp $';
my $CVS_Name_String = '$Name: rel-1-4-01 $';


use lib $ENV{"MASV_PERL_ROOT"};

use SR_lib;
use strict;

use File::Copy;
use File::Path;
use Cwd;

use Getopt::Long qw( GetOptions );
use Pod::Usage;


my $exit_state = 0;


my $start_time = scalar localtime;

my $current_dir = cwd();

###########################
# Default values for options
my $help = 0;
my $log_file = '';
my $Identify = 0;
my $archive_dir = $current_dir;
my $archive_name = "";
###########################

# Processing Options
GetOptions('archive_name=s' => \$archive_name, 
	       'archive_directory=s' => \$archive_dir, 
	       'help|?' => \$help,
		   'logfile=s' => \$log_file,
           'version' => \$Identify);

if ($Identify) {
	print STDOUT "$0\n$CVS_Version_String\n$CVS_Name_String\n\n"; 
}


if ((@ARGV != 2) || ($help)) {
	pod2usage(1);
   exit 1;
}

if ($SR_lib::verbose_level) {print STDOUT "Running $0 ...\n";}



my $sv_system_name = $ARGV[0];
my $FA_id = $ARGV[1];

$archive_name = ($archive_name) ? $archive_name : ("model_archive_" . $FA_id . ".tar.bzip2");
my $archive_file = $archive_dir . $SR_lib::sign . $archive_name;



my $sv_system_path = "${SR_lib::sv_systems_dir}${sv_system_name}$SR_lib::sign";

chdir($sv_system_path);

&SR_lib::init_speaker_sets($sv_system_name);

my $client_model_info_file = $FA_id . "client_x_model.info";
my $world_model_info_file = $FA_id . "client_x_world.info";

my $client_model_list;
my $client_model_names_ref;
my $client_model_versions_ref;
($client_model_list, $client_model_names_ref, $client_model_versions_ref) = &read_info_file($client_model_info_file);

#printf "$client_model_list\n@{$client_model_names_ref}\n@{$client_model_versions_ref}\n";

my $world_model_list;
my $world_model_names_ref;
my $world_model_versions_ref;
($world_model_list, $world_model_names_ref, $world_model_versions_ref) = &read_info_file($world_model_info_file);
#printf "$world_model_list\n@{$world_model_names_ref}\n@{$world_model_versions_ref}\n";


my $trainedModelArrRef = &SR_lib::get_speakerArrRef($client_model_list);
my @clients = @{$trainedModelArrRef};

my $temp_list_for_tar = $archive_dir . $SR_lib::sign . "temp_list_for_tar.txt";
unlink $temp_list_for_tar;

foreach my $current_client (@clients) {
	foreach my $current_client_index (0 .. $#{$client_model_names_ref}) {
		$exit_state = system ("find ${current_client}/${$client_model_names_ref}[$current_client_index]/hmm.${$client_model_versions_ref}[$current_client_index]/* >> $temp_list_for_tar");
	}
}

foreach my $current_world_index (0 .. $#{$world_model_names_ref}) {
	$exit_state += system( "find world/${$world_model_names_ref}[$current_world_index]/hmm.${$world_model_versions_ref}[$current_world_index]/* >> $temp_list_for_tar");
}

$exit_state += system( "find links >> $temp_list_for_tar");

$exit_state += system( "find *.mlf -size -200k >> $temp_list_for_tar");

$exit_state += system("tar -cjf $archive_file -T $temp_list_for_tar");

unlink $temp_list_for_tar;







my $log_path = "${sv_system_path}log$SR_lib::sign";
$log_file = ($log_file) ? $log_file : "log.txt";

&SR_lib::check_and_create_dir($log_path);

my $log_handle = &SR_lib::open_file(">>", "$log_path" . "$log_file");
print $log_handle "\n\n";
print $log_handle "$start_time \n";
print $log_handle "Running archive_experiment.pl .....\n";
print $log_handle "---------------------------\n";
print $log_handle "Parameters:\n";
print $log_handle "sv_system_name    : $sv_system_name\n";
print $log_handle "FA_id             : $FA_id\n";
print $log_handle "Options:\n";
print $log_handle "archive_name      : $archive_name\n";
print $log_handle "archive_directory : $archive_dir\n";
print $log_handle "logfile           : $log_file\n";
print $log_handle "cvs_version       : $CVS_Version_String\n";
print $log_handle "cvs_name          : $CVS_Name_String\n";
print $log_handle "finishing ...";
print $log_handle scalar localtime, "\n";
if ($exit_state) {
	print $log_handle "\n Command failed !!!\n";
}

close $log_handle;
	
exit $exit_state;




sub read_info_file {
	
	my $info_filename;
	my $info_path;
	my $info_handle;
	my @info_content;
	
	my $return_model_list;
	#my $return_model_names_ref;
	#my $return_model_versions_ref;
	
	my (@model_names, @model_versions);
	
	
	($info_filename) = @_;

	$info_path = "${sv_system_path}${SR_lib::sign}info${SR_lib::sign}";
	
	
	$info_handle = &SR_lib::open_file("<", "$info_path" . "$info_filename");
		#print $info_handle "${ModelList}\n";
		#print $info_handle "$Sessions,${ModelVersion},${hmmBaseDir},${trainingSessions}\n";
	@info_content = <$info_handle>;
	close $info_handle;
	
	$return_model_list = $info_content[0];
	chomp($return_model_list);
	
	for my $model_counter (1 .. $#info_content) {
		my @temp_fields = split(/,/, $info_content[$model_counter]);
		push (@model_names, $temp_fields[2]);
		push (@model_versions, $temp_fields[1]);
	}
	
	return ($return_model_list, [@model_names], [@model_versions]);
}


__END__

=head1 NAME

archive_experiment.pl  - create gzip archive of models of an experiment

=head1 SYNOPSIS

archive_experiment.pl [options] sv_system_name FA_id


Archive model data of an experiment in <sv_system_name>. The data
is specified by the info files with the id <FA_id>.

 Options:

 -archive_name            name for the gzip archive;
                          default is the "model_archive_<FA_id>.tar.bzip2".

 -archive_directory       target directory for the gzip archive;
                          default is the current directory.

 -logfile                 set logfile; default is log/log.txt.

 -? | help                display this message.
 
=cut

