#!/bin/bash

# #####################################################
#
# This file is part of the Bash scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

# '$Id: batch_replace.sh,v 1.3 2003/11/11 12:16:34 tuerk Exp $';
# '$Name: rel-1-4-01 $';

if test $# -le 2 ; then
{
	echo Usage: batch_replace.sh [options] oldpath newpath file [more files]
	echo
	echo Options:
	echo '     greedy=true     replace all occurences in a line;'
	echo '                     default is false.'
	echo
	exit 1;
}
fi

greedy="false";
# Optionen
while test "$1" != "" ; do
{

	case "$1" in
	*=*) 
		key=`echo $1 | cut -d= -f1`
		val=`echo $1 | cut -d= -f2`
		
		if test $key == "greedy"; then
			eval "$key"=\'"$val"\'
			# echo $key=$val
			unset key val
		fi
		shift
		;;
        
	    *)  break
		;;
        esac
};
done

oldpattern=$1;
shift
newpattern=$1;
shift

if test $greedy == "true" ; then
	s_modifier="g";
else
	s_modifier="";
fi
	

while test "$1" != "" ; do
{
	sed -e "s#$oldpattern#$newpattern#$s_modifier" $1 > temp_file_batch_replace.sh
	mv temp_file_batch_replace.sh $1
	shift
};
done
