#!/usr/bin/perl


# #####################################################
#
# This file is part of the Perl scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

$CVS_Version_String = '$Id: change_entry_transitions_to_tee.pl,v 1.8 2004/02/17 15:36:39 tuerk Exp $';
$CVS_Name_String = '$Name: rel-1-4-01 $';


use lib $ENV{"MASV_PERL_ROOT"};

use SR_lib;

use File::Copy;
use File::Path;
use Getopt::Long qw( GetOptions );
use Pod::Usage;

my $help = 0;
my $Identify = 0;

GetOptions('help|?' => \$help,
			'version' => \$Identify);

if ($Identify) {
	printf "$0\n$CVS_Version_String\n$CVS_Name_String\n\n"; 
}


if ((@ARGV != 3) || ($help)) {
   pod2usage(1);
   exit 1;
 }
 

$sv_system_name = $ARGV[0];

$hmm_name = $ARGV[1];

$hmm_model = $ARGV[2];

$hmm_file_full_path = "${SR_lib::sv_systems_dir}${sv_system_name}/world/${hmm_name}/hmm.0/$hmm_model";

$exec_string = "awk -f ${SR_lib::source_scripts}change_entry_transitions_to_tee.awk $hmm_file_full_path > ${hmm_file_full_path}.temp; mv ${hmm_file_full_path}.temp $hmm_file_full_path";
$exit_state = system($exec_string);
#print $exec_string, "\n";

exit $exit_state;


__END__

=head1 NAME

change_entry_transitions_to_tee.pl  - corrects tee models after HCompV estimation

=head1 SYNOPSIS

change_entry_transitions_to_tee.pl sv_system_name hmm_base_dir hmm_model_name

Corrects tee models after "HCompV" estimation: it reactivates transitions 
from the non-emitting start state to the non-emitting end state. The model 
<hmm_model_name> is searched in the directory <hmm_base_dir>.

=cut

