#!/usr/bin/perl


# #####################################################
#
# This file is part of the Perl scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

my $CVS_Version_String = '$Id: create_S_list_stat.pl,v 1.6 2004/02/16 10:02:43 tuerk Exp $';
my $CVS_Name_String = '$Name: rel-1-4-01 $';


use lib $ENV{"MASV_PERL_ROOT"};

use SR_lib;
use strict;

use File::Copy;
use File::Path;
use Getopt::Long qw( GetOptions );
use Pod::Usage;


use vars qw(%label_StatisticHash $statistic_handle);
###########################

###########################
# Default values for options
my $help = 0;
my $Identify = 0;
###########################

%label_StatisticHash = ();



# Processing Options

GetOptions('help|?' => \$help,
           'version' => \$Identify);

if ($Identify) {
	printf "$0\n$CVS_Version_String\n$CVS_Name_String\n\n"; 
}

if ((@ARGV != 1) || ($help)) {
   pod2usage(1);
   exit 1;
 }

my $S_list_file = $ARGV[0];
###########################



my $fh = open_file("<", "$S_list_file");
my @S_list = <$fh>;
close $fh;

my $ses_labels_ref;

foreach my $element (@S_list) {

	$element =~ s/\.param$//;
	$element =~ s/\n//;
	my @parts = split(/\//, $element);
	my $speaker_dir = $parts[$#parts - 2];
	my $ses_dir = $parts[$#parts - 1];
	my $base_src_file = $parts[$#parts];
		
			
	my ($prompt_labels_ref, $ses_labels_ref) = &SR_lib::getLabels($SR_lib::source_trans_dir, $speaker_dir , $ses_dir , $base_src_file);
	&count_prompted_words($prompt_labels_ref);
			
}
				
$statistic_handle = &SR_lib::open_file(">","prompt_statistic_${S_list_file}.txt");
			
&writeStatisticFile;			
close $statistic_handle;


exit 0;
 



sub writeStatisticFile {
  	print $statistic_handle ("complete set:\n");
  	foreach my $word (keys(%label_StatisticHash)) {
  		print $statistic_handle ("${word}: $label_StatisticHash{$word}\n");
  	}
}


sub count_prompted_words {
#############################################
# individuelle Statistik erstellen
#############################################
	my ($prompt_labels_ref) = @_;
	
	foreach (@$prompt_labels_ref) {
		foreach my $word (@{&MASV_db_desc::convert_prompt_string($_)}) {
			$label_StatisticHash{$word}++;						
		}
	} # end of foreach (@$prompt_labels_ref)

}








__END__

=head1 NAME

create_S_list_stat.pl  - create statistic file for given S_list file

=head1 SYNOPSIS

create_S_list_stat.pl [options] S_list_file


 Options:

 -? | help                display this message.
 
=cut

