#!/bin/bash

ROOTDIR=$1;
FILEPATTERN=$2;
COMMAND=$3;

if test $# != 3
then
	echo
	echo Usage: iterate_command.sh rootdir filepattern command
	echo 
	echo example: 
	echo '  iterate_command.sh /raid/tera6/VERIDAT/paramPool/LPCC_SD_no_lifter/'
	echo -n "   erster_test/0001/ '*.vq_seg' 'ls "
	echo -n '${filebase}'
	echo ".vq_seg'"
	exit 1
fi


cd $ROOTDIR;

files=(`find . -name $FILEPATTERN`);

for file in ${files[@]}
do
	echo processing file $file ...
	filebase=`echo $file | sed -e 's/\.[^\.]*$//'`
	eval $COMMAND

done	
