#!/usr/bin/perl


# #####################################################
#
# This file is part of the Perl scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

my $CVS_Version_String = '$Id: make_clean_MASV_experiment.pl,v 1.6 2004/05/04 08:35:10 tuerk Exp $';
my $CVS_Name_String = '$Name: rel-1-4-01 $';


use lib $ENV{"MASV_PERL_ROOT"};

use SR_lib;
use strict;

use File::Copy;
use File::Path;
use Cwd;
use Getopt::Long qw( GetOptions );
use Pod::Usage;

my $exit_state = 0;

my ($minVar, $makeCohortNorm, $num_iterations_world, $num_iterations_model, $hmm_list, $dict,
	$doHNorm, $useHEAdapt, @teeModels, $numbernetWorldTest, $mlf_training, $mlf_test, @trainingModelConf,
	@HViteTrainedModelConf, @HViteWorldConf, @HViteCrossTestConf, $seed_world, $seed_models,
	@world_list, @world_test_list, $protoDir, @hmmBaseDirWorld, @hmmBaseDirModel,
	$hmm_version_model_test, $hmm_version_world_test, $hmm_version_cohort_test,
	$parallelComputation, $createdScript, $FA_id, $startMatlab, $pathMatlabResults,
	$autoClean_FA_Files, $useGMM, $mixtures, $doTestsOnly);


###########################
# Default values for options
my $help = 0;
my $Identify = 0;

my $cleanAll = 0;
my $cleanModels = 0;
my $thoroughly = 0;

$makeCohortNorm=0;
@HViteTrainedModelConf = "all_training/aa";
@HViteWorldConf = "all/aa";
@hmmBaseDirWorld = "hmm";
@hmmBaseDirModel = "hmm";
$useGMM = 0;
$FA_id = "";

my $expConfig = "";

my $cleanAll_temp;
my $cleanModels_temp;
my $thoroughly_temp;
my $makeCohortNorm_temp;
my @HViteTrainedModelConf_temp;
my @HViteWorldConf_temp;
my @hmmBaseDirWorld_temp;
my @hmmBaseDirModel_temp;
my $FA_id_temp;

###########################
# Processing Options

# flat
GetOptions('expConfig=s' => \$expConfig,
		   'c|makeCohortNorm' => \$makeCohortNorm_temp,
           'cleanAll' => \$cleanAll_temp,
		   'cleanModels' => \$cleanModels_temp,
		   'thoroughly' => \$thoroughly_temp,
		   'c|makeCohortNorm' => \$makeCohortNorm_temp,
		   'hvtc|HViteTrainedModelConf=s' => \@HViteTrainedModelConf_temp,
		   'hvwc|HViteWorldConf=s' => \@HViteWorldConf_temp,
		   'hmmBaseDirWorld=s' => \@hmmBaseDirWorld_temp,
		   'hmmBaseDirModel=s' => \@hmmBaseDirModel_temp,
		   'id|FA_id=s' => \$FA_id_temp,
           'help|?' => \$help,
           'version' => \$Identify);

if ($Identify) {
	printf "$0\n$CVS_Version_String\n$CVS_Name_String\n\n"; 
}

if ((@ARGV != 1) || ($help)) {
   pod2usage(1);
   exit 1;
 }

my $sv_system_name = $ARGV[0];

&SR_lib::init_speaker_sets($sv_system_name);

my $sv_system_path = "${SR_lib::sv_systems_dir}${sv_system_name}$SR_lib::sign";
my $experimentConfig_path = "${sv_system_path}expConfigs${SR_lib::sign}";


if ($expConfig) {
	unless (open(CONFFILE, "${experimentConfig_path}$expConfig") ) {
		die "experiment config file $expConfig not found!\n\n";
	}
	my @confContent = <CONFFILE>;
	close CONFFILE;
	
	foreach (@confContent) {
		eval($_);
		unless ($@ eq "") {
			die "error in config file $expConfig :\nline $_ \nerror: $@ \n\n";
		}
	}
}

$makeCohortNorm=$makeCohortNorm_temp if ($makeCohortNorm_temp);
$cleanAll=$cleanAll_temp if ($cleanAll_temp);
$cleanModels=$cleanModels_temp if ($cleanModels_temp);
$thoroughly=$thoroughly_temp if ($thoroughly_temp);
@HViteTrainedModelConf = @HViteTrainedModelConf_temp if (@HViteTrainedModelConf_temp);
@HViteWorldConf = @HViteWorldConf_temp if (@HViteWorldConf_temp);
@hmmBaseDirWorld = @hmmBaseDirWorld_temp if (@hmmBaseDirWorld_temp);
@hmmBaseDirModel = @hmmBaseDirModel_temp if (@hmmBaseDirModel_temp);
$FA_id = $FA_id_temp if ($FA_id_temp);


@HViteTrainedModelConf = split(',',join(',',@HViteTrainedModelConf));
@HViteWorldConf = split(',',join(',',@HViteWorldConf));
@hmmBaseDirWorld = split(',',join(',',@hmmBaseDirWorld));
@hmmBaseDirModel = split(',',join(',',@hmmBaseDirModel));

if(!(scalar(@HViteWorldConf) == scalar(@hmmBaseDirWorld)) &&
	(scalar(@HViteTrainedModelConf) == scalar(@hmmBaseDirModel)) ) 
{
		die "Length of comma separated lists must be eqal!";
}

my $numSplitsModel = scalar(@HViteTrainedModelConf) - 1;

if ($FA_id eq "") {
	# do nothing
}
else {
	$FA_id = "_" . $FA_id;
}





#####

my $temp_dir = cwd;

chdir $sv_system_path;

################
## test world ##
################

print "deleting force alignment MLFs...\n";

my ($theModelArrRef, $theSessions);

if ($thoroughly) {
	($theModelArrRef, $theSessions)  =  &SR_lib::processConfigurations('all/aa');
}
else {
	($theModelArrRef, $theSessions)  =  &SR_lib::processConfigurations($HViteWorldConf[0]);
}
my @spk_dirs = @{$theModelArrRef};
foreach my $spk_dir (@spk_dirs) {
	unlink <${spk_dir}/force_aligned${FA_id}_0*_x_model.mlf>;
	unlink <${spk_dir}/force_aligned${FA_id}_client_x_model.mlf>;
}
print "deleting info files...\n";
unlink <info/force_aligned${FA_id}_imp_x_model.info>;
unlink <info/force_aligned${FA_id}_client_x_model.info>;
unlink <info/force_aligned${FA_id}_general_HVite.info>;

if ($cleanAll) {
	print "deleting template force alignment MLFs...\n";
	my ($theModelArrRef, $theSessions);
	if ($thoroughly) {
		($theModelArrRef, $theSessions)  =  &SR_lib::processConfigurations('all/aa');
	}
	else {
		($theModelArrRef, $theSessions)  =  &SR_lib::processConfigurations($HViteWorldConf[0]);
	}
	my @spk_dirs = @{$theModelArrRef};
	foreach my $spk_dir (@spk_dirs) {
		unlink <${spk_dir}/force_aligned${FA_id}_client_x_world.mlf>;
		unlink <${spk_dir}/force_aligned${FA_id}_FAtemplate_client_x_world.mlf>;
	}
	unlink <info/force_aligned${FA_id}_client_x_world.info>;
	unlink <info/force_aligned${FA_id}_FAtemplate_client_x_world.info>;
	
	my $used_outputmlf;
	my $used_outputmlf_reg;
	my $used_outputmlf_glob;
	print "deleting world test files...\n";
	foreach my $hmmDir (@hmmBaseDirWorld) {
		if ( ($hmmDir ne "") && ($hmmDir ne ".") && ($hmmDir ne "..") && ($hmmDir ne "*")) {
			$used_outputmlf = "test_${hmmDir}";
			$used_outputmlf_reg = "world\/${used_outputmlf}_\\d+\.mlf";
			$used_outputmlf_glob = "world/${used_outputmlf}_*.mlf";
			unlink grep(/^${used_outputmlf_reg}$/,<${used_outputmlf_glob}>);

			if ($useGMM) {
				$used_outputmlf_reg = "world\/calc_GMM_world_llh_${used_outputmlf}_\\d+\.mlf\.txt";
				$used_outputmlf_glob = "world/calc_GMM_world_llh_${used_outputmlf}_*.mlf.txt";
				
				unlink grep(/^${used_outputmlf_reg}$/,<${used_outputmlf_glob}>);
			}
			else {
				$used_outputmlf_reg = "world\/hresults_${used_outputmlf}_\\d+\.mlf\.txt";
				$used_outputmlf_glob = "world/hresults_${used_outputmlf}_*.mlf.txt";
				unlink grep(/^${used_outputmlf_reg}$/,<${used_outputmlf_glob}>);
			}
		}
	}
	
}

if ($cleanModels) {
	print "deleting model dirs...\n";
	my ($theModelArrRef, $theSessions);
	if ($thoroughly) {
		($theModelArrRef, $theSessions)  =  &SR_lib::processConfigurations('all/aa');
	}
	else {
		($theModelArrRef, $theSessions)  =  &SR_lib::processConfigurations($HViteTrainedModelConf[0]);
	}
	my @spk_dirs = @{$theModelArrRef};
	foreach my $spk_dir (@spk_dirs) {
		foreach my $hmmDir (@hmmBaseDirModel) {
			if ( ($spk_dir ne "") && ($spk_dir ne ".") && ($spk_dir ne "..") && ($spk_dir ne "*") && ($hmmDir ne "") && ($hmmDir ne ".") && ($hmmDir ne "..") && ($hmmDir ne "*")) {
				my $return_code = `rm -rf ${spk_dir}/$hmmDir`;
			}
		}
	}
	foreach my $hmmDir (@hmmBaseDirWorld) {
		if ( ($hmmDir ne "") && ($hmmDir ne ".") && ($hmmDir ne "..") && ($hmmDir ne "*")) {
			my $return_code = `rm -rf world/$hmmDir`;
		}
	}
}

chdir $temp_dir;
	
exit 0;




__END__

=head1 NAME

make_clean_MASV_experiment.pl  - deletes temporary files of an experiment.

=head1 SYNOPSIS

make_clean_MASV_experiment.pl [-expConfig | options] sv_system_name

Delete files created during a run of an experiment of the SV 
system <sv_system_name>.

 Options:

 -expConfig=s             load config file from the SV system
                          directory "expConfig/". The settings can be 
                          overwritten from the command line options.

 -cleanAll                delete also force alignment files from world test
                          and templates mlfs.

 -cleanModels             delete also world models and speaker models.

 -thoroughly              clean over all speaker directories, not regarding
                          current speaker set.

 -hmmBaseDirWorld=s       use models in given directory in world directory
                          default is "hmm".
						  used here to find the world models for -cleanModels.

 -hvwc|HViteWorldConf=s   configuration when testing with world model
						  default is "all/aa".
						  used here to specify all spk dirs containing mlf files.

 -hmmBaseDirModel=s       use models in given directory in speaker directory.
                          default is "hmm".
						  used here to find all speaker model directories.

 -hvtc|HViteTrainedModelConf=s
                          configuration when testing speaker models;
						  default is "all_training/aa".
						  used here to find all speakers with models.
						  
 -id|FA_id=s              use given string to identify mlfs of this sv_system;
						  default is: "" i.e. files "forced_aligned_<client_x_model | 
						    client_x_world | 0*_x_model>.mlf" are selected.
 
 -version                 print version information.

 -? | help                display this message.
 
=cut

