#!/bin/bash


# #####################################################
#
# This file is part of the Bash scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

# '$Id: play_sound_remote.sh,v 1.5 2003/12/12 14:48:47 tuerk Exp $';
# '$Name: rel-1-4-01 $';

soundfile=$1

sourceHost=`who | grep $USER | grep phonetik | cut -d\( -f2 - | cut -d. -f1 - | uniq `
#echo $sourceHost
if test -n "$sourceHost" ; then
	if test  $sourceHost != $HOSTNAME ; then
		playingHost=$sourceHost
	else
		playingHost=$HOSTNAME
	fi
else
	playingHost=$HOSTNAME
fi	
#echo $playingHost
if test $playingHost == $HOSTNAME ; then
	status=`play -c 1 -f A -r 8000 -s b -t raw $soundfile`
else
	status=`ssh $playingHost play -c 1 -f A -r 8000 -s b -t raw $soundfile`
fi




