function loglik = log_lik_ghmm(data, prior, transmat, mu, Sigma)
% LOG_LIK_MHMM Compute the log-likelihood of a dataset using a Gaussian HMM
% loglik = log_lik_ghmm(data, prior, transmat, mu, sigma)
%
% data{m}(:,t) or data(:,t,m) if all cases have same length

if ~iscell(data)
  data = num2cell(data, [1 2]); % each elt of the 3rd dim gets its own cell
end
ncases = length(data);

loglik = 0;
for m=1:ncases
  obslik = eval_pdf_cond_gauss(data{m}, mu, Sigma);
  [alpha, beta, gamma, ll] = fwdback(prior, transmat, obslik, 'fwd_only', 1);
  loglik = loglik + ll;
end
